/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.redmine.ta.AuthenticationException;
import org.redmine.ta.NotFoundException;
import org.redmine.ta.RedmineException;
import org.redmine.ta.beans.Attachment;
import org.redmine.ta.beans.Identifiable;
import org.redmine.ta.beans.Issue;
import org.redmine.ta.beans.IssueCategory;
import org.redmine.ta.beans.IssueRelation;
import org.redmine.ta.beans.IssueStatus;
import org.redmine.ta.beans.News;
import org.redmine.ta.beans.Project;
import org.redmine.ta.beans.SavedQuery;
import org.redmine.ta.beans.TimeEntry;
import org.redmine.ta.beans.Tracker;
import org.redmine.ta.beans.User;
import org.redmine.ta.beans.Version;
import org.redmine.ta.internal.Communicator;
import org.redmine.ta.internal.RedmineXMLGenerator;
import org.redmine.ta.internal.RedmineXMLParser;
import org.redmine.ta.internal.URIConfigurator;
import org.redmine.ta.internal.logging.Logger;
import org.redmine.ta.internal.logging.LoggerFactory;

public class RedmineManager {
    private static final String CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final int DEFAULT_OBJECTS_PER_PAGE = 25;
    private Logger logger = LoggerFactory.getLogger(RedmineManager.class);
    private String host;
    private String apiAccessKey;
    private String login;
    private String password;
    private boolean useBasicAuth = false;
    private int objectsPerPage = 25;
    private MODE currentMode = MODE.REDMINE_1_1_OR_CHILIPROJECT_1_2;

    public RedmineManager(String uri) {
        if (uri == null || uri.isEmpty()) {
            throw new IllegalArgumentException("The host parameter is NULL or empty");
        }
        this.host = uri;
        this.useBasicAuth = true;
    }

    public RedmineManager(String host, String apiAccessKey) {
        this(host);
        this.apiAccessKey = apiAccessKey;
        this.useBasicAuth = false;
    }

    public RedmineManager(String uri, String login, String password) {
        this(uri);
        this.login = login;
        this.password = password;
        this.useBasicAuth = true;
    }

    public Issue createIssue(String projectKey, Issue issue) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.getURIConfigurator().createURI("issues.xml");
        HttpPost http = new HttpPost(uri);
        String xmlBody = RedmineXMLGenerator.toXML(projectKey, issue);
        this.setEntity((HttpEntityEnclosingRequest)http, xmlBody);
        String response = this.getCommunicator().sendRequest((HttpRequest)http);
        return RedmineXMLParser.parseObjectFromXML(Issue.class, response);
    }

    public void updateIssue(Issue issue) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.getURIConfigurator().getUpdateURI(issue.getClass(), Integer.toString(issue.getId()));
        HttpPut httpRequest = new HttpPut(uri);
        String NO_PROJECT_KEY = null;
        String xmlBody = RedmineXMLGenerator.toXML(NO_PROJECT_KEY, issue);
        this.setEntity((HttpEntityEnclosingRequest)httpRequest, xmlBody);
        this.getCommunicator().sendRequest((HttpRequest)httpRequest);
    }

    private void setEntity(HttpEntityEnclosingRequest request, String xmlBody) throws UnsupportedEncodingException {
        StringEntity entity = new StringEntity(xmlBody, "UTF-8");
        entity.setContentType(CONTENT_TYPE);
        request.setEntity((HttpEntity)entity);
    }

    public List<Project> getProjects() throws IOException, AuthenticationException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("include", "trackers"));
        try {
            return this.getObjectsList(Project.class, params);
        }
        catch (NotFoundException e) {
            throw new RuntimeException("NotFoundException received, which should never happen in this request");
        }
    }

    public List<Issue> getIssuesBySummary(String projectKey, String summaryField) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("subject", summaryField));
        if (projectKey != null && projectKey.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("project_id", projectKey));
        }
        return this.getObjectsList(Issue.class, params);
    }

    public List<Issue> getIssues(Map<String, String> pParameters) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        for (Map.Entry<String, String> param : pParameters.entrySet()) {
            params.add((NameValuePair)new BasicNameValuePair(param.getKey(), param.getValue()));
        }
        return this.getObjectsList(Issue.class, params);
    }

    public Issue getIssueById(Integer id, INCLUDE ... include) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        String value = RedmineManager.join(",", include);
        return this.getObject(Issue.class, id, new NameValuePair[]{new BasicNameValuePair("include", value)});
    }

    private static String join(String delimToUse, INCLUDE ... include) {
        String delim = "";
        StringBuilder sb = new StringBuilder();
        for (INCLUDE i : include) {
            sb.append(delim).append((Object)i);
            delim = delimToUse;
        }
        return sb.toString();
    }

    public Project getProjectByKey(String projectKey) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.getURIConfigurator().getUpdateURI(Project.class, projectKey, new NameValuePair[]{new BasicNameValuePair("include", "trackers")});
        HttpGet http = new HttpGet(uri);
        String response = this.getCommunicator().sendRequest((HttpRequest)http);
        return RedmineXMLParser.parseProjectFromXML(response);
    }

    public void deleteProject(String projectKey) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        this.deleteObject(Project.class, projectKey);
    }

    public void deleteIssue(Integer id) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        this.deleteObject(Issue.class, Integer.toString(id));
    }

    public List<Issue> getIssues(String projectKey, Integer queryId, INCLUDE ... include) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        if (queryId != null) {
            params.add((NameValuePair)new BasicNameValuePair("query_id", String.valueOf(queryId)));
        }
        if (projectKey != null && projectKey.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("project_id", projectKey));
        }
        String includeStr = RedmineManager.join(",", include);
        params.add((NameValuePair)new BasicNameValuePair("include", includeStr));
        return this.getObjectsList(Issue.class, params);
    }

    private <T> List<T> getObjectsListV104(Class<T> objectClass, Set<NameValuePair> params) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        ArrayList<T> objects = new ArrayList<T>();
        boolean FIRST_REDMINE_PAGE = true;
        int pageNum = 1;
        String firstPage = null;
        params.add((NameValuePair)new BasicNameValuePair("per_page", String.valueOf(this.objectsPerPage)));
        while (true) {
            ArrayList<NameValuePair> paramsList = new ArrayList<NameValuePair>(params);
            paramsList.add((NameValuePair)new BasicNameValuePair("page", String.valueOf(pageNum)));
            URI uri = this.getURIConfigurator().getRetrieveObjectsListURI(objectClass, paramsList);
            HttpGet http = new HttpGet(uri);
            String response = this.getCommunicator().sendRequest((HttpRequest)http);
            if (pageNum == 1) {
                firstPage = response;
            } else if (firstPage.equals(response)) break;
            List<T> foundItems = RedmineXMLParser.parseObjectsFromXML(objectClass, response);
            if (foundItems.size() == 0) break;
            objects.addAll(foundItems);
            ++pageNum;
        }
        return objects;
    }

    private <T> List<T> getObjectsList(Class<T> objectClass, Set<NameValuePair> params) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        if (this.currentMode.equals((Object)MODE.REDMINE_1_1_OR_CHILIPROJECT_1_2)) {
            return this.getObjectsListV11(objectClass, params);
        }
        if (this.currentMode.equals((Object)MODE.REDMINE_1_0)) {
            return this.getObjectsListV104(objectClass, params);
        }
        throw new RuntimeException("unsupported mode:" + (Object)((Object)this.currentMode) + ". supported modes are: " + (Object)((Object)MODE.REDMINE_1_0) + " and " + (Object)((Object)MODE.REDMINE_1_1_OR_CHILIPROJECT_1_2));
    }

    private <T> List<T> getObjectsListV11(Class<T> objectClass, Set<NameValuePair> params) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        int totalObjectsFoundOnServer;
        List<T> foundItems;
        ArrayList<T> objects = new ArrayList<T>();
        params.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(this.objectsPerPage)));
        int offset = 0;
        do {
            ArrayList<NameValuePair> paramsList = new ArrayList<NameValuePair>(params);
            paramsList.add((NameValuePair)new BasicNameValuePair("offset", String.valueOf(offset)));
            URI uri = this.getURIConfigurator().getRetrieveObjectsListURI(objectClass, paramsList);
            this.logger.debug(uri.toString());
            HttpGet http = new HttpGet(uri);
            String response = this.getCommunicator().sendRequest((HttpRequest)http);
            totalObjectsFoundOnServer = RedmineXMLParser.parseObjectsTotalCount(response);
            foundItems = RedmineXMLParser.parseObjectsFromXML(objectClass, response);
            if (foundItems.size() == 0) break;
            objects.addAll(foundItems);
        } while ((offset += foundItems.size()) < totalObjectsFoundOnServer);
        return objects;
    }

    private <T> T getObject(Class<T> objectClass, Integer id, NameValuePair ... params) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.getURIConfigurator().getRetrieveObjectURI(objectClass, id, new ArrayList<NameValuePair>(Arrays.asList(params)));
        String body = this.getCommunicator().sendGet(uri);
        return RedmineXMLParser.parseObjectFromXML(objectClass, body);
    }

    private <T> T createObject(Class<T> classs, T obj) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.getURIConfigurator().getCreateURI(obj.getClass());
        return this.createObject(classs, obj, uri);
    }

    private <T> T createObject(Class<T> classs, T obj, URI uri) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HttpPost http = new HttpPost(uri);
        String xml = RedmineXMLGenerator.toXML(obj);
        this.setEntity((HttpEntityEnclosingRequest)http, xml);
        String response = this.getCommunicator().sendRequest((HttpRequest)http);
        return RedmineXMLParser.parseObjectFromXML(classs, response);
    }

    public void update(Identifiable obj) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        this.validate(obj);
        URI uri = this.getURIConfigurator().getUpdateURI(obj.getClass(), Integer.toString(obj.getId()));
        HttpPut http = new HttpPut(uri);
        String xml = RedmineXMLGenerator.toXML(obj);
        this.setEntity((HttpEntityEnclosingRequest)http, xml);
        this.getCommunicator().sendRequest((HttpRequest)http);
    }

    private void validate(Identifiable obj) {
        if (obj instanceof TimeEntry && !((TimeEntry)obj).isValid()) {
            throw this.createIllegalTimeEntryException();
        }
    }

    private <T extends Identifiable> void deleteObject(Class<T> classs, String id) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.getURIConfigurator().getUpdateURI(classs, id);
        HttpDelete http = new HttpDelete(uri);
        this.getCommunicator().sendRequest((HttpRequest)http);
    }

    public Project createProject(Project project) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        URI uri = this.getURIConfigurator().createURI("projects.xml", new NameValuePair[]{new BasicNameValuePair("include", "trackers")});
        HttpPost httpPost = new HttpPost(uri);
        String createProjectXML = RedmineXMLGenerator.toXML(project);
        this.setEntity((HttpEntityEnclosingRequest)httpPost, createProjectXML);
        String response = this.getCommunicator().sendRequest((HttpRequest)httpPost);
        return RedmineXMLParser.parseProjectFromXML(response);
    }

    public void updateProject(Project project) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        this.update(project);
    }

    public int getObjectsPerPage() {
        return this.objectsPerPage;
    }

    public void setObjectsPerPage(int pageSize) {
        this.objectsPerPage = pageSize;
    }

    public List<User> getUsers() throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.getObjectsList(User.class, new HashSet<NameValuePair>());
    }

    public User getUserById(Integer userId) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.getObject(User.class, userId, new NameValuePair[0]);
    }

    public User getCurrentUser() throws IOException, AuthenticationException, RedmineException, NotFoundException {
        URI uri = this.getURIConfigurator().createURI("users/current.xml");
        HttpGet http = new HttpGet(uri);
        String response = this.getCommunicator().sendRequest((HttpRequest)http);
        return RedmineXMLParser.parseUserFromXML(response);
    }

    public User createUser(User user) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        return this.createObject(User.class, user);
    }

    public void updateUser(User user) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        this.update(user);
    }

    public void deleteUser(Integer userId) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        this.deleteObject(User.class, Integer.toString(userId));
    }

    public List<TimeEntry> getTimeEntries() throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.getObjectsList(TimeEntry.class, new HashSet<NameValuePair>());
    }

    public TimeEntry getTimeEntry(Integer id) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.getObject(TimeEntry.class, id, new NameValuePair[0]);
    }

    public List<TimeEntry> getTimeEntriesForIssue(Integer issueId) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("issue_id", Integer.toString(issueId)));
        return this.getObjectsList(TimeEntry.class, params);
    }

    public TimeEntry createTimeEntry(TimeEntry obj) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        this.validate(obj);
        return this.createObject(TimeEntry.class, obj);
    }

    public void updateTimeEntry(TimeEntry obj) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        this.update(obj);
    }

    public void deleteTimeEntry(Integer id) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        this.deleteObject(TimeEntry.class, Integer.toString(id));
    }

    private IllegalArgumentException createIllegalTimeEntryException() {
        return new IllegalArgumentException("You have to either define a Project or Issue ID for a Time Entry. The given Time Entry object has neither defined.");
    }

    public List<SavedQuery> getSavedQueries(String projectKey) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        if (projectKey != null && projectKey.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("project_id", projectKey));
        }
        return this.getObjectsList(SavedQuery.class, params);
    }

    public List<SavedQuery> getSavedQueries() throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.getObjectsList(SavedQuery.class, new HashSet<NameValuePair>());
    }

    public IssueRelation createRelation(Integer issueId, Integer issueToId, String type) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        URI uri = this.getURIConfigurator().createURI("issues/" + issueId + "/relations.xml");
        HttpPost http = new HttpPost(uri);
        IssueRelation toCreate = new IssueRelation();
        toCreate.setIssueId(issueId);
        toCreate.setIssueToId(issueToId);
        toCreate.setType(type);
        String xml = RedmineXMLGenerator.toXML(toCreate);
        this.setEntity((HttpEntityEnclosingRequest)http, xml);
        String response = this.getCommunicator().sendRequest((HttpRequest)http);
        return RedmineXMLParser.parseRelationFromXML(response);
    }

    public void deleteRelation(Integer id) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        this.deleteObject(IssueRelation.class, Integer.toString(id));
    }

    public void deleteIssueRelations(Issue redmineIssue) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        for (IssueRelation relation : redmineIssue.getRelations()) {
            this.deleteRelation(relation.getId());
        }
    }

    public void deleteIssueRelationsByIssueId(Integer id) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        Issue issue = this.getIssueById(id, INCLUDE.relations);
        this.deleteIssueRelations(issue);
    }

    public IssueRelation createRelation(String projectKey, Integer issueId, Integer issueToId, String type) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.createRelation(issueId, issueToId, type);
    }

    public List<IssueStatus> getStatuses() throws IOException, AuthenticationException, RedmineException, NotFoundException {
        return this.getObjectsList(IssueStatus.class, new HashSet<NameValuePair>());
    }

    public Version createVersion(Version version) throws IOException, AuthenticationException, RedmineException, IllegalArgumentException, NotFoundException {
        if (version.getProject() == null) {
            throw new IllegalArgumentException("Version must contain a project");
        }
        int projectID = version.getProject().getId();
        URI uri = this.getURIConfigurator().createURI("projects/" + projectID + "/versions.xml");
        HttpPost httpPost = new HttpPost(uri);
        String createVersionXML = RedmineXMLGenerator.toXML(version);
        this.setEntity((HttpEntityEnclosingRequest)httpPost, createVersionXML);
        String response = this.getCommunicator().sendRequest((HttpRequest)httpPost);
        this.logger.debug(response);
        return RedmineXMLParser.parseVersionFromXML(response);
    }

    public void deleteVersion(Version version) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        this.deleteObject(Version.class, Integer.toString(version.getId()));
    }

    public List<Version> getVersions(int projectID) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        URI uri = this.getURIConfigurator().createURI("projects/" + projectID + "/versions.xml", new NameValuePair[]{new BasicNameValuePair("include", "projects")});
        HttpGet http = new HttpGet(uri);
        String response = this.getCommunicator().sendRequest((HttpRequest)http);
        return RedmineXMLParser.parseVersionsFromXML(response);
    }

    public Version getVersionById(int versionId) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        URI uri = this.getURIConfigurator().createURI("versions/" + versionId + ".xml");
        HttpGet http = new HttpGet(uri);
        String response = this.getCommunicator().sendRequest((HttpRequest)http);
        return RedmineXMLParser.parseVersionFromXML(response);
    }

    public List<IssueCategory> getCategories(int projectID) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        URI uri = this.getURIConfigurator().createURI("projects/" + projectID + "/issue_categories.xml");
        HttpGet http = new HttpGet(uri);
        String response = this.getCommunicator().sendRequest((HttpRequest)http);
        return RedmineXMLParser.parseIssueCategoriesFromXML(response);
    }

    public IssueCategory createCategory(IssueCategory category) throws IOException, AuthenticationException, RedmineException, IllegalArgumentException, NotFoundException {
        if (category.getProject() == null) {
            throw new IllegalArgumentException("IssueCategory must contain a project");
        }
        URI uri = this.getURIConfigurator().getCreateURIIssueCategory(category.getProject().getId());
        return this.createObject(IssueCategory.class, category, uri);
    }

    public void deleteCategory(IssueCategory category) throws IOException, AuthenticationException, RedmineException, NotFoundException {
        this.deleteObject(IssueCategory.class, Integer.toString(category.getId()));
    }

    public List<Tracker> getTrackers() throws IOException, AuthenticationException, RedmineException, NotFoundException {
        return this.getObjectsList(Tracker.class, new HashSet<NameValuePair>());
    }

    public Attachment getAttachmentById(int attachmentID) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        return this.getObject(Attachment.class, attachmentID, new NameValuePair[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] downloadAttachmentContent(Attachment issueAttachment) throws IOException {
        byte[] result = null;
        URL url = new URL(issueAttachment.getContentURL());
        BufferedReader inputReader = null;
        try {
            String line;
            inputReader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder contentBuilder = new StringBuilder();
            while ((line = inputReader.readLine()) != null) {
                contentBuilder.append(line);
            }
            result = contentBuilder.toString().getBytes();
        }
        finally {
            if (inputReader != null) {
                inputReader.close();
            }
        }
        return result;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<News> getNews(String projectKey) throws IOException, AuthenticationException, NotFoundException, RedmineException {
        HashSet<NameValuePair> params = new HashSet<NameValuePair>();
        if (projectKey != null && projectKey.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("project_id", projectKey));
        }
        return this.getObjectsList(News.class, params);
    }

    private URIConfigurator getURIConfigurator() {
        URIConfigurator uriConfigurator = new URIConfigurator(this.host);
        if (!this.useBasicAuth) {
            uriConfigurator.setApiAccessKey(this.apiAccessKey);
        }
        return uriConfigurator;
    }

    private Communicator getCommunicator() {
        Communicator communicator = new Communicator();
        if (this.useBasicAuth) {
            communicator.setCredentials(this.login, this.password);
        }
        return communicator;
    }

    private static enum MODE {
        REDMINE_1_0,
        REDMINE_1_1_OR_CHILIPROJECT_1_2;

    }

    public static enum INCLUDE {
        journals,
        relations,
        attachments;

    }
}

