/*
 * Decompiled with CFR 0.152.
 */
package com.graphinout.reader.example;

import com.graphinout.base.gio.GioDocument;
import com.graphinout.base.gio.GioEdge;
import com.graphinout.base.gio.GioEndpoint;
import com.graphinout.base.gio.GioGraph;
import com.graphinout.base.gio.GioNode;
import com.graphinout.base.gio.GioReader;
import com.graphinout.base.gio.GioWriter;
import com.graphinout.base.reader.ContentError;
import com.graphinout.base.reader.GioFileFormat;
import com.graphinout.base.reader.Location;
import com.graphinout.foundation.input.InputSource;
import com.graphinout.foundation.input.SingleInputSource;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleReader
implements GioReader {
    private static final Logger log = LoggerFactory.getLogger(ExampleReader.class);
    public static final GioFileFormat FORMAT = new GioFileFormat("example", "Example Graph Format", new String[]{".example"});
    private Consumer<ContentError> errorHandler;

    public void errorHandler(Consumer<ContentError> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public GioFileFormat fileFormat() {
        return FORMAT;
    }

    public void read(InputSource inputSource, GioWriter writer) throws IOException {
        if (inputSource.isMulti()) {
            throw new IllegalArgumentException("Cannot handle multi-sources");
        }
        assert (inputSource instanceof SingleInputSource);
        SingleInputSource sis = (SingleInputSource)inputSource;
        writer.startDocument(GioDocument.builder().build());
        writer.startGraph(GioGraph.builder().build());
        writer.startNode(GioNode.builder().id("myNode1").build());
        writer.endNode(null);
        writer.startNode(GioNode.builder().id("myNode2").build());
        writer.endNode(null);
        writer.startEdge(GioEdge.builder().endpoints(Arrays.asList(GioEndpoint.builder().id("myNode1").build(), GioEndpoint.builder().id("myNode2").build())).build());
        writer.endEdge();
        this.errorHandler.accept(new ContentError(ContentError.ErrorLevel.Warn, " To be honest, we did not really read the input :-)", new Location(1, 1)));
        writer.endGraph(null);
        writer.endDocument();
    }
}

