/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.exception;

import com.graphql_java_generator.client.response.Error;
import java.util.ArrayList;
import java.util.List;

public class GraphQLRequestExecutionException
extends Exception {
    private static final long serialVersionUID = 2L;
    final List<Error> errors;

    public GraphQLRequestExecutionException(String msg) {
        super(msg);
        this.errors = new ArrayList<Error>();
    }

    public GraphQLRequestExecutionException(String msg, Throwable cause) {
        super(msg, cause);
        this.errors = new ArrayList<Error>();
    }

    public GraphQLRequestExecutionException(List<Error> errors) {
        this(null, errors);
    }

    public GraphQLRequestExecutionException(String msg, List<Error> errors) {
        super(GraphQLRequestExecutionException.buildMessage(null, errors));
        this.errors = errors == null ? new ArrayList() : errors;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    private static String buildMessage(String msg, List<Error> errorsParam) {
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            sb.append(msg).append(": ");
        }
        if (errorsParam == null || errorsParam.size() == 0) {
            sb.append("Unknown error");
        } else {
            sb.append(errorsParam.size());
            sb.append(" error(s) occurred: ");
            boolean first = true;
            for (Error error : errorsParam) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(error.getMessage());
            }
        }
        return sb.toString();
    }
}

