/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.client.RequestExecution;
import com.graphql_java_generator.client.RequestExecutionImpl;
import com.graphql_java_generator.client.RequestExecutionSpringReactiveImpl;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.netty.http.client.HttpClient;

public class GraphQLConfiguration {
    final RequestExecution requestExecutor;

    public GraphQLConfiguration(RequestExecution requestExecutor) {
        this.requestExecutor = requestExecutor;
    }

    public GraphQLConfiguration(String graphqlEndpoint) {
        this.requestExecutor = new RequestExecutionSpringReactiveImpl(graphqlEndpoint, null, GraphQLConfiguration.getWebClient(graphqlEndpoint, null, null, (ExchangeFilterFunction[])null), GraphQLConfiguration.getWebSocketClient(null), null, null);
    }

    public static WebClient getWebClient(String graphqlEndpoint, HttpClient httpClient, ExchangeFilterFunction ... filters) {
        return GraphQLConfiguration.getWebClient(graphqlEndpoint, null, httpClient, filters);
    }

    public static WebClient getWebClient(String graphqlEndpoint, CodecCustomizer codecCustomizer, HttpClient httpClient, ExchangeFilterFunction ... filters) {
        WebClient.Builder webClientBuilder = WebClient.builder().baseUrl(graphqlEndpoint).defaultHeader("Content-Type", new String[]{"application/json"}).defaultUriVariables(Collections.singletonMap("url", graphqlEndpoint));
        if (codecCustomizer != null) {
            webClientBuilder.codecs(configurer -> codecCustomizer.customize((CodecConfigurer)configurer));
        }
        if (httpClient != null) {
            webClientBuilder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient));
        }
        if (filters != null) {
            for (ExchangeFilterFunction filter : filters) {
                if (filter == null) continue;
                webClientBuilder.filter(filter);
            }
        }
        return webClientBuilder.build();
    }

    public static WebSocketClient getWebSocketClient(HttpClient httpClient) {
        if (httpClient == null) {
            return new ReactorNettyWebSocketClient(HttpClient.create());
        }
        return new ReactorNettyWebSocketClient(httpClient);
    }

    @Deprecated
    public GraphQLConfiguration(String graphqlEndpoint, SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        this.requestExecutor = new RequestExecutionImpl(graphqlEndpoint, sslContext, hostnameVerifier);
    }

    @Deprecated
    public GraphQLConfiguration(String graphqlEndpoint, Client client) {
        this.requestExecutor = new RequestExecutionImpl(graphqlEndpoint, client);
    }

    public RequestExecution getQueryExecutor() {
        return this.requestExecutor;
    }
}

