/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.graphql_java_generator.annotation.RequestType;
import com.graphql_java_generator.client.GraphQLObjectMapper;
import com.graphql_java_generator.client.GraphQLReactiveWebSocketHandler;
import com.graphql_java_generator.client.GraphQLRequestObject;
import com.graphql_java_generator.client.OAuthTokenExtractor;
import com.graphql_java_generator.client.RequestExecution;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.client.SubscriptionClient;
import com.graphql_java_generator.client.request.AbstractGraphQLRequest;
import com.graphql_java_generator.client.response.JsonResponseWrapper;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import java.io.IOException;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Mono;

public class RequestExecutionSpringReactiveImpl
implements RequestExecution {
    private static Logger logger = LoggerFactory.getLogger(RequestExecutionSpringReactiveImpl.class);
    final WebClient webClient;
    final GraphQLReactiveWebSocketHandler webSocketHandler;

    @Autowired
    public RequestExecutionSpringReactiveImpl(String graphqlEndpoint, String graphqlSubscriptionEndpoint, WebClient webClient, WebSocketClient webSocketClient, ServerOAuth2AuthorizedClientExchangeFilterFunction serverOAuth2AuthorizedClientExchangeFilterFunction, OAuthTokenExtractor oAuthTokenExtractor) {
        this.webClient = webClient;
        this.webSocketHandler = new GraphQLReactiveWebSocketHandler(graphqlEndpoint, graphqlSubscriptionEndpoint, webSocketClient, serverOAuth2AuthorizedClientExchangeFilterFunction, oAuthTokenExtractor);
    }

    @Override
    public <R extends GraphQLRequestObject> R execute(AbstractGraphQLRequest graphQLRequest, Map<String, Object> parameters, Class<R> dataResponseType) throws GraphQLRequestExecutionException {
        String jsonRequest = "not initialized yet";
        if (graphQLRequest.getRequestType().equals((Object)RequestType.subscription)) {
            throw new GraphQLRequestExecutionException("This method may not be called for subscriptions");
        }
        try {
            jsonRequest = graphQLRequest.getJsonRequest(parameters);
            logger.trace(GRAPHQL_MARKER, "Executing GraphQL request: {}", (Object)jsonRequest);
            JsonResponseWrapper responseJson = (JsonResponseWrapper)this.webClient.post().contentType(MediaType.APPLICATION_JSON).body((Publisher)Mono.just((Object)jsonRequest), String.class).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().bodyToMono(JsonResponseWrapper.class).block();
            return RequestExecutionSpringReactiveImpl.parseDataFromGraphQLServerResponse(graphQLRequest.getGraphQLObjectMapper(), responseJson, dataResponseType);
        }
        catch (IOException e) {
            throw new GraphQLRequestExecutionException("Error when executing query <" + jsonRequest + ">: " + e.getMessage(), e);
        }
    }

    @Override
    public <R, T> SubscriptionClient execute(AbstractGraphQLRequest graphQLRequest, Map<String, Object> parameters, SubscriptionCallback<T> subscriptionCallback, Class<R> subscriptionType, Class<T> messageType) throws GraphQLRequestExecutionException {
        if (!graphQLRequest.getRequestType().equals((Object)RequestType.subscription)) {
            throw new GraphQLRequestExecutionException("This method may be called only for subscriptions");
        }
        if (graphQLRequest.getSubscription().getFields().size() != 1) {
            throw new GraphQLRequestExecutionException("This method may be called only for one subscription at a time, but there was " + graphQLRequest.getSubscription().getFields().size() + " subscriptions in this GraphQLRequest");
        }
        return this.webSocketHandler.executeSubscription(graphQLRequest, parameters, subscriptionCallback, subscriptionType, messageType);
    }

    static <T extends GraphQLRequestObject> T parseDataFromGraphQLServerResponse(GraphQLObjectMapper objectMapper2, JsonResponseWrapper response, Class<T> valueType) throws GraphQLRequestExecutionException, JsonProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace("Response data: {}", (Object)objectMapper2.writeValueAsString(response.data));
            logger.trace("Response errors: {}", (Object)objectMapper2.writeValueAsString(response.errors));
        }
        if (response.errors == null || response.errors.size() == 0) {
            GraphQLRequestObject ret = (GraphQLRequestObject)objectMapper2.treeToValue((TreeNode)response.data, valueType);
            ret.setExtensions(response.extensions);
            return (T)ret;
        }
        throw new GraphQLRequestExecutionException(response.errors);
    }
}

