/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.exception;

import com.graphql_java_generator.exception.GraphQLRequestExecutionExceptionInterface;
import java.util.List;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.client.ClientGraphQlResponse;

public class GraphQLRequestExecutionException
extends Exception
implements GraphQLRequestExecutionExceptionInterface {
    private static final long serialVersionUID = 1L;
    private final List<ResponseError> errors;
    private final Object data;
    private final ClientGraphQlResponse response;

    public GraphQLRequestExecutionException(String msg) {
        super(msg);
        this.errors = null;
        this.data = null;
        this.response = null;
    }

    public GraphQLRequestExecutionException(String msg, Throwable cause) {
        super(msg, cause);
        this.errors = null;
        this.data = null;
        this.response = null;
    }

    public GraphQLRequestExecutionException(List<ResponseError> errors, Object data, ClientGraphQlResponse response) {
        super(GraphQLRequestExecutionException.buildMessage(errors));
        this.errors = errors;
        this.data = data;
        this.response = response;
    }

    @Override
    public List<ResponseError> getErrors() {
        return this.errors;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public ClientGraphQlResponse getResponse() {
        return this.response;
    }

    private static String buildMessage(List<ResponseError> errors) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (errors == null || errors.size() == 0) {
            sb.append("Unknown error");
        } else {
            sb.append(errors.size());
            sb.append(" error(s) occurred: ");
            for (ResponseError error : errors) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(error.getMessage());
            }
        }
        return sb.toString();
    }
}

