/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphql_java_generator.annotation.GraphQLIgnore;
import com.graphql_java_generator.annotation.GraphQLInputParameters;
import com.graphql_java_generator.annotation.GraphQLInputType;
import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.client.CustomScalarRegistryImpl;
import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.client.directive.Directive;
import com.graphql_java_generator.client.directive.DirectiveRegistry;
import com.graphql_java_generator.client.directive.DirectiveRegistryImpl;
import com.graphql_java_generator.client.request.QueryTokenizer;
import com.graphql_java_generator.client.request.RawGraphQLString;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;
import graphql.GraphQLContext;
import graphql.schema.GraphQLScalarType;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.text.StringEscapeUtils;

public class InputParameter {
    DirectiveRegistry directiveRegistry = DirectiveRegistryImpl.directiveRegistry;
    private static GraphqlUtils graphqlUtils = new GraphqlUtils();
    private static GraphqlClientUtils graphqlClientUtils = new GraphqlClientUtils();
    final String schema;
    final String name;
    final String bindParameterName;
    final Object value;
    final InputParameterType type;
    final String graphQLTypeName;
    final GraphQLScalarType graphQLScalarType;
    private final boolean itemMandatory;
    private final int listDepth;
    private final boolean mandatory;

    public static InputParameter newBindParameter(String schema, String name, String bindParameterName, InputParameterType type, String graphQLTypeName, boolean mandatory, int listDepth, boolean itemMandatory) {
        if (bindParameterName == null) {
            throw new NullPointerException("[Internal error] The bind parameter name is mandatory");
        }
        return new InputParameter(schema, name, bindParameterName, null, type, graphQLTypeName, mandatory, listDepth, itemMandatory);
    }

    public static InputParameter newGraphQLVariableParameter(String schema, String name, String graphQLTypeName, boolean mandatory, int listDepth, boolean itemMandatory) {
        return new InputParameter(schema, name, name, null, InputParameterType.GRAPHQL_VARIABLE, graphQLTypeName, mandatory, listDepth, itemMandatory);
    }

    public static InputParameter newHardCodedParameter(String schema, String name, Object value, String graphQLTypeName, boolean mandatory, int listDepth, boolean itemMandatory) {
        return new InputParameter(schema, name, null, value, InputParameterType.HARD_CODED, graphQLTypeName, mandatory, listDepth, itemMandatory);
    }

    private InputParameter(String schema, String name, String bindParameterName, Object value, InputParameterType type, String graphQLTypeName, boolean mandatory, int listDepth, boolean itemMandatory) {
        if (name == null) {
            throw new NullPointerException("The input parameter's name is mandatory");
        }
        this.schema = schema;
        this.name = name;
        this.bindParameterName = bindParameterName;
        this.value = value;
        this.type = type;
        this.graphQLTypeName = graphQLTypeName;
        this.graphQLScalarType = graphQLTypeName == null ? null : graphqlClientUtils.getGraphQLScalarTypeFromName(graphQLTypeName, schema);
        this.mandatory = mandatory;
        this.listDepth = listDepth;
        this.itemMandatory = itemMandatory;
    }

    private InputParameter(String schema, String name, String parameterName, Object value, InputParameterType type, Directive directive, Class<?> owningClass, String fieldName) throws GraphQLRequestPreparationException {
        String localGraphQLCustomScalarType = null;
        boolean localMandatory = false;
        int localList = 0;
        boolean localItemMandatory = false;
        if (name == null) {
            throw new NullPointerException("The input parameter's name is mandatory");
        }
        if (directive != null) {
            Directive dirDef = this.directiveRegistry.getDirective(directive.getName());
            if (dirDef == null) {
                throw new GraphQLRequestPreparationException("Could not find directive definition for the directive '" + directive.getName() + "'");
            }
            boolean found = false;
            for (InputParameter param : dirDef.getArguments()) {
                if (!param.getName().equals(name)) continue;
                found = true;
                localGraphQLCustomScalarType = param.getGraphQLTypeName();
                localMandatory = param.isMandatory();
                localList = param.getListDepth();
                localItemMandatory = param.isItemMandatory();
            }
            if (!found) {
                throw new GraphQLRequestPreparationException("The parameter of name '" + name + "' has not been found for the directive '" + directive.getName() + "'");
            }
        } else {
            GraphQLInputParameters inputParams;
            if (owningClass.isInterface()) {
                try {
                    Method method = owningClass.getMethod("get" + graphqlUtils.getPascalCase(graphqlUtils.getJavaName(fieldName)), new Class[0]);
                    inputParams = method.getAnnotation(GraphQLInputParameters.class);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new GraphQLRequestPreparationException("Error while looking for the the getter for <" + fieldName + "> in the interface '" + owningClass.getName() + "'", e);
                }
            }
            try {
                Field field = owningClass.getDeclaredField(graphqlUtils.getJavaName(fieldName));
                inputParams = field.getAnnotation(GraphQLInputParameters.class);
            }
            catch (NoSuchFieldException | SecurityException e) {
                try {
                    Field field = owningClass.getSuperclass().getDeclaredField(graphqlUtils.getJavaName(fieldName));
                    inputParams = field.getAnnotation(GraphQLInputParameters.class);
                }
                catch (NoSuchFieldException | SecurityException e2) {
                    throw new GraphQLRequestPreparationException("Error while looking for the the field <" + fieldName + "> in the class '" + owningClass.getName() + "', not in its superclass: " + owningClass.getSuperclass().getName(), e);
                }
            }
            if (inputParams == null) {
                throw new GraphQLRequestPreparationException("The field <" + fieldName + "> of the class '" + owningClass.getName() + "' has no input parameters. Error while looking for its '" + parameterName + "' input parameter");
            }
            boolean found = false;
            for (int i = 0; i < inputParams.names().length; ++i) {
                if (!inputParams.names()[i].equals(name)) continue;
                found = true;
                localGraphQLCustomScalarType = inputParams.types()[i];
                localMandatory = inputParams.mandatories()[i];
                localList = inputParams.listDepths()[i];
                localItemMandatory = inputParams.itemsMandatory()[i];
            }
            if (!found) {
                throw new GraphQLRequestPreparationException("The parameter of name <" + parameterName + "> has not been found for the field <" + fieldName + "> of the class '" + owningClass.getName() + "'");
            }
        }
        this.schema = schema;
        this.name = name;
        this.bindParameterName = parameterName;
        this.value = value;
        this.type = type;
        this.graphQLTypeName = localGraphQLCustomScalarType;
        this.graphQLScalarType = graphqlClientUtils.getGraphQLScalarTypeFromName(this.graphQLTypeName, schema);
        this.mandatory = localMandatory;
        this.listDepth = localList;
        this.itemMandatory = localItemMandatory;
    }

    public static List<InputParameter> readTokenizerForInputParameters(QueryTokenizer qt, Directive directive, Class<?> owningClass, String fieldName, String schema) throws GraphQLRequestPreparationException {
        ArrayList<InputParameter> ret = new ArrayList<InputParameter>();
        InputParameterStep step = InputParameterStep.NAME;
        String parameterName = null;
        block14: while (qt.hasMoreTokens()) {
            String token;
            switch (token = qt.nextToken()) {
                case ":": {
                    continue block14;
                }
                case ",": {
                    if (step == InputParameterStep.NAME) continue block14;
                    throw new GraphQLRequestPreparationException("Misplaced comma for the field '" + fieldName + "' is not finished (no closing parenthesis)");
                }
                case ")": {
                    if (parameterName == null) {
                        throw new GraphQLRequestPreparationException("Misplaced closing parenthesis for the field '" + fieldName + "' (no parameter has been read)");
                    }
                    if (step != InputParameterStep.NAME) {
                        throw new GraphQLRequestPreparationException("Misplaced closing parenthesis for the field '" + fieldName + "' is not finished (no closing parenthesis)");
                    }
                    return ret;
                }
            }
            switch (step) {
                case NAME: {
                    parameterName = token;
                    step = InputParameterStep.VALUE;
                    break;
                }
                case VALUE: {
                    if (token.startsWith("?")) {
                        ret.add(new InputParameter(schema, parameterName, token.substring(1), null, InputParameterType.OPTIONAL, directive, owningClass, fieldName));
                    } else if (token.startsWith("&")) {
                        ret.add(new InputParameter(schema, parameterName, token.substring(1), null, InputParameterType.MANDATORY, directive, owningClass, fieldName));
                    } else if (token.startsWith("$")) {
                        ret.add(new InputParameter(schema, parameterName, token.substring(1), null, InputParameterType.GRAPHQL_VARIABLE, directive, owningClass, fieldName));
                    } else if (token.equals("[") || token.equals("{")) {
                        sb = new StringBuilder(token);
                        boolean list = token.startsWith("[");
                        int listDepth = 0;
                        boolean withinAString = false;
                        int recursiveLevel = 1;
                        while (true) {
                            if (!qt.hasMoreTokens(true)) {
                                throw new GraphQLRequestPreparationException("Found the end of the GraphQL request before the end of the " + (list ? "list" : "object") + ": '" + sb.toString() + "'");
                            }
                            String previousToken = token;
                            token = qt.nextToken(true);
                            sb.append(token);
                            if (!(!token.contentEquals("\"") || withinAString && previousToken.endsWith("\\"))) {
                                boolean bl = withinAString = !withinAString;
                            }
                            if (withinAString) continue;
                            if (list && token.equals("[") || !list && token.equals("{")) {
                                ++recursiveLevel;
                                continue;
                            }
                            if ((list && token.equals("]") || !list && token.equals("}")) && --recursiveLevel == 0) break;
                        }
                        ret.add(new InputParameter(schema, parameterName, null, new RawGraphQLString(sb.toString()), InputParameterType.GRAPHQL_VALUE, null, false, listDepth, false));
                    } else if (token.equals("\"")) {
                        sb = new StringBuilder();
                        boolean nextCharIsEscaped = false;
                        while (true) {
                            if (!qt.hasMoreTokens(true)) {
                                throw new GraphQLRequestPreparationException("Found the end of the GraphQL request before the end of the string parameter '" + sb.toString() + "'");
                            }
                            token = qt.nextToken(true);
                            if (!nextCharIsEscaped && token.equals("\"")) break;
                            nextCharIsEscaped = !nextCharIsEscaped ? token.equals("\\") : false;
                            sb.append(token);
                        }
                        RawGraphQLString str = new RawGraphQLString(StringEscapeUtils.unescapeJson((String)sb.toString()));
                        ret.add(new InputParameter(schema, parameterName, null, str, InputParameterType.HARD_CODED, "String", true, 0, false));
                    } else {
                        if (token.startsWith("\"") || token.endsWith("\"")) {
                            throw new GraphQLRequestPreparationException("Bad parameter value: parameter values should start and finish by \", or not having any \" at the beginning and end. But it's not the case for the value <" + token + "> of parameter <" + parameterName + ">. Maybe you wanted to add a bind parameter instead (bind parameter must start with a ? or a &");
                        }
                        if (directive != null) {
                            parameterValue = InputParameter.parseDirectiveArgumentValue(schema, directive, parameterName, token);
                            InputParameter arg = new InputParameter(schema, parameterName, null, parameterValue, InputParameterType.HARD_CODED, null, true, 0, false);
                            ret.add(arg);
                            directive.getArguments().add(arg);
                        } else {
                            parameterValue = InputParameter.parseInputParameterValue(schema, owningClass, fieldName, parameterName, token);
                            ret.add(new InputParameter(schema, parameterName, null, parameterValue, InputParameterType.HARD_CODED, null, true, 0, false));
                        }
                    }
                    step = InputParameterStep.NAME;
                }
            }
        }
        throw new GraphQLRequestPreparationException("The list of parameters for the field '" + fieldName + "' is not finished (no closing parenthesis)");
    }

    private static Object parseInputParameterValue(String schema, Class<?> owningClass, String fieldName, String parameterName, String parameterValue) throws GraphQLRequestPreparationException {
        Field field = graphqlClientUtils.getDeclaredField(owningClass, graphqlUtils.getJavaName(fieldName), true);
        GraphQLInputParameters graphQLInputParameters = field.getDeclaredAnnotation(GraphQLInputParameters.class);
        if (graphQLInputParameters == null) {
            throw new GraphQLRequestPreparationException("[Internal error] The field '" + fieldName + "' is lacking the GraphQLInputParameters annotation");
        }
        for (int i = 0; i < graphQLInputParameters.names().length; ++i) {
            if (!graphQLInputParameters.names()[i].equals(parameterName)) continue;
            try {
                return InputParameter.parseValueForInputParameter(schema, parameterValue, graphQLInputParameters.types()[i], owningClass.getPackage().getName());
            }
            catch (Exception e) {
                throw new GraphQLRequestPreparationException("Could not read the value for the parameter '" + parameterName + "' of the field '" + fieldName + "' of the type '" + owningClass.getName() + "'", e);
            }
        }
        throw new GraphQLRequestPreparationException("[Internal error] Can't find the type for the parameter '" + parameterName + "' of the field '" + fieldName + "'");
    }

    private static Object parseDirectiveArgumentValue(String schema, Directive directive, String parameterName, String parameterValue) throws GraphQLRequestPreparationException {
        Directive directiveDefinition = directive.getDirectiveDefinition();
        for (InputParameter param : directiveDefinition.getArguments()) {
            if (!param.getName().equals(parameterName)) continue;
            try {
                return InputParameter.parseValueForInputParameter(schema, parameterValue, param.getGraphQLTypeName(), directive.getPackageName());
            }
            catch (Exception e) {
                throw new GraphQLRequestPreparationException("Could not read the value for the parameter '" + parameterName + "' of the directive '" + directive.getName() + "'", e);
            }
        }
        throw new GraphQLRequestPreparationException("[Internal error] Can't find the argument '" + parameterName + "' of the directive '" + directive.getName() + "'");
    }

    private static Object parseValueForInputParameter(String schema, String parameterValue, String parameterType, String packageName) throws GraphQLRequestPreparationException {
        try {
            return graphqlClientUtils.parseValueForInputParameter(parameterValue, parameterType, graphqlClientUtils.getClass(packageName, parameterType, schema), schema);
        }
        catch (RuntimeException e) {
            throw new GraphQLRequestPreparationException(e.getMessage(), e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValueForGraphqlQuery(Map<String, Object> bindVariables) {
        return InputParameter.getValueForGraphqlQuery(this.bindParameterName, bindVariables.get(this.bindParameterName), this.listDepth, this.graphQLScalarType, bindVariables);
    }

    public static Object getValueForGraphqlQuery(String parameterName, Object val, int listDepth, GraphQLScalarType graphQLScalarTypeParam, Map<String, Object> bindVariables) {
        if (val == null) {
            return null;
        }
        if (listDepth > 0) {
            if (val.getClass().isArray()) {
                return InputParameter.getValueForAListValue(parameterName, Arrays.asList((Object[])val), listDepth, graphQLScalarTypeParam, bindVariables);
            }
            if (val instanceof List) {
                return InputParameter.getValueForAListValue(parameterName, (List)val, listDepth, graphQLScalarTypeParam, bindVariables);
            }
            throw new IllegalArgumentException("The given value for the parameter '" + parameterName + "' should be either an array or a list, but is a " + val.getClass().getName());
        }
        if (graphQLScalarTypeParam != null) {
            return graphQLScalarTypeParam.getCoercing().serialize(val, GraphQLContext.getDefault(), Locale.getDefault());
        }
        return val;
    }

    private static Object getValueForAListValue(String parameterName, List<?> list, int listDepth, GraphQLScalarType graphQLScalarTypeParam, Map<String, Object> bindVariables) {
        ArrayList<Object> ret = new ArrayList<Object>(list.size());
        for (Object v : list) {
            ret.add(InputParameter.getValueForGraphqlQuery(parameterName, v, listDepth - 1, graphQLScalarTypeParam, bindVariables));
        }
        return ret;
    }

    public String getStringContentForGraphqlQuery(boolean writingGraphQLVariables, Map<String, Object> bindVariables) throws GraphQLRequestExecutionException {
        if (this.bindParameterName == null) {
            return this.getStringContentForGraphqlQuery(writingGraphQLVariables, this.value, this.listDepth, this.graphQLTypeName, this.graphQLScalarType, false);
        }
        if (!(!this.type.equals((Object)InputParameterType.MANDATORY) && !this.type.equals((Object)InputParameterType.GRAPHQL_VARIABLE) || bindVariables != null && bindVariables.keySet().contains(this.bindParameterName))) {
            throw new GraphQLRequestExecutionException("The Bind Parameter for '" + this.bindParameterName + "' must be provided in the BindVariables map");
        }
        if (bindVariables == null || !bindVariables.keySet().contains(this.bindParameterName)) {
            return null;
        }
        return this.getStringContentForGraphqlQuery(writingGraphQLVariables, bindVariables.get(this.bindParameterName), this.listDepth, this.graphQLTypeName, this.graphQLScalarType, this.type.equals((Object)InputParameterType.GRAPHQL_VARIABLE));
    }

    String getStringContentForGraphqlQuery(boolean writingGraphQLVariables, Object val, int listDepth, String graphQLTypeNameParam, GraphQLScalarType graphQLScalarTypeParam, boolean graphQLVariable) throws GraphQLRequestExecutionException {
        if (val == null) {
            return null;
        }
        if (graphQLVariable && !writingGraphQLVariables) {
            return "$" + this.bindParameterName;
        }
        if (listDepth > 0) {
            return this.getStringContentForAListValue(writingGraphQLVariables, val, listDepth, graphQLTypeNameParam, graphQLScalarTypeParam, graphQLVariable);
        }
        if (graphQLScalarTypeParam != null) {
            Object ret = graphQLScalarTypeParam.getCoercing().serialize(val, GraphQLContext.getDefault(), Locale.getDefault());
            if (ret instanceof String) {
                return this.getStringValue((String)ret);
            }
            if (ret instanceof ObjectNode) {
                StringBuilder sb = new StringBuilder();
                this.appendStringContentForGraphqlQueryFromObjectNode(sb, ((ObjectNode)ret).traverse(), (ObjectNode)ret);
                return sb.toString();
            }
            if (ret instanceof Map) {
                StringBuilder sb = new StringBuilder();
                this.appendStringContentForGraphqlQueryFromMap(sb, (Map)ret);
                return sb.toString();
            }
            if (ret instanceof List) {
                StringBuilder sb = new StringBuilder();
                this.appendStringContentForGraphqlQueryFromMapForAListItem(sb, (List)ret);
                return sb.toString();
            }
            return ret.toString();
        }
        if (writingGraphQLVariables && val.getClass().isEnum()) {
            return "\"" + val.toString() + "\"";
        }
        if (val instanceof RawGraphQLString) {
            return ((RawGraphQLString)val).toString();
        }
        if (val instanceof String) {
            return this.getStringValue((String)val);
        }
        if (val instanceof UUID) {
            return this.getStringValue(((UUID)val).toString());
        }
        if (val.getClass().getAnnotation(GraphQLInputType.class) != null) {
            return this.getStringContentForAnInputTypeValue(writingGraphQLVariables, val, listDepth, graphQLVariable);
        }
        if (val.getClass().isEnum()) {
            return (String)graphqlUtils.invokeMethod("graphQlValue", val, new Object[0]);
        }
        return val.toString();
    }

    private void appendStringContentForGraphqlQueryFromObjectNode(StringBuilder sb, JsonParser jsonParser, ObjectNode node) throws GraphQLRequestExecutionException {
        try {
            JsonToken token = jsonParser.nextToken();
            boolean objectJustStarted = false;
            boolean inArray = false;
            boolean arrayJustStarted = false;
            while (jsonParser.hasCurrentToken()) {
                switch (token) {
                    case START_OBJECT: {
                        sb.append("{");
                        objectJustStarted = true;
                        break;
                    }
                    case END_OBJECT: {
                        sb.append("}");
                        break;
                    }
                    case START_ARRAY: {
                        sb.append("[");
                        inArray = true;
                        arrayJustStarted = true;
                        break;
                    }
                    case END_ARRAY: {
                        sb.append("]");
                        break;
                    }
                    case FIELD_NAME: {
                        if (objectJustStarted) {
                            objectJustStarted = false;
                        } else {
                            sb.append(",");
                        }
                        sb.append(jsonParser.getText());
                        sb.append(":");
                        this.appendStringContentForGraphqlQueryFromObjectNode(sb, jsonParser, node);
                        break;
                    }
                    case VALUE_EMBEDDED_OBJECT: {
                        sb.append(jsonParser.getText());
                        break;
                    }
                    case VALUE_STRING: {
                        if (arrayJustStarted) {
                            arrayJustStarted = false;
                        } else if (inArray) {
                            sb.append(",");
                        }
                        sb.append('\"');
                        sb.append(jsonParser.getText());
                        sb.append('\"');
                        break;
                    }
                    case VALUE_NUMBER_INT: {
                        if (arrayJustStarted) {
                            arrayJustStarted = false;
                        } else if (inArray) {
                            sb.append(",");
                        }
                        sb.append(jsonParser.getIntValue());
                        break;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        if (arrayJustStarted) {
                            arrayJustStarted = false;
                        } else if (inArray) {
                            sb.append(",");
                        }
                        sb.append(jsonParser.getFloatValue());
                        break;
                    }
                    case VALUE_TRUE: {
                        if (arrayJustStarted) {
                            arrayJustStarted = false;
                        } else if (inArray) {
                            sb.append(",");
                        }
                        sb.append("true");
                        break;
                    }
                    case VALUE_FALSE: {
                        if (arrayJustStarted) {
                            arrayJustStarted = false;
                        } else if (inArray) {
                            sb.append(",");
                        }
                        sb.append("false");
                        break;
                    }
                    case VALUE_NULL: {
                        if (arrayJustStarted) {
                            arrayJustStarted = false;
                        } else if (inArray) {
                            sb.append(",");
                        }
                        sb.append("null");
                        break;
                    }
                    default: {
                        throw new GraphQLRequestExecutionException("Unexpected token type while writing an ObjectNode into the GraphQL request: " + token.name() + ". The json being read is: " + node.toString());
                    }
                }
                token = jsonParser.nextToken();
            }
        }
        catch (IOException e) {
            throw new GraphQLRequestExecutionException(e.getMessage() + " (while writing an ObjectNode into the GraphQL request)", e);
        }
    }

    private void appendStringContentForGraphqlQueryFromMap(StringBuilder sb, Map<?, ?> map) {
        boolean appendComma = false;
        sb.append('{');
        for (Object key : map.keySet()) {
            if (appendComma) {
                sb.append(',');
            } else {
                appendComma = true;
            }
            sb.append(key);
            sb.append(':');
            this.appendStringContentForGraphqlQueryFromValueItem(sb, map.get(key));
        }
        sb.append('}');
    }

    private void appendStringContentForGraphqlQueryFromMapForAListItem(StringBuilder sb, List<?> list) {
        boolean appendComma = false;
        sb.append('[');
        for (Object val : list) {
            if (appendComma) {
                sb.append(',');
            } else {
                appendComma = true;
            }
            this.appendStringContentForGraphqlQueryFromValueItem(sb, val);
        }
        sb.append(']');
    }

    private void appendStringContentForGraphqlQueryFromValueItem(StringBuilder sb, Object value) {
        if (value instanceof Map) {
            this.appendStringContentForGraphqlQueryFromMap(sb, (Map)value);
        } else if (value instanceof List) {
            this.appendStringContentForGraphqlQueryFromMapForAListItem(sb, (List)value);
        } else if (value instanceof String) {
            sb.append('\"');
            sb.append(value);
            sb.append('\"');
        } else {
            sb.append(value.toString());
        }
    }

    private String getStringValue(String str) {
        String r = "\"" + StringEscapeUtils.escapeJson((String)str) + "\"";
        return r;
    }

    private String getStringContentForAListValue(boolean writingGraphQLVariables, Object list, int listDepth, String graphQLTypeNameParam, GraphQLScalarType graphQLScalarTypeParam, boolean graphQLVariable) throws GraphQLRequestExecutionException {
        List localList;
        StringBuilder result = new StringBuilder("[");
        if (list.getClass().isArray()) {
            localList = Arrays.asList((Object[])list);
        } else if (list instanceof List) {
            localList = (List)list;
        } else {
            throw new GraphQLRequestExecutionException("Unexpected type for the parameter  '" + this.name + "': it should be either a java.lang.List or an Array, but is " + list.getClass().getName());
        }
        for (int index = 0; index < localList.size(); ++index) {
            Object obj = localList.get(index);
            result.append(this.getStringContentForGraphqlQuery(writingGraphQLVariables, obj, listDepth - 1, graphQLTypeNameParam, graphQLScalarTypeParam, graphQLVariable));
            if (index >= localList.size() - 1) continue;
            result.append(",");
        }
        return result.append("]").toString();
    }

    private String getStringContentForAnInputTypeValue(boolean writingGraphQLVariables, Object object, int listDepth, boolean graphQLVariable) throws GraphQLRequestExecutionException {
        StringBuilder result = new StringBuilder("{");
        String separator = "";
        for (Field field : object.getClass().getDeclaredFields()) {
            String fieldName;
            Object val;
            if (field.isSynthetic() || field.getAnnotation(GraphQLIgnore.class) != null || (val = graphqlUtils.invokeGetter(object, field.getName())) == null) continue;
            int fieldListDepth = 0;
            String fieldGraphQLTypeName = null;
            GraphQLScalarType fieldGraphQLType = null;
            GraphQLScalar graphQLScalar = field.getAnnotation(GraphQLScalar.class);
            GraphQLNonScalar graphQLNonScalar = field.getAnnotation(GraphQLNonScalar.class);
            if (graphQLScalar != null) {
                fieldName = graphQLScalar.fieldName();
                fieldListDepth = graphQLScalar.listDepth();
                fieldGraphQLTypeName = graphQLScalar.graphQLTypeSimpleName();
                if (fieldGraphQLTypeName != null) {
                    fieldGraphQLType = CustomScalarRegistryImpl.getCustomScalarRegistry(this.schema).getGraphQLCustomScalarType(fieldGraphQLTypeName);
                }
            } else if (graphQLNonScalar != null) {
                fieldName = graphQLNonScalar.fieldName();
                fieldListDepth = graphQLNonScalar.listDepth();
            } else {
                throw new RuntimeException("The field " + object.getClass().getName() + "." + field.getName() + " should be annotated by either 'GraphQLScalar' or 'GraphQLNonScalar', but it there is no such annotation");
            }
            result.append(separator).append(graphQLVariable ? "\"" : "").append(fieldName).append(graphQLVariable ? "\"" : "").append(":").append(this.getStringContentForGraphqlQuery(writingGraphQLVariables, val, fieldListDepth, fieldGraphQLTypeName, fieldGraphQLType, graphQLVariable));
            separator = ",";
        }
        return result.append("}").toString();
    }

    public String getBindParameterName() {
        return this.bindParameterName;
    }

    public InputParameterType getType() {
        return this.type;
    }

    public String getGraphQLTypeName() {
        return this.graphQLTypeName;
    }

    public GraphQLScalarType getGraphQLScalarType() {
        return this.graphQLScalarType;
    }

    public boolean isItemMandatory() {
        return this.itemMandatory;
    }

    public int getListDepth() {
        return this.listDepth;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public static void appendInputParametersToGraphQLRequests(boolean writingGraphQLVariables, StringBuilder sb, List<InputParameter> inputParameters, Map<String, Object> parameters) throws GraphQLRequestExecutionException {
        if (inputParameters != null && inputParameters.size() > 0) {
            ArrayList<CallSite> params = new ArrayList<CallSite>();
            for (InputParameter param : inputParameters) {
                String string = param.getStringContentForGraphqlQuery(writingGraphQLVariables, parameters);
                if (string == null) continue;
                params.add((CallSite)((Object)(param.getName() + ":" + string)));
            }
            if (params.size() > 0) {
                sb.append("(");
                boolean writeComma = false;
                for (String string : params) {
                    if (writeComma) {
                        sb.append(",");
                    }
                    writeComma = true;
                    sb.append(string);
                }
                sb.append(")");
            }
        }
    }

    public static enum InputParameterType {
        HARD_CODED,
        MANDATORY,
        OPTIONAL,
        GRAPHQL_VALUE,
        GRAPHQL_VARIABLE;

    }

    private static enum InputParameterStep {
        NAME,
        VALUE;

    }
}

