/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import graphql.GraphQLContext;
import graphql.schema.GraphQLScalarType;
import java.util.List;
import java.util.Locale;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;

public abstract class AbstractCustomJacksonSerializer<T>
extends StdSerializer<T> {
    final int listLevel;
    final GraphQLScalarType graphQLScalarType;

    public AbstractCustomJacksonSerializer(Class<?> clazz, int listLevel, GraphQLScalarType graphQLScalarType) {
        super(clazz);
        this.listLevel = listLevel;
        this.graphQLScalarType = graphQLScalarType;
    }

    public void serialize(T value, JsonGenerator gen, SerializationContext context) {
        this.execSerialization(value, this.listLevel, gen);
    }

    private void execSerialization(Object value, int listLevelParam, JsonGenerator gen) {
        if (listLevelParam == 0) {
            if (this.graphQLScalarType != null) {
                gen.writePOJO(this.graphQLScalarType.getCoercing().serialize(value, GraphQLContext.getDefault(), Locale.getDefault()));
            } else {
                gen.writePOJO(value);
            }
        } else {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Expecting a list with depth (number of level of list inclusion) of " + this.listLevel + ", but the provided value's depth is " + (this.listLevel - listLevelParam) + " (a level of 0 means: it's not a list)");
            }
            gen.writeStartArray();
            for (Object v : (List)value) {
                this.execSerialization(v, listLevelParam - 1, gen);
            }
            gen.writeEndArray();
        }
    }
}

