/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.util;

import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GraphqlUtils {
    private static Logger logger = LoggerFactory.getLogger(GraphqlUtils.class);
    public static GraphqlUtils graphqlUtils = new GraphqlUtils();
    Pattern graphqlNamePattern = Pattern.compile("^[_A-Za-z][_0-9A-Za-z]*$");
    private List<String> javaKeywords = new ArrayList<String>();
    private Properties properties;
    static final String PROPERTIES_FILE = "graphql-java-runtime.properties";
    static final String PROP_RUNTIME_VERSION = "graphql-java-runtime.version";
    public static Character JAVA_KEYWORD_PREFIX = Character.valueOf('_');

    public GraphqlUtils() {
        this.javaKeywords.add("abstract");
        this.javaKeywords.add("assert");
        this.javaKeywords.add("boolean");
        this.javaKeywords.add("break");
        this.javaKeywords.add("byte");
        this.javaKeywords.add("case");
        this.javaKeywords.add("catch");
        this.javaKeywords.add("char");
        this.javaKeywords.add("class");
        this.javaKeywords.add("const");
        this.javaKeywords.add("continue");
        this.javaKeywords.add("default");
        this.javaKeywords.add("do");
        this.javaKeywords.add("double");
        this.javaKeywords.add("else");
        this.javaKeywords.add("enum");
        this.javaKeywords.add("extends");
        this.javaKeywords.add("final");
        this.javaKeywords.add("finally");
        this.javaKeywords.add("float");
        this.javaKeywords.add("for");
        this.javaKeywords.add("goto");
        this.javaKeywords.add("if");
        this.javaKeywords.add("implements");
        this.javaKeywords.add("import");
        this.javaKeywords.add("instanceof");
        this.javaKeywords.add("int");
        this.javaKeywords.add("interface");
        this.javaKeywords.add("long");
        this.javaKeywords.add("native");
        this.javaKeywords.add("new");
        this.javaKeywords.add("package");
        this.javaKeywords.add("private");
        this.javaKeywords.add("protected");
        this.javaKeywords.add("public");
        this.javaKeywords.add("return");
        this.javaKeywords.add("short");
        this.javaKeywords.add("static");
        this.javaKeywords.add("strictfp");
        this.javaKeywords.add("super");
        this.javaKeywords.add("switch");
        this.javaKeywords.add("synchronized");
        this.javaKeywords.add("this");
        this.javaKeywords.add("throw");
        this.javaKeywords.add("throws");
        this.javaKeywords.add("transient");
        this.javaKeywords.add("try");
        this.javaKeywords.add("void");
        this.javaKeywords.add("volatile");
        this.javaKeywords.add("while");
    }

    public String getRuntimeVersion() {
        return this.getProperties().getProperty(PROP_RUNTIME_VERSION);
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try (InputStream res = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
                this.properties.load(res);
            }
            catch (IOException e) {
                String msg = "Error while reading the 'graphql-java-runtime.properties' properties file: " + e.getMessage();
                logger.error(msg);
                throw new RuntimeException(msg, e);
            }
        }
        return this.properties;
    }

    public String getCamelCase(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public String getPascalCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public <I> List<I> iterableToList(Iterable<I> iterable) {
        ArrayList<I> ret = new ArrayList<I>();
        for (I i : iterable) {
            ret.add(i);
        }
        return ret;
    }

    public <I> List<I> iterableConcreteClassToListInterface(Iterable<? extends I> iterable) {
        ArrayList<I> ret = new ArrayList<I>();
        for (I i : iterable) {
            ret.add(i);
        }
        return ret;
    }

    public <T> T optionalToObject(Optional<T> optional) {
        return optional.isPresent() ? (T)optional.get() : null;
    }

    public Class<?> getFieldType(Class<?> owningClass, String fieldName, boolean returnIsMandatory) throws GraphQLRequestPreparationException {
        if (owningClass.isInterface()) {
            try {
                Method method = owningClass.getDeclaredMethod("get" + graphqlUtils.getPascalCase(fieldName), new Class[0]);
                GraphQLNonScalar graphQLNonScalar = method.getAnnotation(GraphQLNonScalar.class);
                GraphQLScalar graphQLScalar = method.getAnnotation(GraphQLScalar.class);
                if (graphQLNonScalar != null) {
                    return graphQLNonScalar.javaClass();
                }
                if (graphQLScalar != null) {
                    return graphQLScalar.javaClass();
                }
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the interface '" + owningClass.getName() + "': this method should have one of these annotations: GraphQLNonScalar or GraphQLScalar ");
            }
            catch (NoSuchMethodException e) {
                if (!returnIsMandatory) {
                    return null;
                }
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
            }
            catch (SecurityException e) {
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
            }
        }
        try {
            Field field = owningClass.getDeclaredField(graphqlUtils.getJavaName(fieldName));
            GraphQLNonScalar graphQLNonScalar = field.getAnnotation(GraphQLNonScalar.class);
            GraphQLScalar graphQLScalar = field.getAnnotation(GraphQLScalar.class);
            if (graphQLNonScalar != null) {
                return graphQLNonScalar.javaClass();
            }
            if (graphQLScalar != null) {
                return graphQLScalar.javaClass();
            }
            throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "': this field should have one of these annotations: GraphQLNonScalar or GraphQLScalar ");
        }
        catch (NoSuchFieldException e) {
            if (!returnIsMandatory) {
                return null;
            }
            throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
        }
        catch (SecurityException e) {
            throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
        }
    }

    public Object getArgument(Object jsonParsedValue, String graphQLTypeName, String javaTypeForIDType, Class<?> clazz) {
        if (jsonParsedValue == null) {
            return null;
        }
        if (jsonParsedValue instanceof List) {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Object o : (List)jsonParsedValue) {
                objects.add(this.getArgument(o, graphQLTypeName, javaTypeForIDType, clazz));
            }
            return objects;
        }
        if (jsonParsedValue instanceof Map) {
            Object t;
            Map map = (Map)jsonParsedValue;
            try {
                t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Error while creating a new instance of  '" + clazz.getName() + " class", e);
            }
            for (String key : map.keySet()) {
                Object value;
                Field field;
                try {
                    field = clazz.getDeclaredField(key);
                }
                catch (NoSuchFieldException | SecurityException e) {
                    throw new RuntimeException("Error while reading '" + key + "' field for the " + clazz.getName() + " class", e);
                }
                Method setter = this.getSetter(clazz, field);
                GraphQLScalar graphQLScalar = field.getAnnotation(GraphQLScalar.class);
                GraphQLNonScalar graphQLNonScalar = field.getAnnotation(GraphQLNonScalar.class);
                if (graphQLScalar != null) {
                    value = this.getArgument(map.get(key), graphQLScalar.graphQLTypeSimpleName(), javaTypeForIDType, graphQLScalar.javaClass());
                } else if (graphQLNonScalar != null) {
                    value = this.getArgument(map.get(key), graphQLNonScalar.graphQLTypeSimpleName(), javaTypeForIDType, graphQLNonScalar.javaClass());
                } else {
                    throw new RuntimeException("Internal error: the field '" + clazz.getName() + "." + key + "' should have one of these annotations: GraphQLScalar or GraphQLScalar");
                }
                this.invokeMethod(setter, t, value);
            }
            return t;
        }
        if (clazz.isEnum()) {
            if (!(jsonParsedValue instanceof String)) {
                throw new RuntimeException("The " + clazz.getName() + " class is an enum, but the provided value is '" + jsonParsedValue + "' which should be a String, to be mapped to the relevant enum value");
            }
            Method valueOf = graphqlUtils.getMethod("valueOf", clazz, String.class);
            return graphqlUtils.invokeMethod(valueOf, null, (String)jsonParsedValue);
        }
        if (graphQLTypeName.equals("ID")) {
            if (javaTypeForIDType == null || javaTypeForIDType.equals("")) {
                return UUID.fromString((String)jsonParsedValue);
            }
            if (javaTypeForIDType.equals("java.util.UUID")) {
                return UUID.fromString((String)jsonParsedValue);
            }
            if (javaTypeForIDType.equals("java.lang.String")) {
                return jsonParsedValue;
            }
            if (javaTypeForIDType.equals("java.lang.Long")) {
                return Long.parseLong((String)jsonParsedValue);
            }
            throw new RuntimeException("Non managed value for the plugin parameter 'javaTypeForIDType': '" + javaTypeForIDType + "'");
        }
        if (clazz.isInstance(jsonParsedValue)) {
            return jsonParsedValue;
        }
        if (jsonParsedValue instanceof String) {
            if (clazz == String.class) {
                return jsonParsedValue;
            }
            if (clazz == UUID.class) {
                return UUID.fromString((String)jsonParsedValue);
            }
            if (clazz == Boolean.class) {
                return jsonParsedValue.equals("true");
            }
            if (clazz == Long.class) {
                return Long.parseLong((String)jsonParsedValue);
            }
            if (clazz == Integer.class) {
                return Integer.parseInt((String)jsonParsedValue);
            }
            if (clazz == Double.class) {
                return Double.parseDouble((String)jsonParsedValue);
            }
            if (clazz == Float.class) {
                return Float.valueOf(Float.parseFloat((String)jsonParsedValue));
            }
        }
        throw new RuntimeException("Can't transform the jsonParsedValue (" + jsonParsedValue.getClass().getName() + ") into a " + clazz.getName());
    }

    public Field getDeclaredField(Class<?> owningClass, String fieldName, boolean mustFindField) throws GraphQLRequestPreparationException {
        try {
            return owningClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e1) {
            block6: {
                if (owningClass.getSimpleName().endsWith("Response")) {
                    try {
                        return owningClass.getSuperclass().getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException | SecurityException e2) {
                        if (!mustFindField) break block6;
                        throw new GraphQLRequestPreparationException("Could not find fied '" + fieldName + "' in " + owningClass.getName() + ", nor in " + owningClass.getSuperclass().getName(), e1);
                    }
                }
            }
            if (mustFindField) {
                throw new GraphQLRequestPreparationException("Could not find fied '" + fieldName + "' in " + owningClass.getName(), e1);
            }
            return null;
        }
    }

    public <T> Method getSetter(Class<T> clazz, Field field) {
        String setterMethodName = "set" + this.getPascalCase(field.getName());
        try {
            return clazz.getDeclaredMethod(setterMethodName, field.getType());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The setter '" + setterMethodName + "' is missing in " + clazz.getName() + " class", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error while accessing to the setter '" + setterMethodName + "' in " + clazz.getName() + " class", e);
        }
    }

    public Method getGetter(Class<?> clazz, Field field) {
        String getterMethodName = "get" + this.getPascalCase(field.getName());
        try {
            Method method = null;
            try {
                method = clazz.getMethod(getterMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                    getterMethodName = "is" + this.getPascalCase(field.getName());
                    method = clazz.getMethod(getterMethodName, new Class[0]);
                }
                throw e;
            }
            if (field.getType() != method.getReturnType()) {
                throw new RuntimeException("The getter '" + getterMethodName + "' and the field '" + field.getName() + "' of the class " + clazz.getName() + " should be of the same type");
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The getter '" + getterMethodName + "' is missing in " + clazz.getName() + " class", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error while accessing to the getter '" + getterMethodName + "' in " + clazz.getName() + " class", e);
        }
    }

    public Object invokeGetter(Object object, String fieldName) {
        try {
            Field field = this.getField(object, fieldName);
            Method getter = this.getGetter(object.getClass(), field);
            return getter.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error while invoking to the getter for the field '" + fieldName + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    private Field getField(Object object, String fieldName) {
        Class<?> clazz = object.getClass();
        while (!clazz.equals(Object.class)) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new RuntimeException("Could not find the field " + fieldName + " in either " + object.getClass().getName() + " or in one of its superclass");
    }

    public void invokeSetter(Object object, Field field, Object value) {
        try {
            Method setter = this.getSetter(object.getClass(), field);
            setter.invoke(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error while invoking to the setter for the field '" + field.getName() + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    public void invokeSetter(Object object, String fieldName, Object value) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            this.invokeSetter(object, field, value);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Error while invoking to the setter for the field '" + fieldName + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    public void addImport(Set<String> imports, String targetPackageName, String classname) {
        String fullClassname = classname.replace('$', '.');
        int lastDotPos = fullClassname.lastIndexOf(46);
        String packageName = fullClassname.substring(0, lastDotPos);
        String simpleClassName = fullClassname.substring(lastDotPos + 1);
        if (!packageName.equals("java.lang") && !targetPackageName.equals(packageName)) {
            imports.add(packageName + "." + simpleClassName);
        }
    }

    public Method getMethod(String methodName, Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not get the method '" + methodName + "' in the " + clazz.getName() + " class", e);
        }
    }

    public Object invokeMethod(String methodName, Object object, Object ... args) {
        try {
            Method getType = object.getClass().getDeclaredMethod(methodName, new Class[0]);
            return getType.invoke(object, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error when trying to execute '" + methodName + "' on '" + object.getClass().getName() + "': " + e.getMessage(), e);
        }
    }

    public Object invokeMethod(Method method, Object o, Object ... args) {
        try {
            return method.invoke(o, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            StringBuffer msg = new StringBuffer("Error when executing the method '");
            msg.append(method.getName());
            msg.append("(");
            String separator = "";
            for (Object arg : args) {
                msg.append(separator);
                separator = ",";
                msg.append(arg.getClass().getName());
            }
            msg.append(")' is missing in ");
            msg.append(o.getClass().getName());
            msg.append(" class");
            throw new RuntimeException(msg.toString(), e);
        }
    }

    public String getJavaName(String name) {
        return this.isJavaReservedWords(name) ? JAVA_KEYWORD_PREFIX + name : name;
    }

    public boolean isJavaReservedWords(String name) {
        return this.javaKeywords.contains(name);
    }

    public String getClassSimpleName(String classFullName) {
        int lstPointPosition = classFullName.lastIndexOf(46);
        return classFullName.substring(lstPointPosition + 1);
    }

    public String getPackageName(String classFullName) {
        int lstPointPosition = classFullName.lastIndexOf(46);
        return classFullName.substring(0, lstPointPosition);
    }

    @SafeVarargs
    public final <T> Stream<T> concatStreams(Class<T> clazz, boolean parallelStreams, T t1, T t2, T t3, List<? extends T> ... lists) {
        Stream.Builder<T> builder = Stream.builder();
        if (t1 != null) {
            builder.accept(t1);
        }
        if (t2 != null) {
            builder.accept(t2);
        }
        if (t3 != null) {
            builder.accept(t3);
        }
        Stream ret = builder.build();
        for (List<T> list : lists) {
            ret = Stream.concat(ret, list.stream());
        }
        return parallelStreams ? (Stream)ret.parallel() : ret;
    }

    Object getValue(Value<?> value, String graphqlTypeName, String action) {
        if (value instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue();
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue();
        }
        if (value instanceof EnumValue) {
            return ((EnumValue)value).getName();
        }
        if (value instanceof NullValue) {
            return null;
        }
        if (value instanceof ArrayValue) {
            List list = ((ArrayValue)value).getValues();
            Object[] ret = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ret[i] = this.getValue((Value)list.get(i), graphqlTypeName, action + ": ArrayValue(" + i + ")");
            }
            return ret;
        }
        throw new RuntimeException("Value of type " + value.getClass().getName() + " is not managed (" + action + ")");
    }

    public String getValueAsText(Value<?> value) {
        if (value == null || value instanceof NullValue) {
            return "null";
        }
        if (value instanceof StringValue) {
            return "\"" + ((StringValue)value).getValue() + "\"";
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue() ? "true" : "false";
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue().toString();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue().toString();
        }
        if (value instanceof EnumValue) {
            return ((EnumValue)value).getName();
        }
        if (value instanceof ObjectValue) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean appendSep = false;
            for (ObjectField v : ((ObjectValue)value).getObjectFields()) {
                if (appendSep) {
                    sb.append(",");
                } else {
                    appendSep = true;
                }
                sb.append(v.getName()).append(":").append(this.getValueAsText(v.getValue()));
            }
            sb.append("}");
            return sb.toString();
        }
        if (value instanceof ArrayValue) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean appendSep = false;
            for (Value v : ((ArrayValue)value).getValues()) {
                if (appendSep) {
                    sb.append(",");
                } else {
                    appendSep = true;
                }
                sb.append(this.getValueAsText(v));
            }
            sb.append("]");
            return sb.toString();
        }
        throw new RuntimeException("Value of type " + value.getClass().getName() + " is not managed");
    }

    public Long getLastModified(File fileOrFolder, boolean maxValue) {
        if (fileOrFolder == null || !fileOrFolder.exists()) {
            return null;
        }
        if (fileOrFolder.isFile()) {
            return fileOrFolder.lastModified();
        }
        if (!fileOrFolder.isDirectory()) {
            throw new RuntimeException("Unknown file type for " + fileOrFolder.getAbsolutePath());
        }
        Long lastModifed = null;
        for (File f : fileOrFolder.listFiles()) {
            Long contentLastModified = this.getLastModified(f, maxValue);
            if (contentLastModified == null) continue;
            if (lastModifed == null) {
                lastModifed = contentLastModified;
                continue;
            }
            if (maxValue && contentLastModified > lastModifed) {
                lastModifed = contentLastModified;
                continue;
            }
            if (maxValue || contentLastModified >= lastModifed) continue;
            lastModifed = contentLastModified;
        }
        return lastModifed;
    }

    public String getQuotedScanBasePackages(String scanBasePackages) {
        if (scanBasePackages == null || scanBasePackages.contentEquals("") || scanBasePackages.contentEquals("null")) {
            return "";
        }
        scanBasePackages = scanBasePackages.replace(" ", "");
        scanBasePackages = scanBasePackages.replace(",", "\",\"");
        scanBasePackages = ",\"" + scanBasePackages + "\"";
        return scanBasePackages;
    }
}

