/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.GraphqlUtils;
import com.graphql_java_generator.annotation.GraphQLEnumType;
import com.graphql_java_generator.annotation.GraphQLInputParameters;
import com.graphql_java_generator.annotation.GraphQLInterfaceType;
import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLObjectType;
import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.annotation.GraphQLUnionType;
import com.graphql_java_generator.client.directive.Directive;
import com.graphql_java_generator.client.directive.DirectiveRegistry;
import com.graphql_java_generator.client.directive.DirectiveRegistryImpl;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.customscalars.CustomScalarRegistryImpl;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import graphql.Scalars;
import graphql.schema.GraphQLScalarType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class GraphqlClientUtils {
    public static GraphqlClientUtils graphqlClientUtils = new GraphqlClientUtils();
    DirectiveRegistry directiveRegistry = DirectiveRegistryImpl.directiveRegistry;
    Pattern graphqlNamePattern = Pattern.compile("^[_A-Za-z][_0-9A-Za-z]*$");
    GraphqlUtils graphqlUtils = new GraphqlUtils();
    List<Class<?>> scalars = new ArrayList();

    public GraphqlClientUtils() {
        this.scalars.add(String.class);
        this.scalars.add(Integer.TYPE);
        this.scalars.add(Integer.class);
        this.scalars.add(Float.TYPE);
        this.scalars.add(Float.class);
        this.scalars.add(Boolean.TYPE);
        this.scalars.add(Boolean.class);
    }

    public void checkName(String graphqlIdentifier) throws GraphQLRequestPreparationException {
        if (graphqlIdentifier == null) {
            throw new NullPointerException("A GraphQL identifier may not be null");
        }
        Matcher m = this.graphqlNamePattern.matcher(graphqlIdentifier);
        if (!m.matches()) {
            throw new GraphQLRequestPreparationException("<" + graphqlIdentifier + "> is not a valid GraphQL name");
        }
    }

    public Class<?> checkIsScalar(Field field, Boolean shouldBeScalar) throws GraphQLRequestPreparationException {
        boolean isScalar = this.isScalar(field);
        if (shouldBeScalar != null) {
            if (shouldBeScalar & !isScalar) {
                throw new GraphQLRequestPreparationException("The field <" + field.getName() + "> of the GraphQL type <" + field.getDeclaringClass().getName() + "> is not a GraphQLScalar. At least one field must be defined for the server response.");
            }
            if (shouldBeScalar == false & isScalar) {
                throw new GraphQLRequestPreparationException("The field <" + field.getName() + "> of the GraphQL type <" + field.getDeclaringClass().getName() + "> is not a GraphQLScalar. At least one field must be defined for the server response.");
            }
        }
        return this.getGraphQLType(field);
    }

    public Class<?> checkIsScalar(String fieldName, Method method, Boolean shouldBeScalar) throws GraphQLRequestPreparationException {
        boolean isScalar = this.isScalar(method);
        if (method.getReturnType() == null) {
            throw new GraphQLRequestPreparationException("There is a method of name <" + fieldName + "> in the GraphQL type <" + method.getDeclaringClass().getName() + ">, but this method is a void method: it can't represent the <" + fieldName + "> GraphQL field");
        }
        if (shouldBeScalar != null) {
            if (shouldBeScalar.booleanValue() && !isScalar) {
                throw new GraphQLRequestPreparationException("The field <" + fieldName + "> (accessed through its getter: " + method.getName() + ">) of the GraphQL type <" + method.getDeclaringClass().getName() + "> should be a scalar. But is is actually not a GraphQLScalar");
            }
            if (!shouldBeScalar.booleanValue() && isScalar) {
                throw new GraphQLRequestPreparationException("The field <" + fieldName + "> (accessed through its getter: <" + method.getName() + ">) of the GraphQL type <" + method.getDeclaringClass().getName() + "> should not be a scalar. But is is actually a GraphQLScalar");
            }
        }
        return this.getGraphQLType(method);
    }

    public boolean isScalar(AccessibleObject fieldOrMethod) throws GraphQLRequestPreparationException {
        if (fieldOrMethod.getAnnotation(GraphQLScalar.class) != null || fieldOrMethod.getAnnotation(GraphQLNonScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLScalar.class) != null;
        }
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            throw new GraphQLRequestPreparationException("The field <" + field.getName() + "> of the class <" + field.getDeclaringClass().getName() + "> has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
        }
        Method method = (Method)fieldOrMethod;
        throw new GraphQLRequestPreparationException("The method <" + method.getName() + "> of the class <" + method.getDeclaringClass().getName() + "> has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
    }

    public Class<?> getGraphQLType(AccessibleObject fieldOrMethod) throws GraphQLRequestPreparationException {
        if (fieldOrMethod.getAnnotation(GraphQLScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLScalar.class).javaClass();
        }
        if (fieldOrMethod.getAnnotation(GraphQLNonScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLNonScalar.class).javaClass();
        }
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            throw new GraphQLRequestPreparationException("The field <" + field.getName() + "> of the class <" + field.getDeclaringClass().getName() + "> has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
        }
        Method method = (Method)fieldOrMethod;
        throw new GraphQLRequestPreparationException("The method <" + method.getName() + "> of the class <" + method.getDeclaringClass().getName() + "> has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
    }

    public Class<?> checkFieldOfGraphQLType(String name, Boolean shouldBeScalar, Class<?> owningClass) throws GraphQLRequestPreparationException {
        this.checkName(name);
        Class<?> fieldClass = null;
        Field field = this.graphqlUtils.getDeclaredField(owningClass, this.graphqlUtils.getJavaName(name), false);
        if (field != null) {
            fieldClass = this.checkIsScalar(field, shouldBeScalar);
        }
        if (fieldClass == null && !owningClass.isInterface()) {
            for (Method method : owningClass.getMethods()) {
                if (!method.getName().equals(name)) continue;
                fieldClass = this.checkIsScalar(name, method, shouldBeScalar);
                break;
            }
        }
        if (fieldClass == null && owningClass.isInterface()) {
            String expectedMethodName = "get" + this.graphqlUtils.getPascalCase(name);
            for (Method method : owningClass.getDeclaredMethods()) {
                if (!method.getName().equals(expectedMethodName)) continue;
                fieldClass = this.checkIsScalar(name, method, shouldBeScalar);
                break;
            }
        }
        if (fieldClass == null) {
            throw new GraphQLRequestPreparationException("The GraphQL type <" + owningClass.getSimpleName() + "> has no field of name <" + name + ">");
        }
        return fieldClass;
    }

    public Map<String, Object> generatesBindVariableValuesMap(Object[] paramsAndValues) throws GraphQLRequestExecutionException, ClassCastException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (paramsAndValues != null) {
            if (paramsAndValues.length % 2 != 0) {
                throw new GraphQLRequestExecutionException("An even number of parameters is expected, but " + paramsAndValues.length + " parameters where sent. This method expects a series of name and values : (paramName1, paramValue1, paramName2, paramValue2...)");
            }
            for (int i = 0; i < paramsAndValues.length; i += 2) {
                map.put((String)paramsAndValues[i], paramsAndValues[i + 1]);
            }
        }
        return map;
    }

    public String getGraphQLTypeNameFromClass(Class<?> clazz) {
        GraphQLObjectType graphQLObjectType = clazz.getAnnotation(GraphQLObjectType.class);
        if (graphQLObjectType != null) {
            return graphQLObjectType.value();
        }
        GraphQLInterfaceType graphQLInterfaceType = clazz.getAnnotation(GraphQLInterfaceType.class);
        if (graphQLInterfaceType != null) {
            return graphQLInterfaceType.value();
        }
        GraphQLUnionType graphQLUnionType = clazz.getAnnotation(GraphQLUnionType.class);
        if (graphQLUnionType != null) {
            return graphQLUnionType.value();
        }
        GraphQLEnumType graphQLEnumType = clazz.getAnnotation(GraphQLEnumType.class);
        if (graphQLEnumType != null) {
            return graphQLEnumType.value();
        }
        throw new RuntimeException("Could not find the GraphQL type for the class " + clazz.getName());
    }

    public GraphQLScalarType getGraphQLCustomScalarType(AccessibleObject fieldOrMethod) {
        String graphQLTypeName = fieldOrMethod.getAnnotation(GraphQLScalar.class) != null ? fieldOrMethod.getAnnotation(GraphQLScalar.class).graphQLTypeName() : null;
        if (graphQLTypeName != null) {
            return CustomScalarRegistryImpl.customScalarRegistry.getGraphQLScalarType(graphQLTypeName);
        }
        return null;
    }

    public GraphQLScalarType getGraphQLType(Directive directive, Class<?> owningClass, String fieldName, String parameterName) throws GraphQLRequestPreparationException {
        GraphQLInputParameters inputParams;
        if (directive != null) {
            Directive dirDef = this.directiveRegistry.getDirective(directive.getName());
            if (dirDef == null) {
                throw new GraphQLRequestPreparationException("Could not find directive definition for the directive '" + directive.getName() + "'");
            }
            for (InputParameter param : dirDef.getArguments()) {
                if (!param.getName().equals(parameterName)) continue;
                return param.getGraphQLScalarType();
            }
            throw new GraphQLRequestPreparationException("The parameter of name '" + parameterName + "' has not been found for the directive '" + directive.getName() + "'");
        }
        if (owningClass.isInterface()) {
            try {
                Method method = owningClass.getMethod("get" + this.graphqlUtils.getPascalCase(this.graphqlUtils.getJavaName(fieldName)), new Class[0]);
                inputParams = method.getAnnotation(GraphQLInputParameters.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new GraphQLRequestPreparationException("Error while looking for the the getter for <" + fieldName + "> in the interface '" + owningClass.getName() + "'", e);
            }
        }
        try {
            Field field = owningClass.getDeclaredField(this.graphqlUtils.getJavaName(fieldName));
            inputParams = field.getAnnotation(GraphQLInputParameters.class);
        }
        catch (NoSuchFieldException | SecurityException e) {
            try {
                Field field = owningClass.getSuperclass().getDeclaredField(this.graphqlUtils.getJavaName(fieldName));
                inputParams = field.getAnnotation(GraphQLInputParameters.class);
            }
            catch (NoSuchFieldException | SecurityException e2) {
                throw new GraphQLRequestPreparationException("Error while looking for the the field <" + fieldName + "> in the class '" + owningClass.getName() + "', not in its superclass: " + owningClass.getSuperclass().getName(), e);
            }
        }
        if (inputParams == null) {
            throw new GraphQLRequestPreparationException("The field <" + fieldName + "> of the class '" + owningClass.getName() + "' has no input parameters. Error while looking for its '" + parameterName + "' input parameter");
        }
        for (int i = 0; i < inputParams.names().length; ++i) {
            if (!inputParams.names()[i].equals(parameterName)) continue;
            return this.getGraphQLTypeFromName(inputParams.types()[i]);
        }
        throw new GraphQLRequestPreparationException("The parameter of name <" + parameterName + "> has not been found for the field <" + fieldName + "> of the class '" + owningClass.getName() + "'");
    }

    public GraphQLScalarType getGraphQLTypeFromName(String typeName) throws GraphQLRequestPreparationException {
        if (typeName.equals("String")) {
            return Scalars.GraphQLString;
        }
        if (typeName.equals("Boolean")) {
            return Scalars.GraphQLBoolean;
        }
        if (typeName.equals("Float")) {
            return Scalars.GraphQLFloat;
        }
        if (typeName.equals("Int")) {
            return Scalars.GraphQLInt;
        }
        if (typeName.equals("ID")) {
            return Scalars.GraphQLID;
        }
        return CustomScalarRegistryImpl.customScalarRegistry.getGraphQLScalarType(typeName);
    }
}

