/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.annotation.RequestType;
import com.graphql_java_generator.client.GraphQLConfiguration;
import com.graphql_java_generator.client.GraphQLRequestObject;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.client.SubscriptionClient;
import com.graphql_java_generator.client.request.Fragment;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.client.request.QueryField;
import com.graphql_java_generator.client.request.QueryTokenizer;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class AbstractGraphQLRequest {
    static GraphQLConfiguration staticConfiguration = null;
    GraphQLConfiguration instanceConfiguration = null;
    QueryField query = null;
    QueryField mutation = null;
    QueryField subscription = null;
    List<Fragment> fragments = new ArrayList<Fragment>();
    final String graphQLRequest;
    RequestType requestType;
    final String requestName;
    protected final String packageName;

    public AbstractGraphQLRequest(String graphQLRequest, RequestType requestType, String fieldName, InputParameter ... inputParams) throws GraphQLRequestPreparationException {
        QueryField field;
        if (requestType == null) {
            throw new NullPointerException("requestType is mandatory, but a null value has been provided");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is mandatory, but a null value has been provided");
        }
        this.requestType = requestType;
        this.requestName = null;
        this.graphQLRequest = graphQLRequest;
        this.packageName = this.getGraphQLClassesPackageName();
        switch (requestType) {
            case query: {
                this.query = this.getQueryContext();
                field = new QueryField(this.query.clazz, fieldName);
                this.query.fields.add(field);
                break;
            }
            case mutation: {
                this.mutation = this.getMutationContext();
                field = new QueryField(this.mutation.clazz, fieldName);
                this.mutation.fields.add(field);
                break;
            }
            case subscription: {
                this.subscription = this.getSubscriptionContext();
                field = new QueryField(this.subscription.clazz, fieldName);
                this.subscription.fields.add(field);
                break;
            }
            default: {
                throw new GraphQLRequestPreparationException("Non managed request type '" + (Object)((Object)requestType) + " while reading the GraphQL request: " + graphQLRequest);
            }
        }
        field.inputParameters = Arrays.asList(inputParams);
        QueryTokenizer qt = new QueryTokenizer(this.graphQLRequest);
        if (qt.hasMoreTokens()) {
            String token = qt.nextToken();
            if (!"{".equals(token)) {
                throw new GraphQLRequestPreparationException("The Partial GraphQL Request should start by a '{', but it doesn't: " + graphQLRequest);
            }
            field.readTokenizerForResponseDefinition(qt);
        }
        this.finishRequestPreparation();
    }

    public AbstractGraphQLRequest(String graphQLRequest) throws GraphQLRequestPreparationException {
        String localQueryName = null;
        this.graphQLRequest = graphQLRequest;
        this.packageName = this.getGraphQLClassesPackageName();
        this.requestType = RequestType.query;
        boolean requestTypeHasBeenRead = false;
        ArrayList<InputParameter> inputParameters = new ArrayList<InputParameter>();
        QueryTokenizer qt = new QueryTokenizer(this.graphQLRequest);
        block21: while (qt.hasMoreTokens()) {
            String token;
            switch (token = qt.nextToken()) {
                case "fragment": {
                    this.fragments.add(new Fragment(qt, this.packageName, false, null));
                    continue block21;
                }
                case "query": 
                case "mutation": 
                case "subscription": {
                    this.requestType = RequestType.valueOf(token);
                    requestTypeHasBeenRead = true;
                    continue block21;
                }
                case "(": {
                    try {
                        this.readRequestParameters(qt, inputParameters);
                        continue block21;
                    }
                    catch (Exception e) {
                        throw new GraphQLRequestPreparationException(e.getMessage() + " (while reading the request parameters)", e);
                    }
                }
                case "{": {
                    switch (this.requestType) {
                        case query: {
                            this.query = this.getQueryContext();
                            this.query.inputParameters = inputParameters;
                            this.query.readTokenizerForResponseDefinition(qt);
                            continue block21;
                        }
                        case mutation: {
                            this.mutation = this.getMutationContext();
                            this.mutation.inputParameters = inputParameters;
                            this.mutation.readTokenizerForResponseDefinition(qt);
                            continue block21;
                        }
                        case subscription: {
                            this.subscription = this.getSubscriptionContext();
                            this.subscription.inputParameters = inputParameters;
                            this.subscription.readTokenizerForResponseDefinition(qt);
                            continue block21;
                        }
                    }
                    throw new GraphQLRequestPreparationException("Non managed request type '" + (Object)((Object)this.requestType) + " while reading the GraphQL request: " + graphQLRequest);
                }
            }
            if (requestTypeHasBeenRead) {
                localQueryName = token;
                continue;
            }
            throw new GraphQLRequestPreparationException("Unknown token '" + token + " while reading the GraphQL request: " + graphQLRequest);
        }
        if (this.query == null && this.mutation == null && this.subscription == null) {
            throw new GraphQLRequestPreparationException("No response definition found");
        }
        this.requestName = localQueryName;
        this.finishRequestPreparation();
    }

    private void readRequestParameters(QueryTokenizer qt, List<InputParameter> inputParameters) throws GraphQLRequestPreparationException {
        Step step = Step.NAME;
        String name = null;
        while (true) {
            String token;
            if ((token = qt.nextToken()).equals(")")) {
                if (!step.equals((Object)Step.TYPE)) break;
                throw new GraphQLRequestPreparationException("Found a ')', while expecting a value for the '" + name + "' query parameter");
            }
            if (token.equals(",")) {
                if (!step.equals((Object)Step.NAME)) {
                    throw new GraphQLRequestPreparationException("unexpected ','");
                }
                token = qt.nextToken();
            } else if (token.equals(":")) {
                if (!step.equals((Object)Step.TYPE)) {
                    throw new GraphQLRequestPreparationException("unexpected ':'");
                }
                token = qt.nextToken();
            }
            switch (step) {
                case NAME: {
                    if (!token.startsWith("$")) {
                        throw new GraphQLRequestPreparationException("The GraphQL variable names should start by a '$', but this one doesn't: '" + token + "'");
                    }
                    name = token.substring(1);
                    step = Step.TYPE;
                    break;
                }
                case TYPE: {
                    int currentDepth = 0;
                    String graphQLTypeName = null;
                    boolean mandatory = false;
                    int listDepth = 0;
                    boolean itemMandatory = false;
                    while (true) {
                        switch (token) {
                            case "[": {
                                ++listDepth;
                                ++currentDepth;
                                break;
                            }
                            case "]": {
                                --currentDepth;
                                break;
                            }
                            case "!": {
                                itemMandatory = true;
                                break;
                            }
                            case ",": 
                            case ")": {
                                throw new GraphQLRequestPreparationException("Syntax error in the query, while reading the type of the '" + name + "' parameter of the request");
                            }
                            default: {
                                graphQLTypeName = token;
                            }
                        }
                        if (currentDepth == 0) break;
                        token = qt.nextToken();
                    }
                    if (qt.checkNextToken("!")) {
                        mandatory = true;
                        token = qt.nextToken();
                    } else {
                        mandatory = false;
                    }
                    inputParameters.add(InputParameter.newGraphQLVariableParameter(name, graphQLTypeName, mandatory, listDepth, itemMandatory));
                    step = Step.NAME;
                }
            }
        }
    }

    public <T extends GraphQLRequestObject> T exec(Class<T> t, Map<String, Object> params) throws GraphQLRequestExecutionException {
        if (this.instanceConfiguration != null) {
            return this.instanceConfiguration.getQueryExecutor().execute(this, params, t);
        }
        if (staticConfiguration != null) {
            return staticConfiguration.getQueryExecutor().execute(this, params, t);
        }
        throw new GraphQLRequestExecutionException("The GraphQLRequestConfiguration has not been set in the GraphQLRequest. Please set either the GraphQL instance configuration or the GraphQL static configuration before executing a GraphQL request");
    }

    public <R, T> SubscriptionClient exec(Map<String, Object> params, SubscriptionCallback<T> subscriptionCallback, Class<R> subscriptionType, Class<T> messageType) throws GraphQLRequestExecutionException {
        if (this.instanceConfiguration != null) {
            return this.instanceConfiguration.getQueryExecutor().execute(this, params, subscriptionCallback, subscriptionType, messageType);
        }
        if (staticConfiguration != null) {
            return staticConfiguration.getQueryExecutor().execute(this, params, subscriptionCallback, subscriptionType, messageType);
        }
        throw new GraphQLRequestExecutionException("The GraphQLRequestConfiguration has not been set in the GraphQLRequest. Please set either the GraphQL instance configuration or the GraphQL static configuration before executing a GraphQL request");
    }

    private void addTypenameFields() throws GraphQLRequestPreparationException {
        if (this.query != null) {
            this.query.addTypenameFields();
        }
        if (this.mutation != null) {
            this.mutation.addTypenameFields();
        }
        if (this.subscription != null) {
            this.subscription.addTypenameFields();
        }
        for (Fragment f : this.fragments) {
            f.addTypenameFields();
        }
    }

    private void finishRequestPreparation() throws GraphQLRequestPreparationException {
        this.AddScalarFieldToEmptyNonScalarField(this.query);
        this.AddScalarFieldToEmptyNonScalarField(this.mutation);
        this.AddScalarFieldToEmptyNonScalarField(this.subscription);
        this.addTypenameFields();
    }

    private void AddScalarFieldToEmptyNonScalarField(QueryField field) throws GraphQLRequestPreparationException {
        block7: {
            if (field == null || field.isScalar()) break block7;
            if (field.fields.size() == 0 && field.fragments.size() == 0 && field.inlineFragments.size() == 0) {
                if (field.clazz.isInterface()) {
                    for (Method m : field.clazz.getDeclaredMethods()) {
                        GraphQLScalar graphQLScalar;
                        if (!m.getName().startsWith("get") || (graphQLScalar = m.getAnnotation(GraphQLScalar.class)) == null) continue;
                        field.fields.add(new QueryField(field.clazz, graphQLScalar.fieldName()));
                    }
                } else {
                    for (Field f : field.clazz.getDeclaredFields()) {
                        GraphQLScalar graphQLScalar = f.getAnnotation(GraphQLScalar.class);
                        if (graphQLScalar == null) continue;
                        field.fields.add(new QueryField(field.clazz, graphQLScalar.fieldName()));
                    }
                }
            } else {
                for (QueryField f : field.fields) {
                    this.AddScalarFieldToEmptyNonScalarField(f);
                }
            }
        }
    }

    public String buildRequest(Map<String, Object> params) throws GraphQLRequestExecutionException {
        QueryField request;
        StringBuilder sb = new StringBuilder("{\"query\":\"");
        for (Fragment fragment : this.fragments) {
            fragment.appendToGraphQLRequests(sb, params);
        }
        if (this.query != null) {
            request = this.query;
        } else if (this.mutation != null) {
            request = this.mutation;
        } else if (this.subscription != null) {
            request = this.subscription;
        } else {
            throw new GraphQLRequestExecutionException("[Internal error] no request has been initialized");
        }
        sb.append(request.name);
        if (this.requestName != null) {
            sb.append(" ").append(this.requestName);
        }
        StringBuilder sbGraphQLVariables = new StringBuilder();
        StringBuilder sbGraphQLValues = new StringBuilder();
        String separator = "";
        for (InputParameter param : request.inputParameters) {
            int i;
            if (param.getType() != InputParameter.InputParameterType.GRAPHQL_VARIABLE) continue;
            sbGraphQLVariables.append(separator).append("$").append(param.getBindParameterName()).append(":");
            for (i = 0; i < param.getListDepth(); ++i) {
                sbGraphQLVariables.append("[");
            }
            sbGraphQLVariables.append(param.getGraphQLTypeName()).append(param.isItemMandatory() ? "!" : "");
            for (i = 0; i < param.getListDepth(); ++i) {
                sbGraphQLVariables.append("]");
            }
            sbGraphQLVariables.append(param.isMandatory() ? "!" : "");
            sbGraphQLValues.append(separator).append("\"").append(param.getBindParameterName()).append("\":").append(param.getValueForGraphqlQuery(true, params));
            separator = ",";
        }
        String graphQLVariables = sbGraphQLVariables.toString();
        if (graphQLVariables.length() > 0) {
            sb.append("(").append(graphQLVariables).append(")");
        }
        request.appendToGraphQLRequests(sb, params, false);
        sb.append("\",\"variables\":").append(graphQLVariables.length() > 0 ? "{" + sbGraphQLValues + "}" : "null").append(",\"operationName\":null}");
        return sb.toString();
    }

    protected abstract String getGraphQLClassesPackageName();

    protected abstract QueryField getQueryContext() throws GraphQLRequestPreparationException;

    protected abstract QueryField getMutationContext() throws GraphQLRequestPreparationException;

    protected abstract QueryField getSubscriptionContext() throws GraphQLRequestPreparationException;

    public QueryField getQuery() {
        return this.query;
    }

    public QueryField getMutation() {
        return this.mutation;
    }

    public QueryField getSubscription() {
        return this.subscription;
    }

    public List<Fragment> getFragments() {
        return this.fragments;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public static GraphQLConfiguration getStaticConfiguration() {
        return staticConfiguration;
    }

    public static void setStaticConfiguration(GraphQLConfiguration staticConfiguration) {
        AbstractGraphQLRequest.staticConfiguration = staticConfiguration;
    }

    public GraphQLConfiguration getInstanceConfiguration() {
        return this.instanceConfiguration;
    }

    public void setInstanceConfiguration(GraphQLConfiguration instanceConfiguration) {
        this.instanceConfiguration = instanceConfiguration;
    }

    private static enum Step {
        NAME,
        TYPE;

    }
}

