/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.spring.client;

import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.netty.http.client.HttpClient;

@Configuration
public class GraphQLAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(GraphQLAutoConfiguration.class);
    @Value(value="${graphql.endpoint.url}")
    private String graphqlEndpointUrl;
    @Value(value="${graphql.endpoint.subscriptionUrl:${graphql.endpoint.url}}")
    @Deprecated
    private String graphqlEndpointSubscriptionUrl;

    @Bean
    String graphqlEndpoint() {
        return this.graphqlEndpointUrl;
    }

    @Bean
    @Deprecated
    String graphqlSubscriptionEndpoint() {
        return this.graphqlEndpointSubscriptionUrl;
    }

    @Bean
    @ConditionalOnMissingBean
    public WebClient webClient(String graphqlEndpoint, @Autowired(required=false) HttpClient httpClient, @Autowired(required=false) ServerOAuth2AuthorizedClientExchangeFilterFunction oauthFilter) {
        WebClient.Builder webClientBuilder = WebClient.builder().baseUrl(graphqlEndpoint).defaultHeader("Content-Type", new String[]{"application/json"}).defaultUriVariables(Collections.singletonMap("url", graphqlEndpoint));
        if (httpClient != null) {
            webClientBuilder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient));
        }
        if (oauthFilter != null) {
            webClientBuilder.filter((ExchangeFilterFunction)oauthFilter);
        }
        return webClientBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSocketClient webSocketClient(@Autowired(required=false) HttpClient httpClient) {
        if (httpClient == null) {
            return new ReactorNettyWebSocketClient(HttpClient.create());
        }
        return new ReactorNettyWebSocketClient(httpClient);
    }
}

