/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.client.GraphQLObjectMapper;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.util.GraphqlUtils;
import java.io.IOException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Mono;

public class GraphQLReactiveWebSocketHandler<R, T>
implements WebSocketHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    GraphqlUtils graphqlUtils = GraphqlUtils.graphqlUtils;
    final String request;
    final String subscriptionName;
    final SubscriptionCallback<T> subscriptionCallback;
    final GraphQLObjectMapper objectMapper;
    final Class<R> subscriptionType;
    final Class<T> messageType;
    WebSocketSession session = null;

    public GraphQLReactiveWebSocketHandler(String request, String subscriptionName, SubscriptionCallback<T> subscriptionCallback, Class<R> subscriptionType, Class<T> messsageType, GraphQLObjectMapper objectMapper) {
        this.request = request;
        this.subscriptionName = subscriptionName;
        this.subscriptionCallback = subscriptionCallback;
        this.subscriptionType = subscriptionType;
        this.messageType = messsageType;
        this.objectMapper = objectMapper;
    }

    public Mono<Void> handle(WebSocketSession sessionParam) {
        this.session = sessionParam;
        this.logger.trace("new web socket session received: {}", (Object)this.session);
        this.logger.trace("Before sending the subscription request into the web socket");
        Mono input = this.session.send((Publisher)Mono.just((Object)this.session.textMessage(this.request)).doAfterTerminate(() -> this.logger.trace("The subscription request has been written on the Websocket"))).thenMany((Publisher)this.session.receive()).doOnSubscribe(s -> this.onSubscribe((Subscription)s)).doOnNext(message -> this.onNext((WebSocketMessage)message)).doOnError(t -> this.onError((Throwable)t)).doOnComplete(() -> this.onComplete()).then();
        this.logger.trace("After sending the subscription request into the web socket");
        this.logger.trace("End of handle(session) method execution");
        return input;
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    public void onNext(WebSocketMessage message) {
        String msg = message.getPayloadAsText();
        this.logger.trace("Message received from the Web Socket: {} (on session {})", (Object)msg, (Object)this.session);
        try {
            R r = this.objectMapper.readValue(msg, this.subscriptionType);
            Object t = this.graphqlUtils.invokeGetter(r, this.subscriptionName);
            this.subscriptionCallback.onMessage(t);
        }
        catch (IOException e) {
            String errorMsg = "An error (" + e.getMessage() + ") occured while parsing a server message for subscription '" + this.subscriptionName + "'";
            if (this.logger.isTraceEnabled()) {
                errorMsg = errorMsg + ". The received message is <" + msg + ">";
            }
            this.logger.error(errorMsg);
            this.subscriptionCallback.onError(new GraphQLRequestExecutionException(errorMsg, e));
        }
    }

    public void onError(Throwable t) {
        this.logger.trace("Error received for WebSocketSession {}: {}", (Object)this.session, (Object)t.getMessage());
        this.subscriptionCallback.onError(t);
    }

    public void onComplete() {
        this.logger.trace("onComplete received for WebSocketSession {}: {}", (Object)this.session);
        this.subscriptionCallback.onClose(0, "onComplete");
    }

    public void onSubscribe(Subscription s) {
        this.subscriptionCallback.onConnect();
    }
}

