/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.GraphqlUtils;
import com.graphql_java_generator.annotation.GraphQLInputType;
import com.graphql_java_generator.client.response.GraphQLRequestExecutionException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class InputParameter {
    private static GraphqlUtils graphqlUtils = new GraphqlUtils();
    final String name;
    final String bindParameterName;
    final Object value;
    boolean mandatory;

    public static InputParameter newBindParameter(String name, String bindParameterName, boolean mandatory) {
        return new InputParameter(name, bindParameterName, null, mandatory);
    }

    public static InputParameter newHardCodedParameter(String name, Object value) {
        return new InputParameter(name, null, value, true);
    }

    private InputParameter(String name, String bindParameterName, Object value, boolean mandatory) {
        this.name = name;
        this.bindParameterName = bindParameterName;
        this.value = value;
        this.mandatory = mandatory;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueForGraphqlQuery(Map<String, Object> bindVariables) throws GraphQLRequestExecutionException {
        if (this.value == null) {
            if (this.mandatory && (bindVariables == null || !bindVariables.keySet().contains(this.bindParameterName))) {
                throw new GraphQLRequestExecutionException("The Bind Parameter for '" + this.bindParameterName + "' must be provided in the BindVariables map");
            }
            if (bindVariables == null || !bindVariables.keySet().contains(this.bindParameterName)) {
                return null;
            }
            return this.getValueForGraphqlQuery(bindVariables.get(this.bindParameterName));
        }
        return this.getValueForGraphqlQuery(this.value);
    }

    String getValueForGraphqlQuery(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return this.getStringValue((String)val);
        }
        if (val instanceof UUID) {
            return this.getStringValue(((UUID)val).toString());
        }
        if (val instanceof List) {
            return this.getListValue((List)val);
        }
        if (val.getClass().getAnnotation(GraphQLInputType.class) != null) {
            return this.getInputTypeStringValue(val);
        }
        return val.toString();
    }

    private String getStringValue(String str) {
        return "\\\"" + str.replace("\"", "\\\"") + "\\\"";
    }

    private String getListValue(List<?> list) {
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < list.size(); ++index) {
            Object obj = list.get(index);
            result.append(this.getValueForGraphqlQuery(obj));
            if (index >= list.size() - 1) continue;
            result.append(",");
        }
        return result.append("]").toString();
    }

    private String getInputTypeStringValue(Object object) {
        StringBuilder result = new StringBuilder("{");
        String separator = "";
        for (Field field : object.getClass().getDeclaredFields()) {
            Object val = graphqlUtils.invokeGetter(object, field.getName());
            if (val == null) continue;
            result.append(separator);
            result.append(field.getName());
            result.append(": ");
            result.append(this.getValueForGraphqlQuery(val));
            separator = ", ";
        }
        return result.append("}").toString();
    }
}

