/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserBuilder;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007J\b\u0010\t\u001a\u00020\u0006H\u0007J\b\u0010\n\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest;", "", "()V", "customScalarType", "Lgraphql/schema/GraphQLScalarType;", "should handle Optional type as method input argument", "", "should handle Optional type as method input argument with omission detection", "should handle lists of scalar types", "should handle proxies", "should handle scalar types as method input argument", "CustomScalar", "Resolver", "graphql-java-tools"})
public final class MethodFieldResolverTest {
    @NotNull
    private final GraphQLScalarType customScalarType;

    public MethodFieldResolverTest() {
        GraphQLScalarType graphQLScalarType = GraphQLScalarType.newScalar().name("CustomScalar").description("customScalar").coercing((Coercing)new Coercing<CustomScalar, String>(){

            @NotNull
            public CustomScalar parseValue(@NotNull Object input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return CustomScalar.Companion.of(input);
            }

            @NotNull
            public CustomScalar parseLiteral(@NotNull Object input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Object object = input;
                if (!(object instanceof StringValue)) {
                    throw new CoercingParseLiteralException();
                }
                String string = ((StringValue)input).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.value");
                return CustomScalar.Companion.of(string);
            }

            @NotNull
            public String serialize(@NotNull Object dataFetcherResult) {
                Intrinsics.checkNotNullParameter((Object)dataFetcherResult, (String)"dataFetcherResult");
                Object object = dataFetcherResult;
                if (!(object instanceof CustomScalar)) {
                    throw new CoercingSerializeException();
                }
                return ((CustomScalar)dataFetcherResult).getValue();
            }
        }).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLScalarType, (String)"newScalar()\n        .name(\"CustomScalar\")\n        .description(\"customScalar\")\n        .coercing(object : Coercing<CustomScalar, String> {\n\n            override fun parseValue(input: Any) = CustomScalar.of(input)\n\n            override fun parseLiteral(input: Any): CustomScalar = when (input) {\n                is StringValue -> CustomScalar.of(input.value)\n                else -> throw CoercingParseLiteralException()\n            }\n\n            override fun serialize(dataFetcherResult: Any) = when (dataFetcherResult) {\n                is CustomScalar -> dataFetcherResult.value\n                else -> throw CoercingSerializeException()\n            }\n        })\n        .build()");
        this.customScalarType = graphQLScalarType;
    }

    @Test
    public final void should handle Optional type as method input argument() {
        GraphQLScalarType[] graphQLScalarTypeArray = new GraphQLScalarType[]{this.customScalarType};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    testValue(input: String): String\n                    testOmitted(input: String): String\n                    testNull(input: String): String\n                }\n                ").scalars(graphQLScalarTypeArray);
        graphQLScalarTypeArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final String testValue(@NotNull Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.toString()");
                return string;
            }

            @NotNull
            public final String testOmitted(@NotNull Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.toString()");
                return string;
            }

            @NotNull
            public final String testNull(@NotNull Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.toString()");
                return string;
            }
        }};
        GraphQLSchema schema2 = schemaParserBuilder.resolvers((GraphQLResolver[])graphQLScalarTypeArray).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n            query {\n                testValue(input: \"test-value\")\n                testOmitted\n                testNull(input: null)\n            }\n            ").root(new Object()));
        Pair[] pairArray = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"result.getData()");
        Pair[] pairArray2 = pairArray;
        pairArray = new Pair[]{TuplesKt.to((Object)"testValue", (Object)"Optional[test-value]"), TuplesKt.to((Object)"testOmitted", (Object)"Optional.empty"), TuplesKt.to((Object)"testNull", (Object)"Optional.empty")};
        TestUtilsKt.assertEquals(pairArray2, MapsKt.mapOf((Pair[])pairArray));
    }

    @Test
    public final void should handle Optional type as method input argument with omission detection() {
        GraphQLScalarType[] graphQLScalarTypeArray = new GraphQLScalarType[]{this.customScalarType};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    testValue(input: String): String\n                    testOmitted(input: String): String\n                    testNull(input: String): String\n                }\n                ").scalars(graphQLScalarTypeArray);
        graphQLScalarTypeArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final String testValue(@NotNull Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.toString()");
                return string;
            }

            @NotNull
            public final String testOmitted(@Nullable Optional<String> input) {
                return String.valueOf(input);
            }

            @NotNull
            public final String testNull(@NotNull Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.toString()");
                return string;
            }
        }};
        GraphQLSchema schema2 = schemaParserBuilder.resolvers((GraphQLResolver[])graphQLScalarTypeArray).options(SchemaParserOptions.Companion.newOptions().inputArgumentOptionalDetectOmission(true).build()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n            query {\n                testValue(input: \"test-value\")\n                testOmitted\n                testNull(input: null)\n            }\n            ").root(new Object()));
        Pair[] pairArray = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"result.getData()");
        Pair[] pairArray2 = pairArray;
        pairArray = new Pair[]{TuplesKt.to((Object)"testValue", (Object)"Optional[test-value]"), TuplesKt.to((Object)"testOmitted", (Object)"null"), TuplesKt.to((Object)"testNull", (Object)"Optional.empty")};
        TestUtilsKt.assertEquals(pairArray2, MapsKt.mapOf((Pair[])pairArray));
    }

    @Test
    public final void should handle scalar types as method input argument() {
        GraphQLScalarType[] graphQLScalarTypeArray = new GraphQLScalarType[]{this.customScalarType};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                scalar CustomScalar\n                type Query {\n                    test(input: CustomScalar): Int\n                }\n                ").scalars(graphQLScalarTypeArray);
        graphQLScalarTypeArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            public final int test(@NotNull CustomScalar scalar) {
                Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
                return scalar.getValue().length();
            }
        }};
        GraphQLSchema schema2 = schemaParserBuilder.resolvers((GraphQLResolver[])graphQLScalarTypeArray).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n            query Test($input: CustomScalar) {\n                test(input: $input)\n            }\n            ").variables(MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)"FooBar"))).root(new Object()));
        Object object = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.getData()");
        TestUtilsKt.assertEquals(object, MapsKt.mapOf((Pair)TuplesKt.to((Object)"test", (Object)6)));
    }

    @Test
    public final void should handle lists of scalar types() {
        GraphQLScalarType[] graphQLScalarTypeArray = new GraphQLScalarType[]{this.customScalarType};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                scalar CustomScalar\n                type Query {\n                    test(input: [CustomScalar]): Int\n                }\n                ").scalars(graphQLScalarTypeArray);
        graphQLScalarTypeArray = new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            /*
             * WARNING - void declaration
             */
            public final int test(@NotNull List<CustomScalar> scalars) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(scalars, (String)"scalars");
                Iterable $this$map$iv = scalars;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CustomScalar customScalar = (CustomScalar)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Integer n = it.getValue().length();
                    collection.add(n);
                }
                return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
            }
        }};
        GraphQLSchema schema2 = schemaParserBuilder.resolvers((GraphQLResolver[])graphQLScalarTypeArray).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        Object object = new String[]{"Foo", "Bar"};
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n            query Test($input: [CustomScalar]) {\n                test(input: $input)\n            }\n            ").variables(MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)CollectionsKt.listOf((Object[])object)))).root(new Object()));
        object = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.getData()");
        TestUtilsKt.assertEquals(object, MapsKt.mapOf((Pair)TuplesKt.to((Object)"test", (Object)6)));
    }

    @Test
    public final void should handle proxies() {
        InvocationHandler invocationHandler2 = new InvocationHandler(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public Object invoke(@NotNull Object proxy, @NotNull Method method, @NotNull Object[] args) {
                Serializable serializable;
                Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                String string = method.getName();
                if (string != null) {
                    int n = -1;
                    switch (string.hashCode()) {
                        case 3556498: {
                            if (!string.equals("test")) break;
                            n = 1;
                            break;
                        }
                        case 147696667: {
                            if (!string.equals("hashCode")) break;
                            n = 2;
                            break;
                        }
                        case -1295482945: {
                            if (!string.equals("equals")) break;
                            n = 3;
                            break;
                        }
                        case -1776922004: {
                            if (!string.equals("toString")) break;
                            n = 4;
                            break;
                        }
                    }
                    switch (n) {
                        case 4: {
                            serializable = (Serializable)((Object)Intrinsics.stringPlus((String)"Proxy$", (Object)System.identityHashCode(this)));
                            return serializable;
                        }
                        case 2: {
                            serializable = Integer.valueOf(System.identityHashCode(this));
                            return serializable;
                        }
                        case 3: {
                            serializable = Boolean.valueOf(Proxy.isProxyClass(args[0].getClass()));
                            return serializable;
                        }
                        case 1: {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = (List)args[0];
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                            while (true) {
                                void it;
                                T item$iv$iv;
                                if (!iterator.hasNext()) {
                                    serializable = Integer.valueOf(CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv)));
                                    return serializable;
                                }
                                T t = item$iv$iv = iterator.next();
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                if (it == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type graphql.kickstart.tools.MethodFieldResolverTest.CustomScalar");
                                }
                                Integer n2 = ((CustomScalar)it).getValue().length();
                                collection.add(n2);
                            }
                        }
                    }
                }
                serializable = new UnsupportedOperationException();
                return serializable;
            }
        };
        Class[] classArray = new Class[]{Resolver.class, GraphQLQueryResolver.class};
        Object object = Proxy.newProxyInstance(MethodFieldResolverTest.class.getClassLoader(), classArray, invocationHandler2);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type graphql.kickstart.tools.GraphQLQueryResolver");
        }
        GraphQLQueryResolver resolver2 = (GraphQLQueryResolver)object;
        classArray = new GraphQLScalarType[]{this.customScalarType};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                scalar CustomScalar\n                type Query {\n                    test(input: [CustomScalar]): Int\n                }\n                ").scalars((GraphQLScalarType[])classArray);
        classArray = new GraphQLResolver[]{(GraphQLResolver)resolver2};
        GraphQLSchema schema2 = schemaParserBuilder.resolvers((GraphQLResolver[])classArray).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        Object object2 = new String[]{"Foo", "Bar"};
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n            query Test($input: [CustomScalar]) {\n                test(input: $input)\n            }\n            ").variables(MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)CollectionsKt.listOf((Object[])object2)))).root(new Object()));
        object2 = result.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"result.getData()");
        TestUtilsKt.assertEquals(object2, MapsKt.mapOf((Pair)TuplesKt.to((Object)"test", (Object)6)));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar;", "", "internalValue", "", "(Ljava/lang/String;)V", "value", "getValue", "()Ljava/lang/String;", "Companion", "graphql-java-tools"})
    public static final class CustomScalar {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String internalValue;

        private CustomScalar(String internalValue) {
            this.internalValue = internalValue;
        }

        @NotNull
        public final String getValue() {
            return this.internalValue;
        }

        public /* synthetic */ CustomScalar(String internalValue, DefaultConstructorMarker $constructor_marker) {
            this(internalValue);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar$Companion;", "", "()V", "of", "Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar;", "input", "graphql-java-tools"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CustomScalar of(@NotNull Object input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Object object = input;
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException();
                }
                return new CustomScalar((String)input, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest$Resolver;", "", "test", "", "scalars", "", "Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar;", "graphql-java-tools"})
    public static interface Resolver {
        public int test(@NotNull List<CustomScalar> var1);
    }
}

