/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools.util;

import graphql.kickstart.tools.TestUtilsKt;
import graphql.kickstart.tools.util.BiMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007J\b\u0010\u000e\u001a\u00020\fH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0007J\b\u0010\u0010\u001a\u00020\fH\u0007J\b\u0010\u0011\u001a\u00020\fH\u0007R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lgraphql/kickstart/tools/util/BiMapTest;", "", "()V", "bimap", "Lgraphql/kickstart/tools/util/BiMap;", "", "", "getBimap", "()Lgraphql/kickstart/tools/util/BiMap;", "setBimap", "(Lgraphql/kickstart/tools/util/BiMap;)V", "setup", "", "should allow same key new value", "should allow same key same value", "should not permit duplicate values", "should provide inverse view", "should return correct values", "graphql-java-tools"})
public final class BiMapTest {
    public BiMap<String, Integer> bimap;

    @NotNull
    public final BiMap<String, Integer> getBimap() {
        BiMap<String, Integer> biMap = this.bimap;
        if (biMap != null) {
            return biMap;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        throw null;
    }

    public final void setBimap(@NotNull BiMap<String, Integer> biMap) {
        Intrinsics.checkNotNullParameter(biMap, (String)"<set-?>");
        this.bimap = biMap;
    }

    @Before
    public final void setup() {
        BiMap biMap = BiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"create()");
        this.setBimap((BiMap<String, Integer>)biMap);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void should not permit duplicate values() {
        Map map = (Map)this.getBimap();
        String string = "foo";
        Integer n = 1;
        boolean bl = false;
        map.put(string, n);
        map = (Map)this.getBimap();
        string = "bar";
        n = 1;
        bl = false;
        map.put(string, n);
    }

    @Test
    public final void should allow same key same value() {
        Map map = (Map)this.getBimap();
        String string = "foo";
        Integer n = 1;
        boolean bl = false;
        map.put(string, n);
        map = (Map)this.getBimap();
        string = "foo";
        n = 1;
        bl = false;
        map.put(string, n);
    }

    @Test
    public final void should allow same key new value() {
        Map map = (Map)this.getBimap();
        Object object = "foo";
        Object object2 = Integer.valueOf(1);
        boolean bl = false;
        map.put(object, object2);
        map = (Map)this.getBimap();
        object = "bar";
        object2 = 2;
        bl = false;
        map.put(object, object2);
        object2 = (Integer)this.getBimap().put((Object)"bar", (Object)3);
        Intrinsics.checkNotNull((Object)object2);
        object = object2;
        int old = ((Number)object).intValue();
        TestUtilsKt.assertEquals(2L, Long.valueOf(old));
        object2 = new Integer[]{1, 3};
        Set expected = new HashSet(Arrays.asList(object2));
        object2 = this.getBimap().values();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"bimap.values");
        TestUtilsKt.assertEquals(expected, object2);
        object2 = this.getBimap().inverse().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"bimap.inverse().keys");
        TestUtilsKt.assertEquals(expected, object2);
    }

    @Test
    public final void should provide inverse view() {
        Map map = (Map)this.getBimap();
        String string = "foo";
        Integer n = 1;
        boolean bl = false;
        map.put(string, n);
        map = (Map)this.getBimap();
        string = "bar";
        n = 2;
        bl = false;
        map.put(string, n);
        map = (Map)this.getBimap();
        string = "baz";
        n = 3;
        bl = false;
        map.put(string, n);
        BiMap inverse = this.getBimap().inverse();
        Assert.assertTrue((boolean)inverse.containsKey((Object)1));
        Assert.assertTrue((boolean)inverse.containsKey((Object)2));
        Assert.assertTrue((boolean)inverse.containsKey((Object)3));
        TestUtilsKt.assertEquals(inverse.get((Object)1), "foo");
        TestUtilsKt.assertEquals(inverse.get((Object)2), "bar");
        TestUtilsKt.assertEquals(inverse.get((Object)3), "baz");
    }

    @Test
    public final void should return correct values() {
        Map map = (Map)this.getBimap();
        Object object = "foo";
        Object[] objectArray = Integer.valueOf(1);
        boolean bl = false;
        map.put(object, objectArray);
        map = (Map)this.getBimap();
        object = "bar";
        objectArray = 2;
        bl = false;
        map.put(object, objectArray);
        map = (Map)this.getBimap();
        object = "baz";
        objectArray = 3;
        bl = false;
        map.put(object, objectArray);
        object = this.getBimap().values();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bimap.values");
        Set values = (Set)object;
        objectArray = new Integer[]{1, 2, 3};
        Set expected = SetsKt.setOf((Object[])objectArray);
        TestUtilsKt.assertEquals(expected, values);
    }
}

