/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.Scalars;
import graphql.annotations.GraphQLAnnotationsProcessor;
import graphql.annotations.GraphQLDescription;
import graphql.annotations.GraphQLName;
import graphql.annotations.GraphQLNonNull;
import graphql.annotations.TypeFunction;
import graphql.annotations.util.NamingKit;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;

@Component(scope=ServiceScope.SINGLETON, property={"type=default"})
public class DefaultTypeFunction
implements TypeFunction {
    @Reference(target="(!(type=default))", policyOption=ReferencePolicyOption.GREEDY)
    protected List<TypeFunction> otherFunctions = new ArrayList<TypeFunction>();
    private CopyOnWriteArrayList<TypeFunction> typeFunctions = new CopyOnWriteArrayList();
    GraphQLAnnotationsProcessor annotationsProcessor;

    @Override
    public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
        return this.getTypeFunction(aClass, annotatedType) != null;
    }

    void setAnnotationsProcessor(GraphQLAnnotationsProcessor annotationsProcessor) {
        this.annotationsProcessor = annotationsProcessor;
    }

    public DefaultTypeFunction() {
        this.typeFunctions.add(new StringFunction());
        this.typeFunctions.add(new BooleanFunction());
        this.typeFunctions.add(new FloatFunction());
        this.typeFunctions.add(new IntegerFunction());
        this.typeFunctions.add(new LongFunction());
        this.typeFunctions.add(new IterableFunction());
        this.typeFunctions.add(new StreamFunction());
        this.typeFunctions.add(new EnumFunction());
        this.typeFunctions.add(new OptionalFunction());
        this.typeFunctions.add(new ObjectFunction());
    }

    @Activate
    protected void activate() {
        for (TypeFunction function : this.otherFunctions) {
            this.register(function);
        }
    }

    public Class<DefaultTypeFunction> register(TypeFunction function) {
        this.typeFunctions.add(0, function);
        return DefaultTypeFunction.class;
    }

    @Override
    public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
        TypeFunction typeFunction = this.getTypeFunction(aClass, annotatedType);
        if (typeFunction == null) {
            throw new IllegalArgumentException("unsupported type");
        }
        return typeFunction.getTypeName(aClass, annotatedType);
    }

    @Override
    public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
        TypeFunction typeFunction = this.getTypeFunction(aClass, annotatedType);
        if (typeFunction == null) {
            throw new IllegalArgumentException("unsupported type");
        }
        GraphQLType result = typeFunction.buildType(typeName, aClass, annotatedType);
        if (aClass.getAnnotation(GraphQLNonNull.class) != null || annotatedType != null && annotatedType.getAnnotation(GraphQLNonNull.class) != null) {
            result = new graphql.schema.GraphQLNonNull(result);
        }
        return result;
    }

    private TypeFunction getTypeFunction(Class<?> aClass, AnnotatedType annotatedType) {
        for (TypeFunction typeFunction : this.typeFunctions) {
            if (!typeFunction.canBuildType(aClass, annotatedType)) continue;
            return typeFunction;
        }
        return null;
    }

    private class ObjectFunction
    implements TypeFunction {
        private final Map<String, GraphQLTypeReference> processing = new ConcurrentHashMap<String, GraphQLTypeReference>();
        private final Map<String, GraphQLType> types = new ConcurrentHashMap<String, GraphQLType>();

        private ObjectFunction() {
        }

        @Override
        public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
            GraphQLName name = aClass.getAnnotation(GraphQLName.class);
            return NamingKit.toGraphqlName(name == null ? aClass.getName() : name.value());
        }

        @Override
        public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
            return true;
        }

        @Override
        public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
            if (this.types.containsKey(typeName)) {
                return this.types.get(typeName);
            }
            if (this.processing.containsKey(typeName)) {
                return (GraphQLType)this.processing.getOrDefault(typeName, new GraphQLTypeReference(typeName));
            }
            this.processing.put(typeName, new GraphQLTypeReference(typeName));
            Object type = aClass.isInterface() ? DefaultTypeFunction.this.annotationsProcessor.getInterface(aClass) : DefaultTypeFunction.this.annotationsProcessor.getObjectOrRef(aClass);
            this.types.put(typeName, (GraphQLType)type);
            this.processing.remove(typeName);
            return type;
        }
    }

    private class EnumFunction
    implements TypeFunction {
        private final Map<String, GraphQLTypeReference> processing = new ConcurrentHashMap<String, GraphQLTypeReference>();
        private final Map<String, GraphQLType> types = new ConcurrentHashMap<String, GraphQLType>();

        private EnumFunction() {
        }

        @Override
        public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
            GraphQLName name = aClass.getAnnotation(GraphQLName.class);
            return NamingKit.toGraphqlName(name == null ? aClass.getSimpleName() : name.value());
        }

        @Override
        public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
            return Enum.class.isAssignableFrom(aClass);
        }

        @Override
        public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
            if (this.types.containsKey(typeName)) {
                return this.types.get(typeName);
            }
            if (this.processing.containsKey(typeName)) {
                return (GraphQLType)this.processing.getOrDefault(typeName, new GraphQLTypeReference(typeName));
            }
            this.processing.put(typeName, new GraphQLTypeReference(typeName));
            Class<?> enumClass = aClass;
            GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum();
            builder.name(typeName);
            GraphQLDescription description = aClass.getAnnotation(GraphQLDescription.class);
            if (description != null) {
                builder.description(description.value());
            }
            List<?> constants = Arrays.asList(enumClass.getEnumConstants());
            Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).forEachOrdered(n -> {
                try {
                    Field field = aClass.getField((String)n);
                    GraphQLName fieldName = field.getAnnotation(GraphQLName.class);
                    GraphQLDescription fieldDescription = field.getAnnotation(GraphQLDescription.class);
                    Enum constant = constants.stream().filter(c -> c.name().contentEquals((CharSequence)n)).findFirst().get();
                    String name_ = fieldName == null ? n : fieldName.value();
                    builder.value(name_, (Object)constant, fieldDescription == null ? name_ : fieldDescription.value());
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            });
            GraphQLEnumType type = builder.build();
            this.types.put(typeName, (GraphQLType)type);
            this.processing.remove(type);
            return type;
        }
    }

    private class OptionalFunction
    implements TypeFunction {
        private OptionalFunction() {
        }

        @Override
        public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
            return aClass == Optional.class;
        }

        @Override
        public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
            AnnotatedType arg = this.getAnnotatedType(annotatedType);
            return DefaultTypeFunction.this.getTypeName(this.getClass(annotatedType), arg);
        }

        @Override
        public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
            AnnotatedType arg = this.getAnnotatedType(annotatedType);
            return DefaultTypeFunction.this.buildType(typeName, this.getClass(annotatedType), arg);
        }

        private AnnotatedType getAnnotatedType(AnnotatedType annotatedType) {
            if (!(annotatedType instanceof AnnotatedParameterizedType)) {
                throw new IllegalArgumentException("Optional type parameter should be specified");
            }
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            return parameterizedType.getAnnotatedActualTypeArguments()[0];
        }

        private Class<?> getClass(AnnotatedType annotatedType) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType arg = parameterizedType.getAnnotatedActualTypeArguments()[0];
            if (arg.getType() instanceof ParameterizedType) {
                return (Class)((ParameterizedType)arg.getType()).getRawType();
            }
            return (Class)arg.getType();
        }
    }

    private class StreamFunction
    implements TypeFunction {
        private StreamFunction() {
        }

        @Override
        public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
            return Stream.class.isAssignableFrom(aClass);
        }

        @Override
        public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
            if (!(annotatedType instanceof AnnotatedParameterizedType)) {
                throw new IllegalArgumentException("Stream type parameter should be specified");
            }
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType arg = parameterizedType.getAnnotatedActualTypeArguments()[0];
            Class klass = arg.getType() instanceof ParameterizedType ? (Class)((ParameterizedType)arg.getType()).getRawType() : (Class)arg.getType();
            return new GraphQLList(DefaultTypeFunction.this.buildType(klass, arg));
        }
    }

    private class IterableFunction
    implements TypeFunction {
        private IterableFunction() {
        }

        @Override
        public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
            return Iterable.class.isAssignableFrom(aClass);
        }

        @Override
        public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
            if (!(annotatedType instanceof AnnotatedParameterizedType)) {
                throw new IllegalArgumentException("List type parameter should be specified");
            }
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType arg = parameterizedType.getAnnotatedActualTypeArguments()[0];
            Class klass = arg.getType() instanceof ParameterizedType ? (Class)((ParameterizedType)arg.getType()).getRawType() : (Class)arg.getType();
            return new GraphQLList(DefaultTypeFunction.this.buildType(klass, arg));
        }
    }

    private class LongFunction
    implements TypeFunction {
        private LongFunction() {
        }

        @Override
        public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLLong.getName();
        }

        @Override
        public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
            return aClass == Long.class || aClass == Long.TYPE;
        }

        @Override
        public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLLong;
        }
    }

    private class IntegerFunction
    implements TypeFunction {
        private IntegerFunction() {
        }

        @Override
        public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLInt.getName();
        }

        @Override
        public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
            return aClass == Integer.class || aClass == Integer.TYPE;
        }

        @Override
        public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLInt;
        }
    }

    private class FloatFunction
    implements TypeFunction {
        private FloatFunction() {
        }

        @Override
        public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLFloat.getName();
        }

        @Override
        public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
            return aClass == Float.class || aClass == Float.TYPE || aClass == Double.class || aClass == Double.TYPE;
        }

        @Override
        public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLFloat;
        }
    }

    private class BooleanFunction
    implements TypeFunction {
        private BooleanFunction() {
        }

        @Override
        public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLBoolean.getName();
        }

        @Override
        public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
            return aClass == Boolean.class || aClass == Boolean.TYPE;
        }

        @Override
        public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLBoolean;
        }
    }

    private class StringFunction
    implements TypeFunction {
        private StringFunction() {
        }

        @Override
        public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLString.getName();
        }

        @Override
        public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
            return aClass == String.class;
        }

        @Override
        public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLString;
        }
    }
}

