/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.InvalidSyntaxError;
import graphql.execution.Execution;
import graphql.execution.ExecutionStrategy;
import graphql.language.Document;
import graphql.language.SourceLocation;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import graphql.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQL {
    private final GraphQLSchema graphQLSchema;
    private final ExecutionStrategy executionStrategy;
    private static final Logger log = LoggerFactory.getLogger(GraphQL.class);

    public GraphQL(GraphQLSchema graphQLSchema) {
        this(graphQLSchema, null);
    }

    public GraphQL(GraphQLSchema graphQLSchema, ExecutionStrategy executionStrategy) {
        this.graphQLSchema = graphQLSchema;
        this.executionStrategy = executionStrategy;
    }

    public ExecutionResult execute(String requestString) {
        return this.execute(requestString, null);
    }

    public ExecutionResult execute(String requestString, Object context) {
        return this.execute(requestString, context, Collections.<String, Object>emptyMap());
    }

    public ExecutionResult execute(String requestString, String operationName, Object context) {
        return this.execute(requestString, operationName, context, Collections.<String, Object>emptyMap());
    }

    public ExecutionResult execute(String requestString, Object context, Map<String, Object> arguments) {
        return this.execute(requestString, null, context, arguments);
    }

    public ExecutionResult execute(String requestString, String operationName, Object context, Map<String, Object> arguments) {
        Document document;
        Assert.assertNotNull(arguments, "arguments can't be null");
        log.info("Executing request. operation name: {}. Request: {} ", (Object)operationName, (Object)requestString);
        Parser parser = new Parser();
        try {
            document = parser.parseDocument(requestString);
        }
        catch (ParseCancellationException e) {
            RecognitionException recognitionException = (RecognitionException)e.getCause();
            SourceLocation sourceLocation = new SourceLocation(recognitionException.getOffendingToken().getLine(), recognitionException.getOffendingToken().getCharPositionInLine());
            InvalidSyntaxError invalidSyntaxError = new InvalidSyntaxError(sourceLocation);
            return new ExecutionResultImpl(Arrays.asList(invalidSyntaxError));
        }
        Validator validator = new Validator();
        List<ValidationError> validationErrors = validator.validateDocument(this.graphQLSchema, document);
        if (validationErrors.size() > 0) {
            return new ExecutionResultImpl(validationErrors);
        }
        Execution execution = new Execution(this.executionStrategy);
        return execution.execute(this.graphQLSchema, context, document, operationName, arguments);
    }
}

