/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.schema.GraphQLArgument;
import java.util.ArrayList;
import java.util.List;

public class GraphQLDirective {
    private final String name;
    private final String description;
    private final List<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
    private final boolean onOperation;
    private final boolean onFragment;
    private final boolean onField;

    public GraphQLDirective(String name, String description, List<GraphQLArgument> arguments, boolean onOperation, boolean onFragment, boolean onField) {
        Assert.assertNotNull(name, "name can't be null");
        Assert.assertNotNull(arguments, "arguments can't be null");
        this.name = name;
        this.description = description;
        this.arguments.addAll(arguments);
        this.onOperation = onOperation;
        this.onFragment = onFragment;
        this.onField = onField;
    }

    public String getName() {
        return this.name;
    }

    public List<GraphQLArgument> getArguments() {
        return new ArrayList<GraphQLArgument>(this.arguments);
    }

    public GraphQLArgument getArgument(String name) {
        for (GraphQLArgument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    public boolean isOnOperation() {
        return this.onOperation;
    }

    public boolean isOnFragment() {
        return this.onFragment;
    }

    public boolean isOnField() {
        return this.onField;
    }

    public String getDescription() {
        return this.description;
    }

    public static Builder newDirective() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private final List<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
        private String description;
        private boolean onOperation;
        private boolean onFragment;
        private boolean onField;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder argument(GraphQLArgument fieldArgument) {
            this.arguments.add(fieldArgument);
            return this;
        }

        public Builder onOperation(boolean onOperation) {
            this.onOperation = onOperation;
            return this;
        }

        public Builder onFragment(boolean onFragment) {
            this.onFragment = onFragment;
            return this;
        }

        public Builder onField(boolean onField) {
            this.onField = onField;
            return this;
        }

        public GraphQLDirective build() {
            return new GraphQLDirective(this.name, this.description, this.arguments, this.onOperation, this.onFragment, this.onField);
        }
    }
}

