/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.GraphQLException;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ValuesResolver;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLSchema;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExecutionContextBuilder {
    private ValuesResolver valuesResolver;

    public ExecutionContextBuilder(ValuesResolver valuesResolver) {
        this.valuesResolver = valuesResolver;
    }

    public ExecutionContext build(GraphQLSchema graphQLSchema, ExecutionStrategy executionStrategy, Object root, Document document, String operationName, Map<String, Object> args) {
        LinkedHashMap<String, FragmentDefinition> fragmentsByName = new LinkedHashMap<String, FragmentDefinition>();
        LinkedHashMap<String, OperationDefinition> operationsByName = new LinkedHashMap<String, OperationDefinition>();
        for (Definition definition : document.getDefinitions()) {
            if (definition instanceof OperationDefinition) {
                OperationDefinition operationDefinition = (OperationDefinition)definition;
                operationsByName.put(operationDefinition.getName(), operationDefinition);
            }
            if (!(definition instanceof FragmentDefinition)) continue;
            FragmentDefinition fragmentDefinition = (FragmentDefinition)definition;
            fragmentsByName.put(fragmentDefinition.getName(), fragmentDefinition);
        }
        if (operationName != null && operationsByName.size() > 1) {
            throw new GraphQLException("missing operation name");
        }
        OperationDefinition operation = operationName == null ? (OperationDefinition)operationsByName.values().iterator().next() : (OperationDefinition)operationsByName.get(operationName);
        if (operation == null) {
            throw new GraphQLException();
        }
        ExecutionContext executionContext = new ExecutionContext();
        executionContext.setGraphQLSchema(graphQLSchema);
        executionContext.setExecutionStrategy(executionStrategy);
        executionContext.setOperationDefinition(operation);
        executionContext.setRoot(root);
        executionContext.setFragmentsByName(fragmentsByName);
        Map<String, Object> variableValues = this.valuesResolver.getVariableValues(graphQLSchema, operation.getVariableDefinitions(), args);
        executionContext.setVariables(variableValues);
        return executionContext;
    }
}

