/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.language.EnumValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GraphQLEnumType
implements GraphQLType,
GraphQLInputType,
GraphQLOutputType,
GraphQLUnmodifiedType {
    private final String name;
    private final String description;
    private final Map<String, GraphQLEnumValueDefinition> valueDefinitionMap = new LinkedHashMap<String, GraphQLEnumValueDefinition>();
    private final Coercing coercing = new Coercing(){

        @Override
        public Object serialize(Object input) {
            return GraphQLEnumType.this.getNameByValue(input);
        }

        @Override
        public Object parseValue(Object input) {
            return GraphQLEnumType.this.getValueByName(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (!(input instanceof EnumValue)) {
                return null;
            }
            EnumValue enumValue = (EnumValue)input;
            GraphQLEnumValueDefinition enumValueDefinition = (GraphQLEnumValueDefinition)GraphQLEnumType.this.valueDefinitionMap.get(enumValue.getName());
            if (enumValueDefinition == null) {
                return null;
            }
            return enumValueDefinition.getValue();
        }
    };

    private Object getValueByName(Object value) {
        GraphQLEnumValueDefinition enumValueDefinition = this.valueDefinitionMap.get(value);
        if (enumValueDefinition != null) {
            return enumValueDefinition.getValue();
        }
        return null;
    }

    private Object getNameByValue(Object value) {
        for (GraphQLEnumValueDefinition valueDefinition : this.valueDefinitionMap.values()) {
            if (!value.equals(valueDefinition.getValue())) continue;
            return valueDefinition.getName();
        }
        return null;
    }

    public List<GraphQLEnumValueDefinition> getValues() {
        return new ArrayList<GraphQLEnumValueDefinition>(this.valueDefinitionMap.values());
    }

    public GraphQLEnumType(String name, String description, List<GraphQLEnumValueDefinition> values) {
        Assert.assertNotNull(name, "name can't be null");
        this.name = name;
        this.description = description;
        this.buildMap(values);
    }

    private void buildMap(List<GraphQLEnumValueDefinition> values) {
        for (GraphQLEnumValueDefinition valueDefinition : values) {
            this.valueDefinitionMap.put(valueDefinition.getName(), valueDefinition);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Coercing getCoercing() {
        return this.coercing;
    }

    public static Builder newEnum() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private final List<GraphQLEnumValueDefinition> values = new ArrayList<GraphQLEnumValueDefinition>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder value(String name, Object value, String description) {
            this.values.add(new GraphQLEnumValueDefinition(name, description, value));
            return this;
        }

        public Builder value(String name, Object value) {
            this.values.add(new GraphQLEnumValueDefinition(name, null, value));
            return this;
        }

        public Builder value(String name) {
            this.values.add(new GraphQLEnumValueDefinition(name, null, name));
            return this;
        }

        public GraphQLEnumType build() {
            return new GraphQLEnumType(this.name, this.description, this.values);
        }
    }
}

