/*
 * Decompiled with CFR 0.152.
 */
package graphql.relay;

import graphql.Scalars;
import graphql.relay.Base64;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.TypeResolver;
import java.util.ArrayList;
import java.util.List;

public class Relay {
    public static final String NODE = "Node";
    private GraphQLObjectType pageInfoType = GraphQLObjectType.newObject().name("PageInfo").description("Information about pagination in a connection.").field(GraphQLFieldDefinition.newFieldDefinition().name("hasNextPage").type(new GraphQLNonNull(Scalars.GraphQLBoolean)).description("When paginating forwards, are there more items?").build()).field(GraphQLFieldDefinition.newFieldDefinition().name("hasPreviousPage").type(new GraphQLNonNull(Scalars.GraphQLBoolean)).description("When paginating backwards, are there more items?").build()).field(GraphQLFieldDefinition.newFieldDefinition().name("startCursor").type(Scalars.GraphQLString).description("When paginating backwards, the cursor to continue.").build()).field(GraphQLFieldDefinition.newFieldDefinition().name("endCursor").type(Scalars.GraphQLString).description("When paginating forwards, the cursor to continue.").build()).build();

    public GraphQLInterfaceType nodeInterface(TypeResolver typeResolver) {
        GraphQLInterfaceType node = GraphQLInterfaceType.newInterface().name(NODE).description("An object with an ID").typeResolver(typeResolver).field(GraphQLFieldDefinition.newFieldDefinition().name("id").type(new GraphQLNonNull(Scalars.GraphQLID)).build()).build();
        return node;
    }

    public GraphQLFieldDefinition nodeField(GraphQLInterfaceType nodeInterface, DataFetcher nodeDataFetcher) {
        GraphQLFieldDefinition fieldDefinition = GraphQLFieldDefinition.newFieldDefinition().name("node").description("Fetches an object given its ID").type(nodeInterface).dataFetcher(nodeDataFetcher).argument(GraphQLArgument.newArgument().name("id").description("The ID of an object").type(new GraphQLNonNull(Scalars.GraphQLID)).build()).build();
        return fieldDefinition;
    }

    public List<GraphQLArgument> getConnectionFieldArguments() {
        ArrayList<GraphQLArgument> args = new ArrayList<GraphQLArgument>();
        args.add(GraphQLArgument.newArgument().name("before").type(Scalars.GraphQLString).build());
        args.add(GraphQLArgument.newArgument().name("after").type(Scalars.GraphQLString).build());
        args.add(GraphQLArgument.newArgument().name("first").type(Scalars.GraphQLInt).build());
        args.add(GraphQLArgument.newArgument().name("last").type(Scalars.GraphQLInt).build());
        return args;
    }

    public List<GraphQLArgument> getBackwardPaginationConnectionFieldArguments() {
        ArrayList<GraphQLArgument> args = new ArrayList<GraphQLArgument>();
        args.add(GraphQLArgument.newArgument().name("before").type(Scalars.GraphQLString).build());
        args.add(GraphQLArgument.newArgument().name("last").type(Scalars.GraphQLInt).build());
        return args;
    }

    public List<GraphQLArgument> getForwardPaginationConnectionFieldArguments() {
        ArrayList<GraphQLArgument> args = new ArrayList<GraphQLArgument>();
        args.add(GraphQLArgument.newArgument().name("after").type(Scalars.GraphQLString).build());
        args.add(GraphQLArgument.newArgument().name("first").type(Scalars.GraphQLInt).build());
        return args;
    }

    public GraphQLObjectType edgeType(String name, GraphQLOutputType nodeType, GraphQLInterfaceType nodeInterface, List<GraphQLFieldDefinition> edgeFields) {
        GraphQLObjectType edgeType = GraphQLObjectType.newObject().name(name + "Edge").description("An edge in a connection.").field(GraphQLFieldDefinition.newFieldDefinition().name("node").type(nodeType).description("The item at the end of the edge").build()).field(GraphQLFieldDefinition.newFieldDefinition().name("cursor").type(new GraphQLNonNull(Scalars.GraphQLString)).description("").build()).fields(edgeFields).build();
        return edgeType;
    }

    public GraphQLObjectType connectionType(String name, GraphQLObjectType edgeType, List<GraphQLFieldDefinition> connectionFields) {
        GraphQLObjectType connectionType = GraphQLObjectType.newObject().name(name + "Connection").description("A connection to a list of items.").field(GraphQLFieldDefinition.newFieldDefinition().name("edges").type(new GraphQLList(edgeType)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("pageInfo").type(new GraphQLNonNull(this.pageInfoType)).build()).fields(connectionFields).build();
        return connectionType;
    }

    public GraphQLFieldDefinition mutationWithClientMutationId(String name, String fieldName, List<GraphQLInputObjectField> inputFields, List<GraphQLFieldDefinition> outputFields, DataFetcher dataFetcher) {
        GraphQLInputObjectType inputObjectType = GraphQLInputObjectType.newInputObject().name(name + "Input").field(GraphQLInputObjectField.newInputObjectField().name("clientMutationId").type(new GraphQLNonNull(Scalars.GraphQLString)).build()).fields(inputFields).build();
        GraphQLObjectType outputType = GraphQLObjectType.newObject().name(name + "Payload").field(GraphQLFieldDefinition.newFieldDefinition().name("clientMutationId").type(new GraphQLNonNull(Scalars.GraphQLString)).build()).fields(outputFields).build();
        return GraphQLFieldDefinition.newFieldDefinition().name(fieldName).type(outputType).argument(GraphQLArgument.newArgument().name("input").type(new GraphQLNonNull(inputObjectType)).build()).dataFetcher(dataFetcher).build();
    }

    public String toGlobalId(String type, String id) {
        return Base64.toBase64(type + ":" + id);
    }

    public ResolvedGlobalId fromGlobalId(String globalId) {
        String[] split = Base64.fromBase64(globalId).split(":", 2);
        return new ResolvedGlobalId(split[0], split[1]);
    }

    public static class ResolvedGlobalId {
        public String type;
        public String id;

        public ResolvedGlobalId(String type, String id) {
            this.type = type;
            this.id = id;
        }
    }
}

