/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.GraphQLException;
import graphql.language.BooleanValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Scalars {
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger BYTE_MAX = BigInteger.valueOf(127L);
    private static final BigInteger BYTE_MIN = BigInteger.valueOf(-128L);
    private static final BigInteger SHORT_MAX = BigInteger.valueOf(32767L);
    private static final BigInteger SHORT_MIN = BigInteger.valueOf(-32768L);
    public static GraphQLScalarType GraphQLInt = new GraphQLScalarType("Int", "Built-in Int", new Coercing(){

        @Override
        public Object serialize(Object input) {
            if (input instanceof String) {
                return Integer.parseInt((String)input);
            }
            if (input instanceof Integer) {
                return input;
            }
            return null;
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (!(input instanceof IntValue)) {
                return null;
            }
            BigInteger value = ((IntValue)input).getValue();
            if (value.compareTo(INT_MIN) == -1 || value.compareTo(INT_MAX) == 1) {
                throw new GraphQLException("Int literal is too big or too small");
            }
            return value.intValue();
        }
    });
    public static GraphQLScalarType GraphQLLong = new GraphQLScalarType("Long", "Long type", new Coercing(){

        @Override
        public Object serialize(Object input) {
            if (input instanceof String) {
                return Long.parseLong((String)input);
            }
            if (input instanceof Long) {
                return input;
            }
            if (input instanceof Integer) {
                return ((Integer)input).longValue();
            }
            return null;
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return Long.parseLong(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                if (value.compareTo(LONG_MIN) < 0 || value.compareTo(LONG_MAX) > 0) {
                    throw new GraphQLException("Int literal is too big or too small for a long, would cause overflow");
                }
                return value.longValue();
            }
            return null;
        }
    });
    public static GraphQLScalarType GraphQLFloat = new GraphQLScalarType("Float", "Built-in Float", new Coercing(){

        @Override
        public Double serialize(Object input) {
            if (input instanceof String) {
                return Double.parseDouble((String)input);
            }
            if (input instanceof Double) {
                return (Double)input;
            }
            if (input instanceof Float) {
                return ((Float)input).floatValue();
            }
            if (input instanceof Integer) {
                return (double)((Integer)input);
            }
            return null;
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (input instanceof IntValue) {
                return ((IntValue)input).getValue().doubleValue();
            }
            if (input instanceof FloatValue) {
                return ((FloatValue)input).getValue().doubleValue();
            }
            return null;
        }
    });
    public static GraphQLScalarType GraphQLString = new GraphQLScalarType("String", "Built-in String", new Coercing(){

        @Override
        public Object serialize(Object input) {
            return input == null ? null : input.toString();
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            return ((StringValue)input).getValue();
        }
    });
    public static GraphQLScalarType GraphQLBoolean = new GraphQLScalarType("Boolean", "Built-in Boolean", new Coercing(){

        @Override
        public Object serialize(Object input) {
            if (input instanceof Boolean) {
                return input;
            }
            if (input instanceof Integer) {
                return (Integer)input > 0;
            }
            if (input instanceof String) {
                return Boolean.parseBoolean((String)input);
            }
            return null;
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (!(input instanceof BooleanValue)) {
                return null;
            }
            return ((BooleanValue)input).isValue();
        }
    });
    public static GraphQLScalarType GraphQLID = new GraphQLScalarType("ID", "Built-in ID", new Coercing(){

        @Override
        public Object serialize(Object input) {
            if (input instanceof String) {
                return input;
            }
            return null;
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            return ((StringValue)input).getValue();
        }
    });
    public static GraphQLScalarType GraphQLBigInteger = new GraphQLScalarType("BigInteger", "Built-in java.math.BigInteger", new Coercing(){

        @Override
        public BigInteger serialize(Object input) {
            if (input instanceof BigInteger) {
                return (BigInteger)input;
            }
            if (input instanceof String) {
                return new BigInteger((String)input);
            }
            if (input instanceof Integer) {
                return BigInteger.valueOf(((Integer)input).intValue());
            }
            if (input instanceof Long) {
                return BigInteger.valueOf((Long)input);
            }
            return null;
        }

        @Override
        public BigInteger parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public BigInteger parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return new BigInteger(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                return ((IntValue)input).getValue();
            }
            return null;
        }
    });
    public static GraphQLScalarType GraphQLBigDecimal = new GraphQLScalarType("BigDecimal", "Built-in java.math.BigDecimal", new Coercing(){

        @Override
        public BigDecimal serialize(Object input) {
            if (input instanceof BigDecimal) {
                return (BigDecimal)input;
            }
            if (input instanceof String) {
                return new BigDecimal((String)input);
            }
            if (input instanceof Float) {
                return BigDecimal.valueOf(((Float)input).floatValue());
            }
            if (input instanceof Double) {
                return BigDecimal.valueOf((Double)input);
            }
            if (input instanceof Integer) {
                return BigDecimal.valueOf(((Integer)input).intValue());
            }
            if (input instanceof Long) {
                return BigDecimal.valueOf((Long)input);
            }
            return null;
        }

        @Override
        public BigDecimal parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public BigDecimal parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return new BigDecimal(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                return new BigDecimal(((IntValue)input).getValue());
            }
            if (input instanceof FloatValue) {
                return ((FloatValue)input).getValue();
            }
            return null;
        }
    });
    public static GraphQLScalarType GraphQLByte = new GraphQLScalarType("Byte", "Built-in Byte as Int", new Coercing(){

        @Override
        public Byte serialize(Object input) {
            if (input instanceof String) {
                return Byte.parseByte((String)input);
            }
            if (input instanceof Byte) {
                return (Byte)input;
            }
            return null;
        }

        @Override
        public Byte parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Byte parseLiteral(Object input) {
            if (!(input instanceof IntValue)) {
                return null;
            }
            BigInteger value = ((IntValue)input).getValue();
            if (value.compareTo(BYTE_MIN) < 0 || value.compareTo(BYTE_MAX) > 0) {
                throw new GraphQLException("Int literal is too big or too small for a byte, would cause overflow");
            }
            return value.byteValue();
        }
    });
    public static GraphQLScalarType GraphQLShort = new GraphQLScalarType("Short", "Built-in Short as Int", new Coercing(){

        @Override
        public Short serialize(Object input) {
            if (input instanceof String) {
                return Short.parseShort((String)input);
            }
            if (input instanceof Short) {
                return (Short)input;
            }
            return null;
        }

        @Override
        public Short parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Short parseLiteral(Object input) {
            if (!(input instanceof IntValue)) {
                return null;
            }
            BigInteger value = ((IntValue)input).getValue();
            if (value.compareTo(SHORT_MIN) < 0 || value.compareTo(SHORT_MAX) > 0) {
                throw new GraphQLException("Int literal is too big or too small for a short, would cause overflow");
            }
            return value.shortValue();
        }
    });
    public static GraphQLScalarType GraphQLChar = new GraphQLScalarType("Char", "Built-in Char as Character", new Coercing(){

        @Override
        public Character serialize(Object input) {
            if (input instanceof String) {
                return ((String)input).length() != 1 ? null : Character.valueOf(((String)input).charAt(0));
            }
            if (input instanceof Character) {
                return (Character)input;
            }
            return null;
        }

        @Override
        public Character parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Character parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            String value = ((StringValue)input).getValue();
            if (value == null || value.length() != 1) {
                return null;
            }
            return Character.valueOf(value.charAt(0));
        }
    });
}

