/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.ShouldNotHappenException;
import graphql.language.AbstractNode;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.IntValue;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.SourceLocation;
import graphql.language.StringValue;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.parser.antlr.GraphqlBaseVisitor;
import graphql.parser.antlr.GraphqlParser;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import org.antlr.v4.runtime.ParserRuleContext;

public class GraphqlAntlrToLanguage
extends GraphqlBaseVisitor<Void> {
    Document result;
    private Deque<ContextEntry> contextStack = new ArrayDeque<ContextEntry>();

    private void addContextProperty(ContextProperty contextProperty, Object value) {
        switch (contextProperty) {
            case SelectionSet: {
                this.newSelectionSet((SelectionSet)value);
                break;
            }
            case Field: {
                this.newField((Field)value);
            }
        }
        this.contextStack.addFirst(new ContextEntry(contextProperty, value));
    }

    private void popContext() {
        this.contextStack.removeFirst();
    }

    private Object getFromContextStack(ContextProperty contextProperty) {
        return this.getFromContextStack(contextProperty, false);
    }

    private Object getFromContextStack(ContextProperty contextProperty, boolean required) {
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.contextProperty != contextProperty) continue;
            return contextEntry.value;
        }
        if (required) {
            throw new RuntimeException("not found" + (Object)((Object)contextProperty));
        }
        return null;
    }

    private void newSelectionSet(SelectionSet selectionSet) {
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.contextProperty == ContextProperty.Field) {
                ((Field)contextEntry.value).setSelectionSet(selectionSet);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.OperationDefinition) {
                ((OperationDefinition)contextEntry.value).setSelectionSet(selectionSet);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.FragmentDefinition) {
                ((FragmentDefinition)contextEntry.value).setSelectionSet(selectionSet);
                break;
            }
            if (contextEntry.contextProperty != ContextProperty.InlineFragment) continue;
            ((InlineFragment)contextEntry.value).setSelectionSet(selectionSet);
            break;
        }
    }

    private void newField(Field field) {
        ((SelectionSet)this.getFromContextStack(ContextProperty.SelectionSet)).getSelections().add(field);
    }

    @Override
    public Void visitDocument(GraphqlParser.DocumentContext ctx) {
        this.result = new Document();
        this.newNode(this.result, ctx);
        return (Void)super.visitDocument(ctx);
    }

    @Override
    public Void visitOperationDefinition(GraphqlParser.OperationDefinitionContext ctx) {
        OperationDefinition operationDefinition = new OperationDefinition();
        this.newNode(operationDefinition, ctx);
        this.newNode(operationDefinition, ctx);
        if (ctx.operationType() == null) {
            operationDefinition.setOperation(OperationDefinition.Operation.QUERY);
        } else {
            operationDefinition.setOperation(this.parseOperation(ctx.operationType()));
        }
        if (ctx.NAME() != null) {
            operationDefinition.setName(ctx.NAME().getText());
        }
        this.result.getDefinitions().add(operationDefinition);
        this.addContextProperty(ContextProperty.OperationDefinition, operationDefinition);
        super.visitOperationDefinition(ctx);
        this.popContext();
        return null;
    }

    private OperationDefinition.Operation parseOperation(GraphqlParser.OperationTypeContext operationTypeContext) {
        if (operationTypeContext.getText().equals("query")) {
            return OperationDefinition.Operation.QUERY;
        }
        if (operationTypeContext.getText().equals("mutation")) {
            return OperationDefinition.Operation.MUTATION;
        }
        throw new RuntimeException();
    }

    @Override
    public Void visitFragmentSpread(GraphqlParser.FragmentSpreadContext ctx) {
        FragmentSpread fragmentSpread = new FragmentSpread(ctx.fragmentName().getText());
        this.newNode(fragmentSpread, ctx);
        ((SelectionSet)this.getFromContextStack(ContextProperty.SelectionSet)).getSelections().add(fragmentSpread);
        this.addContextProperty(ContextProperty.FragmentSpread, fragmentSpread);
        super.visitFragmentSpread(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitVariableDefinition(GraphqlParser.VariableDefinitionContext ctx) {
        VariableDefinition variableDefinition = new VariableDefinition();
        this.newNode(variableDefinition, ctx);
        variableDefinition.setName(ctx.variable().NAME().getText());
        if (ctx.defaultValue() != null) {
            Value value = this.getValue(ctx.defaultValue().value());
            variableDefinition.setDefaultValue(value);
        }
        OperationDefinition operationDefinition = (OperationDefinition)this.getFromContextStack(ContextProperty.OperationDefinition);
        operationDefinition.getVariableDefinitions().add(variableDefinition);
        this.addContextProperty(ContextProperty.VariableDefinition, variableDefinition);
        super.visitVariableDefinition(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitFragmentDefinition(GraphqlParser.FragmentDefinitionContext ctx) {
        FragmentDefinition fragmentDefinition = new FragmentDefinition();
        this.newNode(fragmentDefinition, ctx);
        fragmentDefinition.setName(ctx.fragmentName().getText());
        fragmentDefinition.setTypeCondition(new TypeName(ctx.typeCondition().getText()));
        this.addContextProperty(ContextProperty.FragmentDefinition, fragmentDefinition);
        this.result.getDefinitions().add(fragmentDefinition);
        super.visitFragmentDefinition(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitSelectionSet(GraphqlParser.SelectionSetContext ctx) {
        SelectionSet newSelectionSet = new SelectionSet();
        this.newNode(newSelectionSet, ctx);
        this.addContextProperty(ContextProperty.SelectionSet, newSelectionSet);
        super.visitSelectionSet(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitField(GraphqlParser.FieldContext ctx) {
        Field newField = new Field();
        this.newNode(newField, ctx);
        newField.setName(ctx.NAME().getText());
        if (ctx.alias() != null) {
            newField.setAlias(ctx.alias().NAME().getText());
        }
        this.addContextProperty(ContextProperty.Field, newField);
        super.visitField(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitTypeName(GraphqlParser.TypeNameContext ctx) {
        TypeName typeName = new TypeName(ctx.NAME().getText());
        this.newNode(typeName, ctx);
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.value instanceof ListType) {
                ((ListType)contextEntry.value).setType(typeName);
                break;
            }
            if (contextEntry.value instanceof NonNullType) {
                ((NonNullType)contextEntry.value).setType(typeName);
                break;
            }
            if (!(contextEntry.value instanceof VariableDefinition)) continue;
            ((VariableDefinition)contextEntry.value).setType(typeName);
            break;
        }
        return (Void)super.visitTypeName(ctx);
    }

    @Override
    public Void visitNonNullType(GraphqlParser.NonNullTypeContext ctx) {
        NonNullType nonNullType = new NonNullType();
        this.newNode(nonNullType, ctx);
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.value instanceof ListType) {
                ((ListType)contextEntry.value).setType(nonNullType);
                break;
            }
            if (!(contextEntry.value instanceof VariableDefinition)) continue;
            ((VariableDefinition)contextEntry.value).setType(nonNullType);
            break;
        }
        this.addContextProperty(ContextProperty.NonNullType, nonNullType);
        super.visitNonNullType(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitListType(GraphqlParser.ListTypeContext ctx) {
        ListType listType = new ListType();
        this.newNode(listType, ctx);
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.value instanceof ListType) {
                ((ListType)contextEntry.value).setType(listType);
                break;
            }
            if (contextEntry.value instanceof NonNullType) {
                ((NonNullType)contextEntry.value).setType(listType);
                break;
            }
            if (!(contextEntry.value instanceof VariableDefinition)) continue;
            ((VariableDefinition)contextEntry.value).setType(listType);
            break;
        }
        this.addContextProperty(ContextProperty.ListType, listType);
        super.visitListType(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitArgument(GraphqlParser.ArgumentContext ctx) {
        Argument argument = new Argument(ctx.NAME().getText(), this.getValue(ctx.valueWithVariable()));
        this.newNode(argument, ctx);
        if (this.getFromContextStack(ContextProperty.Directive, false) != null) {
            ((Directive)this.getFromContextStack(ContextProperty.Directive)).getArguments().add(argument);
        } else {
            Field field = (Field)this.getFromContextStack(ContextProperty.Field);
            field.getArguments().add(argument);
        }
        return (Void)super.visitArgument(ctx);
    }

    @Override
    public Void visitInlineFragment(GraphqlParser.InlineFragmentContext ctx) {
        InlineFragment inlineFragment = new InlineFragment(new TypeName(ctx.typeCondition().getText()));
        this.newNode(inlineFragment, ctx);
        ((SelectionSet)this.getFromContextStack(ContextProperty.SelectionSet)).getSelections().add(inlineFragment);
        this.addContextProperty(ContextProperty.InlineFragment, inlineFragment);
        super.visitInlineFragment(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitDirective(GraphqlParser.DirectiveContext ctx) {
        Directive directive = new Directive(ctx.NAME().getText());
        this.newNode(directive, ctx);
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.contextProperty == ContextProperty.Field) {
                ((Field)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.FragmentDefinition) {
                ((FragmentDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.FragmentSpread) {
                ((FragmentSpread)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.InlineFragment) {
                ((InlineFragment)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty != ContextProperty.OperationDefinition) continue;
            ((OperationDefinition)contextEntry.value).getDirectives().add(directive);
            break;
        }
        this.addContextProperty(ContextProperty.Directive, directive);
        super.visitDirective(ctx);
        this.popContext();
        return null;
    }

    private Value getValue(GraphqlParser.ValueWithVariableContext ctx) {
        if (ctx.IntValue() != null) {
            IntValue intValue = new IntValue(new BigInteger(ctx.IntValue().getText()));
            this.newNode(intValue, ctx);
            return intValue;
        }
        if (ctx.FloatValue() != null) {
            FloatValue floatValue = new FloatValue(new BigDecimal(ctx.FloatValue().getText()));
            this.newNode(floatValue, ctx);
            return floatValue;
        }
        if (ctx.BooleanValue() != null) {
            BooleanValue booleanValue = new BooleanValue(Boolean.parseBoolean(ctx.BooleanValue().getText()));
            this.newNode(booleanValue, ctx);
            return booleanValue;
        }
        if (ctx.StringValue() != null) {
            StringValue stringValue = new StringValue(this.parseString(ctx.StringValue().getText()));
            this.newNode(stringValue, ctx);
            return stringValue;
        }
        if (ctx.enumValue() != null) {
            EnumValue enumValue = new EnumValue(ctx.enumValue().getText());
            this.newNode(enumValue, ctx);
            return enumValue;
        }
        if (ctx.arrayValueWithVariable() != null) {
            ArrayValue arrayValue = new ArrayValue();
            this.newNode(arrayValue, ctx);
            for (GraphqlParser.ValueWithVariableContext valueWithVariableContext : ctx.arrayValueWithVariable().valueWithVariable()) {
                arrayValue.getValues().add(this.getValue(valueWithVariableContext));
            }
            return arrayValue;
        }
        if (ctx.objectValueWithVariable() != null) {
            ObjectValue objectValue = new ObjectValue();
            this.newNode(objectValue, ctx);
            for (GraphqlParser.ObjectFieldWithVariableContext objectFieldWithVariableContext : ctx.objectValueWithVariable().objectFieldWithVariable()) {
                ObjectField objectField = new ObjectField(objectFieldWithVariableContext.NAME().getText(), this.getValue(objectFieldWithVariableContext.valueWithVariable()));
                objectValue.getObjectFields().add(objectField);
            }
            return objectValue;
        }
        if (ctx.variable() != null) {
            VariableReference variableReference = new VariableReference(ctx.variable().NAME().getText());
            this.newNode(variableReference, ctx);
            return variableReference;
        }
        throw new ShouldNotHappenException();
    }

    private Value getValue(GraphqlParser.ValueContext ctx) {
        if (ctx.IntValue() != null) {
            IntValue intValue = new IntValue(new BigInteger(ctx.IntValue().getText()));
            this.newNode(intValue, ctx);
            return intValue;
        }
        if (ctx.FloatValue() != null) {
            FloatValue floatValue = new FloatValue(new BigDecimal(ctx.FloatValue().getText()));
            this.newNode(floatValue, ctx);
            return floatValue;
        }
        if (ctx.BooleanValue() != null) {
            BooleanValue booleanValue = new BooleanValue(Boolean.parseBoolean(ctx.BooleanValue().getText()));
            this.newNode(booleanValue, ctx);
            return booleanValue;
        }
        if (ctx.StringValue() != null) {
            StringValue stringValue = new StringValue(this.parseString(ctx.StringValue().getText()));
            this.newNode(stringValue, ctx);
            return stringValue;
        }
        if (ctx.enumValue() != null) {
            EnumValue enumValue = new EnumValue(ctx.enumValue().getText());
            this.newNode(enumValue, ctx);
            return enumValue;
        }
        if (ctx.arrayValue() != null) {
            ArrayValue arrayValue = new ArrayValue();
            this.newNode(arrayValue, ctx);
            for (GraphqlParser.ValueContext valueWithVariableContext : ctx.arrayValue().value()) {
                arrayValue.getValues().add(this.getValue(valueWithVariableContext));
            }
            return arrayValue;
        }
        if (ctx.objectValue() != null) {
            ObjectValue objectValue = new ObjectValue();
            this.newNode(objectValue, ctx);
            for (GraphqlParser.ObjectFieldContext objectFieldContext : ctx.objectValue().objectField()) {
                ObjectField objectField = new ObjectField(objectFieldContext.NAME().getText(), this.getValue(objectFieldContext.value()));
                objectValue.getObjectFields().add(objectField);
            }
            return objectValue;
        }
        throw new ShouldNotHappenException();
    }

    private String parseString(String string) {
        StringWriter writer = new StringWriter(string.length() - 2);
        int end = string.length() - 1;
        block11: for (int i = 1; i < end; ++i) {
            char c = string.charAt(i);
            if (c != '\\') {
                writer.write(c);
                continue;
            }
            char escaped = string.charAt(i + 1);
            ++i;
            switch (escaped) {
                case '\"': {
                    writer.write(34);
                    continue block11;
                }
                case '/': {
                    writer.write(47);
                    continue block11;
                }
                case '\\': {
                    writer.write(92);
                    continue block11;
                }
                case 'b': {
                    writer.write(8);
                    continue block11;
                }
                case 'f': {
                    writer.write(12);
                    continue block11;
                }
                case 'n': {
                    writer.write(10);
                    continue block11;
                }
                case 'r': {
                    writer.write(13);
                    continue block11;
                }
                case 't': {
                    writer.write(9);
                    continue block11;
                }
                case 'u': {
                    int codepoint = Integer.parseInt(string.substring(i + 1, i + 5), 16);
                    i += 4;
                    writer.write(codepoint);
                    continue block11;
                }
                default: {
                    throw new ShouldNotHappenException();
                }
            }
        }
        return writer.toString();
    }

    private void newNode(AbstractNode abstractNode, ParserRuleContext parserRuleContext) {
        abstractNode.setSourceLocation(this.getSourceLocation(parserRuleContext));
    }

    private SourceLocation getSourceLocation(ParserRuleContext parserRuleContext) {
        return new SourceLocation(parserRuleContext.getStart().getLine(), parserRuleContext.getStart().getCharPositionInLine() + 1);
    }

    static class ContextEntry {
        ContextProperty contextProperty;
        Object value;

        public ContextEntry(ContextProperty contextProperty, Object value) {
            this.contextProperty = contextProperty;
            this.value = value;
        }
    }

    private static enum ContextProperty {
        OperationDefinition,
        FragmentDefinition,
        Field,
        InlineFragment,
        FragmentSpread,
        SelectionSet,
        VariableDefinition,
        ListType,
        NonNullType,
        Directive;

    }
}

