/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.commons.fileupload.FileItem;

public class GraphQLContext {
    @NonNull
    private Optional<HttpServletRequest> request;
    @NonNull
    private Optional<HttpServletResponse> response;
    private Optional<Subject> subject = Optional.empty();
    private Optional<Map<String, List<FileItem>>> files = Optional.empty();

    @ConstructorProperties(value={"request", "response"})
    public GraphQLContext(@NonNull Optional<HttpServletRequest> request, @NonNull Optional<HttpServletResponse> response) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (response == null) {
            throw new NullPointerException("response");
        }
        this.request = request;
        this.response = response;
    }

    @NonNull
    public Optional<HttpServletRequest> getRequest() {
        return this.request;
    }

    public void setRequest(@NonNull Optional<HttpServletRequest> request) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        this.request = request;
    }

    @NonNull
    public Optional<HttpServletResponse> getResponse() {
        return this.response;
    }

    public void setResponse(@NonNull Optional<HttpServletResponse> response) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        this.response = response;
    }

    public Optional<Subject> getSubject() {
        return this.subject;
    }

    public void setSubject(Optional<Subject> subject) {
        this.subject = subject;
    }

    public Optional<Map<String, List<FileItem>>> getFiles() {
        return this.files;
    }

    public void setFiles(Optional<Map<String, List<FileItem>>> files) {
        this.files = files;
    }
}

