/*
 * Decompiled with CFR 0.152.
 */
package graphql.spring.web.reactive.components;

import graphql.ExecutionResult;
import graphql.Internal;
import graphql.spring.web.reactive.ExecutionResultHandler;
import graphql.spring.web.reactive.GraphQLInvocation;
import graphql.spring.web.reactive.GraphQLInvocationData;
import graphql.spring.web.reactive.JsonSerializer;
import graphql.spring.web.reactive.components.GraphQLRequestBody;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestController
@Internal
public class GraphQLController {
    static String APPLICATION_GRAPHQL_VALUE = "application/graphql";
    static MediaType APPLICATION_GRAPHQL = MediaType.parseMediaType((String)APPLICATION_GRAPHQL_VALUE);
    @Autowired
    GraphQLInvocation graphQLInvocation;
    @Autowired
    ExecutionResultHandler executionResultHandler;
    @Autowired
    JsonSerializer jsonSerializer;

    @RequestMapping(value={"${graphql.url:graphql}"}, method={RequestMethod.POST}, produces={"application/json"})
    public Object graphqlPOST(@RequestHeader(value="Content-Type", required=false) String contentType, @RequestParam(value="query", required=false) String query, @RequestParam(value="operationName", required=false) String operationName, @RequestParam(value="variables", required=false) String variablesJson, @RequestBody(required=false) String body, ServerWebExchange serverWebExchange) {
        MediaType mediaType = null;
        if (!StringUtils.isEmpty((Object)contentType)) {
            try {
                mediaType = MediaType.parseMediaType((String)contentType);
            }
            catch (InvalidMediaTypeException invalidMediaTypeException) {
                // empty catch block
            }
        }
        if (body == null) {
            body = "";
        }
        if (MediaType.APPLICATION_JSON.equalsTypeAndSubtype((MimeType)mediaType)) {
            GraphQLRequestBody request = this.jsonSerializer.deserialize(body, GraphQLRequestBody.class);
            if (request.getQuery() == null) {
                request.setQuery("");
            }
            return this.executeRequest(request.getQuery(), request.getOperationName(), request.getVariables(), serverWebExchange);
        }
        if (query != null) {
            return this.executeRequest(query, operationName, this.convertVariablesJson(variablesJson), serverWebExchange);
        }
        if (APPLICATION_GRAPHQL.equalsTypeAndSubtype((MimeType)mediaType)) {
            return this.executeRequest(body, null, null, serverWebExchange);
        }
        throw new ResponseStatusException(HttpStatus.UNPROCESSABLE_ENTITY, "Could not process GraphQL request");
    }

    @RequestMapping(value={"${graphql.url:graphql}"}, method={RequestMethod.GET}, produces={"application/json"})
    public Object graphqlGET(@RequestParam(value="query") String query, @RequestParam(value="operationName", required=false) String operationName, @RequestParam(value="variables", required=false) String variablesJson, ServerWebExchange serverWebExchange) {
        return this.executeRequest(query, operationName, this.convertVariablesJson(variablesJson), serverWebExchange);
    }

    private Map<String, Object> convertVariablesJson(String jsonMap) {
        if (jsonMap == null) {
            return Collections.emptyMap();
        }
        return this.jsonSerializer.deserialize(jsonMap, Map.class);
    }

    private Object executeRequest(String query, String operationName, Map<String, Object> variables, ServerWebExchange serverWebExchange) {
        GraphQLInvocationData invocationData = new GraphQLInvocationData(query, operationName, variables);
        Mono<ExecutionResult> executionResult = this.graphQLInvocation.invoke(invocationData, serverWebExchange);
        return this.executionResultHandler.handleExecutionResult(executionResult, serverWebExchange.getResponse());
    }
}

