/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.api;

import com.groupdocs.sdk.common.ApiException;
import com.groupdocs.sdk.common.ApiInvoker;
import com.groupdocs.sdk.model.DocumentAccessInfoResponse;
import com.groupdocs.sdk.model.DocumentUserStatusResponse;
import com.groupdocs.sdk.model.DocumentViewsResponse;
import com.groupdocs.sdk.model.GetDocumentForeignTypesResponse;
import com.groupdocs.sdk.model.GetDocumentInfoResponse;
import com.groupdocs.sdk.model.GetEditLockResponse;
import com.groupdocs.sdk.model.GetImageUrlsResponse;
import com.groupdocs.sdk.model.RemoveEditLockResponse;
import com.groupdocs.sdk.model.SharedDocumentsResponse;
import com.groupdocs.sdk.model.SharedUsersResponse;
import com.groupdocs.sdk.model.TemplateFieldsResponse;
import com.groupdocs.sdk.model.ViewDocumentResponse;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class DocApi {
    String basePath = "https://api.groupdocs.com/v2.0";
    ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ViewDocumentResponse ViewDocument(String userId, String fileId, String pageNumber, String pageCount, String width, String quality, String usePdf) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/thumbnails?page_number={pageNumber}&amp;page_count={pageCount}&amp;width={width}&amp;quality={quality}&amp;use_pdf={usePdf}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{pageNumber}", String.valueOf(pageNumber)).replace("{pageCount}", String.valueOf(pageCount)).replace("{width}", String.valueOf(width)).replace("{quality}", String.valueOf(quality)).replace("{usePdf}", String.valueOf(usePdf));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null || pageNumber == null || pageCount == null || width == null || quality == null || usePdf == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, null, headerParams);
            if (response != null) {
                return (ViewDocumentResponse)ApiInvoker.deserialize(response, "", ViewDocumentResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DocumentViewsResponse GetDocumentViews(String userId, String startIndex, String pageSize) throws ApiException {
        String resourcePath = "/doc/{userId}/views?page_index={startIndex}&amp;page_size={pageSize}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{startIndex}", String.valueOf(startIndex)).replace("{pageSize}", String.valueOf(pageSize));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || startIndex == null || pageSize == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (DocumentViewsResponse)ApiInvoker.deserialize(response, "", DocumentViewsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SharedUsersResponse ShareDocument(String userId, String fileId, List<String> body) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/sharers".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams);
            if (response != null) {
                return (SharedUsersResponse)ApiInvoker.deserialize(response, "", SharedUsersResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SharedUsersResponse UnshareDocument(String userId, String fileId) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/sharers".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams);
            if (response != null) {
                return (SharedUsersResponse)ApiInvoker.deserialize(response, "", SharedUsersResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SharedUsersResponse GetFolderSharers(String userId, String folderId) throws ApiException {
        String resourcePath = "/doc/{userId}/folders/{folderId}/sharers".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{folderId}", String.valueOf(folderId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || folderId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (SharedUsersResponse)ApiInvoker.deserialize(response, "", SharedUsersResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SharedUsersResponse ShareFolder(String userId, String folderId, List<String> body) throws ApiException {
        String resourcePath = "/doc/{userId}/folders/{folderId}/sharers".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{folderId}", String.valueOf(folderId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || folderId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams);
            if (response != null) {
                return (SharedUsersResponse)ApiInvoker.deserialize(response, "", SharedUsersResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SharedUsersResponse UnshareFolder(String userId, String folderId) throws ApiException {
        String resourcePath = "/doc/{userId}/folders/{folderId}/sharers".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{folderId}", String.valueOf(folderId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || folderId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams);
            if (response != null) {
                return (SharedUsersResponse)ApiInvoker.deserialize(response, "", SharedUsersResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DocumentAccessInfoResponse SetDocumentAccessMode(String userId, String fileId, String mode) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/accessinfo?mode={mode}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{mode}", String.valueOf(mode));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null || mode == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, null, headerParams);
            if (response != null) {
                return (DocumentAccessInfoResponse)ApiInvoker.deserialize(response, "", DocumentAccessInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DocumentAccessInfoResponse GetDocumentAccessInfo(String userId, String fileId) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/accessinfo".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (DocumentAccessInfoResponse)ApiInvoker.deserialize(response, "", DocumentAccessInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetDocumentInfoResponse GetDocumentMetadata(String userId, String fileId) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/metadata".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (GetDocumentInfoResponse)ApiInvoker.deserialize(response, "", GetDocumentInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetDocumentInfoResponse GetDocumentMetadataByPath(String userId, String path) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{*path}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{path}", String.valueOf(path));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || path == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (GetDocumentInfoResponse)ApiInvoker.deserialize(response, "", GetDocumentInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DocumentUserStatusResponse SetDocumentUserStatus(String userId, String fileId, String status) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/sharer".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{status}", String.valueOf(status));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null || status == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, null, headerParams);
            if (response != null) {
                return (DocumentUserStatusResponse)ApiInvoker.deserialize(response, "", DocumentUserStatusResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SharedDocumentsResponse GetSharedDocuments(String userId, String sharesTypes, String pageIndex, String pageSize, String orderBy, Boolean orderAsc) throws ApiException {
        String resourcePath = "/doc/{userId}/shares/{sharesTypes}?page_index={pageIndex}&amp;page_size={pageSize}&amp;order_by={orderBy}&amp;order_asc={orderAsc}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{sharesTypes}", String.valueOf(sharesTypes)).replace("{pageIndex}", String.valueOf(pageIndex)).replace("{pageSize}", String.valueOf(pageSize)).replace("{orderBy}", String.valueOf(orderBy)).replace("{orderAsc}", String.valueOf(orderAsc));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || sharesTypes == null || pageIndex == null || pageSize == null || orderBy == null || orderAsc == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (SharedDocumentsResponse)ApiInvoker.deserialize(response, "", SharedDocumentsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public TemplateFieldsResponse GetTemplateFields(String userId, String fileId, Boolean includeGeometry) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/fields?include_geometry={includeGeometry}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{includeGeometry}", String.valueOf(includeGeometry));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null || includeGeometry == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (TemplateFieldsResponse)ApiInvoker.deserialize(response, "", TemplateFieldsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetDocumentForeignTypesResponse GetDocumentFormats(String userId, String fileId) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/formats".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (GetDocumentForeignTypesResponse)ApiInvoker.deserialize(response, "", GetDocumentForeignTypesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public InputStream GetDocumentPageImage(String userId, String fileId, Integer pageNumber, String dimension, Integer quality, Boolean usePdf, Boolean expiresOn) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/pages/{pageNumber}/images/{dimension}?quality={quality}&amp;use_pdf={usePdf}&amp;expires={expiresOn}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{pageNumber}", String.valueOf(pageNumber)).replace("{dimension}", String.valueOf(dimension)).replace("{quality}", String.valueOf(quality)).replace("{usePdf}", String.valueOf(usePdf)).replace("{expiresOn}", String.valueOf(expiresOn));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null || pageNumber == null || dimension == null || quality == null || usePdf == null || expiresOn == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (InputStream)ApiInvoker.deserialize(response, "", InputStream.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetImageUrlsResponse GetDocumentPagesImageUrls(String userId, String fileId, Integer firstPage, Integer pageCount, String dimension, Integer quality, Boolean usePdf, String token) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/pages/images/{dimension}/urls?first_page={firstPage}&amp;page_count={pageCount}&amp;quality={quality}&amp;use_pdf={usePdf}&amp;token={token}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{firstPage}", String.valueOf(firstPage)).replace("{pageCount}", String.valueOf(pageCount)).replace("{dimension}", String.valueOf(dimension)).replace("{quality}", String.valueOf(quality)).replace("{usePdf}", String.valueOf(usePdf)).replace("{token}", String.valueOf(token));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null || firstPage == null || pageCount == null || dimension == null || quality == null || usePdf == null || token == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (GetImageUrlsResponse)ApiInvoker.deserialize(response, "", GetImageUrlsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetEditLockResponse GetEditLock(String userId, String fileId) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/editlock".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (GetEditLockResponse)ApiInvoker.deserialize(response, "", GetEditLockResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public RemoveEditLockResponse RemoveEditLock(String userId, String fileId) throws ApiException {
        String resourcePath = "/doc/{userId}/files/{fileId}/editlock".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams);
            if (response != null) {
                return (RemoveEditLockResponse)ApiInvoker.deserialize(response, "", RemoveEditLockResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }
}

