/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.samples;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.groupdocs.sdk.api.AntApi;
import com.groupdocs.sdk.api.StorageApi;
import com.groupdocs.sdk.common.ApiInvoker;
import com.groupdocs.sdk.common.GroupDocsRequestSigner;
import com.groupdocs.sdk.model.AddReplyResponse;
import com.groupdocs.sdk.model.AnnotationInfo;
import com.groupdocs.sdk.model.AnnotationReplyInfo;
import com.groupdocs.sdk.model.CreateAnnotationResponse;
import com.groupdocs.sdk.model.EditReplyResponse;
import com.groupdocs.sdk.model.ListAnnotationsResponse;
import com.groupdocs.sdk.model.ListRepliesResponse;
import com.groupdocs.sdk.model.Rectangle;
import com.groupdocs.sdk.model.ReviewerInfo;
import com.groupdocs.sdk.model.SetCollaboratorsResponse;
import com.groupdocs.sdk.model.SetDocumentRightsResponse;
import com.groupdocs.sdk.model.UploadResponse;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class Examples {
    static String privateKey = "8d8a7d642a807a31c2741c101a60cef2";
    static String userId = "2721ad21bcf0d71e";
    static String fileId = "a532d40b1d0ed07f3b16050fb2ca83b218e3cc1b44b8a53a8aaea38e5c8c9985";
    static String apiServer = "https://dev-api.groupdocs.com/v2.0";
    public static ObjectMapper mapper = new ObjectMapper();
    private static final AntApi api = new AntApi();

    public static void main(String[] args) throws Exception {
        Examples.setReviewerRights();
    }

    private static void uploadFile() throws Exception {
        InputStream stream = Examples.class.getClassLoader().getResourceAsStream("com/groupdocs/sdk/samples/test.docx");
        StorageApi api = new StorageApi();
        api.setBasePath(apiServer);
        UploadResponse response = api.Upload(userId, "test.docx", "alpha123 ; , / ? : @ & = + $", stream);
        System.out.println(mapper.writeValueAsString((Object)response));
    }

    private static void listAnnotations() throws Exception {
        ListAnnotationsResponse response = api.ListAnnotations(userId, fileId);
        System.out.println(mapper.writeValueAsString((Object)response));
    }

    private static void listAnnotationReplies() throws Exception {
        String annotationId = "8f8cc25250066a77";
        ListRepliesResponse response = api.ListAnnotationReplies(userId, annotationId, 10L);
        System.out.println(mapper.writeValueAsString((Object)response));
    }

    private static void getFile() throws Exception {
        String response = new StorageApi().GetFile(userId, fileId);
    }

    private static void createAnnotation() throws Exception {
        AnnotationInfo annotation = new AnnotationInfo();
        Rectangle box = new Rectangle();
        box.setHeight(100.0);
        box.setWidth(100.0);
        box.setX(100.0);
        box.setY(100.0);
        AnnotationReplyInfo reply = new AnnotationReplyInfo();
        reply.setText("first message");
        AnnotationReplyInfo reply2 = new AnnotationReplyInfo();
        reply2.setText("second message");
        annotation.setType("Text");
        annotation.setBox(box);
        annotation.setReplies(Arrays.asList(reply, reply2));
        CreateAnnotationResponse response = api.CreateAnnotation(userId, fileId, annotation);
        System.out.println(mapper.writeValueAsString((Object)response));
    }

    private static void createAnnotationReply() throws Exception {
        String msg = "test message from java client library";
        String parentReplyGuid = "6a215585";
        String annotationId = "8f8cc25250066a77";
        AnnotationReplyInfo reply = new AnnotationReplyInfo();
        reply.setText(msg);
        reply.setParentReplyGuid(parentReplyGuid);
        AddReplyResponse response = api.CreateAnnotationReply(userId, annotationId, reply);
        System.out.println(mapper.writeValueAsString((Object)response));
    }

    private static void editAnnotationReply() throws Exception {
        String msg = "updated message from java client library";
        String replyGuid = "6a215585";
        EditReplyResponse response = api.EditAnnotationReply(userId, replyGuid, msg);
        System.out.println(mapper.writeValueAsString((Object)response));
    }

    private static void setAnnotationCollaborators() throws Exception {
        String version = "1";
        List<String> collaborators = Arrays.asList("test1@gmail.com", "test2@gmail.com");
        SetCollaboratorsResponse response = api.SetAnnotationCollaborators(userId, fileId, version, collaborators);
        System.out.println(mapper.writeValueAsString((Object)response));
    }

    private static void setReviewerRights() throws Exception {
        ReviewerInfo rev1 = new ReviewerInfo();
        rev1.setAccess_rights(1);
        rev1.setId(1232.0);
        ReviewerInfo rev2 = new ReviewerInfo();
        rev2.setAccess_rights(0);
        rev2.setId(1233.0);
        List<ReviewerInfo> collaborators = Arrays.asList(rev1, rev2);
        SetDocumentRightsResponse response = api.SetReviewerRights(userId, fileId, collaborators);
        System.out.println(mapper.writeValueAsString((Object)response));
    }

    static {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        api.setBasePath(apiServer);
        ApiInvoker.getInstance().setRequestSigner(new GroupDocsRequestSigner(privateKey));
    }
}

