/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.api;

import com.groupdocs.sdk.common.ApiException;
import com.groupdocs.sdk.common.ApiInvoker;
import com.groupdocs.sdk.common.FileStream;
import com.groupdocs.sdk.model.ChangeInfo;
import com.groupdocs.sdk.model.ChangesResponse;
import com.groupdocs.sdk.model.CompareResponse;
import com.groupdocs.sdk.model.DocumentDetailsResponse;
import java.util.HashMap;
import java.util.List;

public class ComparisonApi {
    String basePath = "https://api.groupdocs.com/v2.0";
    ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public FileStream DownloadResult(String userId, String resultFileId, String format) throws ApiException {
        if (userId == null || resultFileId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/comparison/{userId}/comparison/download?resultFileId={resultFileId}&format={format}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(resultFileId))) {
            queryParams.put("resultFileId", String.valueOf(resultFileId));
        }
        if (!"null".equals(String.valueOf(format))) {
            queryParams.put("format", String.valueOf(format));
        }
        try {
            return this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, FileStream.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public CompareResponse Compare(String userId, String sourceFileId, String targetFileId, String callbackUrl) throws ApiException {
        if (userId == null || sourceFileId == null || targetFileId == null || callbackUrl == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/comparison/{userId}/comparison/compare?source={sourceFileId}&target={targetFileId}&callback={callbackUrl}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(sourceFileId))) {
            queryParams.put("source", String.valueOf(sourceFileId));
        }
        if (!"null".equals(String.valueOf(targetFileId))) {
            queryParams.put("target", String.valueOf(targetFileId));
        }
        if (!"null".equals(String.valueOf(callbackUrl))) {
            queryParams.put("callback", String.valueOf(callbackUrl));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (CompareResponse)ApiInvoker.deserialize(response, "", CompareResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ChangesResponse GetChanges(String userId, String resultFileId) throws ApiException {
        if (userId == null || resultFileId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/comparison/{userId}/comparison/changes?resultFileId={resultFileId}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(resultFileId))) {
            queryParams.put("resultFileId", String.valueOf(resultFileId));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (ChangesResponse)ApiInvoker.deserialize(response, "", ChangesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ChangesResponse UpdateChanges(String userId, String resultFileId, List<ChangeInfo> body) throws ApiException {
        if (userId == null || resultFileId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/comparison/{userId}/comparison/changes?resultFileId={resultFileId}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(resultFileId))) {
            queryParams.put("resultFileId", String.valueOf(resultFileId));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (ChangesResponse)ApiInvoker.deserialize(response, "", ChangesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DocumentDetailsResponse GetDocumentDetails(String userId, String guid) throws ApiException {
        if (userId == null || guid == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/comparison/{userId}/comparison/document?guid={guid}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(guid))) {
            queryParams.put("guid", String.valueOf(guid));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (DocumentDetailsResponse)ApiInvoker.deserialize(response, "", DocumentDetailsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }
}

