/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.groupdocs.sdk.common.ApiException;
import com.groupdocs.sdk.common.FileStream;
import com.groupdocs.sdk.common.RequestSigner;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.multipart.file.DefaultMediaTypePredictor;
import com.wordnik.swagger.core.util.JsonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.sling.commons.mime.internal.MimeTypeServiceImpl;

public class ApiInvoker {
    private static ApiInvoker INSTANCE = new ApiInvoker();
    private Map<String, Client> hostMap = new HashMap<String, Client>();
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private static final String ENC = "UTF-8";
    private RequestSigner signer;
    public static MimeTypeServiceImpl mimeTypeService = new MimeTypeServiceImpl();

    public static ApiInvoker getInstance() {
        return INSTANCE;
    }

    public void setRequestSigner(RequestSigner signer) {
        this.signer = signer;
    }

    public void addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
    }

    public String escapeString(String str) {
        return ApiInvoker.encodeURIComponent(str);
    }

    public static String encodeURI(String uri) {
        return ApiInvoker.encodeURIComponent(uri).replace("%3B", ";").replace("%2C", ",").replace("%2F", "/").replace("%3F", "?").replace("%3A", ":").replace("%40", "@").replace("%26", "&").replace("%3D", "=").replace("%24", "$").replace("%25", "%").replace("%23", "#");
    }

    public static String encodeURIComponent(String str) {
        try {
            return URLEncoder.encode(str, ENC).replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static Object deserialize(String json, String containerType, Class cls) throws ApiException {
        try {
            if ("List".equals(containerType)) {
                CollectionType typeInfo = JsonUtil.getJsonMapper().getTypeFactory().constructCollectionType(List.class, cls);
                List response = (List)JsonUtil.getJsonMapper().readValue(json, (JavaType)typeInfo);
                return response;
            }
            if (String.class.equals((Object)cls)) {
                return json;
            }
            return JsonUtil.getJsonMapper().readValue(json, cls);
        }
        catch (IOException e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public static String serialize(Object obj) throws ApiException {
        try {
            if (obj != null) {
                ObjectMapper jsonMapper = JsonUtil.getJsonMapper();
                jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                return jsonMapper.writeValueAsString(obj);
            }
            return "";
        }
        catch (Exception e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public <T> T invokeAPI(String host, String path, String method, Map<String, String> queryParams, Object body, Map<String, String> headerParams, Class<T> returnType) throws ApiException {
        Object requestBody;
        MediaType contentType;
        Client client = this.getClient(host);
        StringBuilder b = new StringBuilder();
        for (String key : queryParams.keySet()) {
            String value = queryParams.get(key);
            if (value == null) continue;
            if (b.toString().length() == 0) {
                b.append("?");
            } else {
                b.append("&");
            }
            b.append(this.escapeString(key)).append("=").append(this.escapeString(value));
        }
        String querystring = b.toString();
        boolean isFileUpload = false;
        if (body == null) {
            contentType = MediaType.TEXT_HTML_TYPE;
        } else {
            contentType = MediaType.APPLICATION_JSON_TYPE;
            if (body instanceof FileStream) {
                isFileUpload = true;
                contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
        }
        String requestUri = ApiInvoker.encodeURI(this.signer.signUrl(host + path + querystring));
        WebResource.Builder builder = client.resource(requestUri).type(contentType);
        for (String key : headerParams.keySet()) {
            builder.header(key, (Object)headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder.header(key, (Object)this.defaultHeaderMap.get(key));
        }
        ClientResponse response = null;
        if ("GET".equals(method)) {
            response = (ClientResponse)builder.get(ClientResponse.class);
        } else if ("POST".equals(method)) {
            requestBody = isFileUpload ? ((FileStream)body).getInputStream() : this.signer.signContent(ApiInvoker.serialize(body), builder);
            response = (ClientResponse)builder.post(ClientResponse.class, requestBody);
        } else if ("PUT".equals(method)) {
            requestBody = isFileUpload ? ((FileStream)body).getInputStream() : this.signer.signContent(ApiInvoker.serialize(body), builder);
            response = (ClientResponse)builder.put(ClientResponse.class, requestBody);
        } else if ("DELETE".equals(method)) {
            response = (ClientResponse)builder.delete(ClientResponse.class, (Object)this.signer.signContent(ApiInvoker.serialize(body), builder));
        } else {
            throw new ApiException(500, "unknown method type " + method);
        }
        if (response.getClientResponseStatus() == ClientResponse.Status.OK || response.getClientResponseStatus() == ClientResponse.Status.CREATED || response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            Object toReturn = FileStream.class.equals(returnType) ? (response.getHeaders().containsKey((Object)"Transfer-Encoding") || response.getLength() > 0 ? new FileStream(requestUri, response) : null) : response.getEntity(String.class);
            return (T)toReturn;
        }
        String errMsg = (String)response.getEntity(String.class);
        try {
            HashMap props = (HashMap)JsonUtil.getJsonMapper().readValue(errMsg, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            if (props.containsKey("error_message")) {
                errMsg = (String)props.get("error_message");
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        throw new ApiException(response.getClientResponseStatus().getStatusCode(), errMsg);
    }

    public static String readAsDataURL(File file) throws IOException {
        String mimeType = mimeTypeService.getMimeType(file.getName());
        if (mimeType == null) {
            mimeType = new DefaultMediaTypePredictor().getMediaTypeFromFile(file).toString();
        }
        return ApiInvoker.readAsDataURL(file, mimeType);
    }

    public static String readAsDataURL(File file, String contentType) throws IOException {
        return ApiInvoker.readAsDataURL(new FileInputStream(file), contentType);
    }

    public static String readAsDataURL(InputStream is, String contentType) throws IOException {
        String base64file = IOUtils.toString((InputStream)new Base64InputStream(is, true, 0, null));
        return "data:" + contentType + ";base64," + base64file;
    }

    private Client getClient(String host) {
        if (!this.hostMap.containsKey(host)) {
            Client client = Client.create();
            client.addFilter((ClientFilter)new LoggingFilter());
            this.hostMap.put(host, client);
        }
        return this.hostMap.get(host);
    }

    static {
        try {
            mimeTypeService.registerMimeType(ApiInvoker.class.getResourceAsStream("/META-INF/core_mime.types"));
        }
        catch (IOException e) {
            System.err.println("Failed to initialize MimeTypeServiceImpl");
        }
    }
}

