/*
 * Decompiled with CFR 0.152.
 */
package com.hack23.cia.service.component.agent.impl.vdem;

import com.hack23.cia.model.internal.application.data.impl.VdemDataSources;
import com.hack23.cia.service.component.agent.impl.common.AbstractAgentWorkConsumerImpl;
import com.hack23.cia.service.external.vdem.api.VdemService;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="VdemApiAgentWorkConsumer")
public final class VdemApiAgentWorkConsumerImpl
extends AbstractAgentWorkConsumerImpl
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(VdemApiAgentWorkConsumerImpl.class);
    @Autowired
    private VdemService vdemService;

    public void onMessage(Message message) {
        ObjectMessage objectMessage = (ObjectMessage)message;
        try {
            VdemDataSources vdemDataSources = (VdemDataSources)objectMessage.getObject();
            LOGGER.info("Consumed message:{}", (Object)vdemDataSources);
            switch (vdemDataSources) {
                case QUESTIONS: {
                    this.vdemService.getQuestions();
                    break;
                }
                case QUESTION_COUNTRY_YEAR_DATA: {
                    this.vdemService.getCountryQuestionData();
                    break;
                }
            }
        }
        catch (JMSException jMSException) {
            LOGGER.warn("jms", (Throwable)jMSException);
        }
    }
}

