/*
 * Decompiled with CFR 0.152.
 */
package com.hack23.cia.service.component.agent.impl.command;

import com.hack23.cia.model.internal.application.data.impl.DataAgentWorkOrder;
import com.hack23.cia.model.internal.application.data.impl.RiksdagenDataSources;
import com.hack23.cia.model.internal.application.data.impl.ValDataSources;
import com.hack23.cia.model.internal.application.data.impl.VdemDataSources;
import com.hack23.cia.model.internal.application.data.impl.WorldBankDataSources;
import com.hack23.cia.service.component.agent.api.DataAgentApi;
import com.hack23.cia.service.component.agent.impl.common.ProducerMessageFactory;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.REQUIRED)
public final class DataAgentApiImpl
implements DataAgentApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataAgentApiImpl.class);
    @Autowired
    private JmsTemplate jmsTemplate;
    @Autowired
    @Qualifier(value="riksdagenApiAgentWorkQueue")
    private Destination riksdagenApiDestination;
    @Autowired
    @Qualifier(value="worldbankApiAgentWorkQueue")
    private Destination worldBankApiDestination;
    @Autowired
    @Qualifier(value="vdemApiAgentWorkQueue")
    private Destination vdemApiDestination;

    public void execute(DataAgentWorkOrder dataAgentWorkOrder) {
        try {
            this.sendMessage(dataAgentWorkOrder);
        }
        catch (JMSException jMSException) {
            LOGGER.error("Jms exception:", (Throwable)jMSException);
        }
    }

    public void sendMessage(DataAgentWorkOrder dataAgentWorkOrder) throws JMSException {
        switch (dataAgentWorkOrder.getTarget()) {
            case MODEL_EXTERNAL_RIKSDAGEN: {
                for (RiksdagenDataSources riksdagenDataSources : RiksdagenDataSources.values()) {
                    this.jmsTemplate.send(this.riksdagenApiDestination, (MessageCreator)new ProducerMessageFactory((Serializable)riksdagenDataSources));
                }
                break;
            }
            case MODEL_EXTERNAL_WORLDBANK: {
                for (WorldBankDataSources worldBankDataSources : WorldBankDataSources.values()) {
                    this.jmsTemplate.send(this.worldBankApiDestination, (MessageCreator)new ProducerMessageFactory((Serializable)worldBankDataSources));
                }
                break;
            }
            case MODEL_EXTERNAL_VAL: {
                for (ValDataSources valDataSources : ValDataSources.values()) {
                    this.jmsTemplate.send((MessageCreator)new ProducerMessageFactory((Serializable)valDataSources));
                }
                break;
            }
            case MODEL_EXTERNAL_VDEM: {
                for (VdemDataSources vdemDataSources : VdemDataSources.values()) {
                    this.jmsTemplate.send(this.vdemApiDestination, (MessageCreator)new ProducerMessageFactory((Serializable)vdemDataSources));
                }
                break;
            }
        }
    }
}

