/*
 * Decompiled with CFR 0.152.
 */
package com.hack23.cia.service.component.agent.impl.riksdagen;

import com.hack23.cia.model.external.riksdagen.dokumentlista.impl.DocumentElement;
import com.hack23.cia.model.external.riksdagen.dokumentlista.impl.DocumentType;
import com.hack23.cia.model.external.riksdagen.personlista.impl.PersonElement;
import com.hack23.cia.model.external.riksdagen.voteringlista.impl.BallotDocumentElement;
import com.hack23.cia.model.internal.application.data.impl.RiksdagenDataSources;
import com.hack23.cia.service.component.agent.impl.common.AbstractAgentWorkConsumerImpl;
import com.hack23.cia.service.component.agent.impl.riksdagen.RiksdagenImportService;
import com.hack23.cia.service.external.common.api.ProcessDataStrategy;
import com.hack23.cia.service.external.riksdagen.api.RiksdagenApi;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="RiksdagenApiAgentWorkConsumer")
public final class RiksdagenApiAgentWorkConsumerImpl
extends AbstractAgentWorkConsumerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(RiksdagenApiAgentWorkConsumerImpl.class);
    private static final String RIKSDAGEN_JAVA_SIMPLE_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    private RiksdagenImportService importService;
    @Autowired
    @Qualifier(value="com.hack23.cia.model.external.riksdagen.utskottsforslag.impl.CommitteeProposalComponentData")
    private Destination committeeProposalComponentDataWorkdestination;
    @Autowired
    @Qualifier(value="com.hack23.cia.model.external.riksdagen.documentcontent.impl.DocumentContentData")
    private Destination documentContentWorkdestination;
    @Autowired
    @Qualifier(value="com.hack23.cia.model.external.riksdagen.dokumentlista.impl.DocumentElement")
    private Destination documentElementWorkdestination;
    @Autowired
    @Qualifier(value="com.hack23.cia.model.external.riksdagen.dokumentstatus.impl.DocumentStatusContainer")
    private Destination documentStatusContainerWorkdestination;
    @Autowired
    @Qualifier(value="com.hack23.cia.model.external.riksdagen.personlista.impl.PersonElement")
    private Destination personElementWorkdestination;
    @Autowired
    private RiksdagenApi riksdagenApi;
    @Autowired
    @Qualifier(value="com.hack23.cia.model.external.riksdagen.votering.impl.VoteData")
    private Destination voteDataWorkdestination;

    public void onMessage(Message message) {
        ObjectMessage objectMessage = (ObjectMessage)message;
        try {
            LOGGER.info("Consumed message:{}", (Object)objectMessage.getObject());
            RiksdagenDataSources riksdagenDataSources = (RiksdagenDataSources)objectMessage.getObject();
            switch (riksdagenDataSources) {
                case DOCUMENT_LIST: {
                    this.startSwedishParliamentDocumentElementLoading();
                    break;
                }
                case PERSONS: {
                    this.startSwedishParliamentPersonLoading();
                    break;
                }
                case BALLOT_LIST: {
                    this.startBallotLoading();
                    break;
                }
                case COMMITTEE_PROPOSALS: {
                    this.startProposalLoading();
                    break;
                }
                case DOCUMENT_CONTENT: {
                    this.startSwedishParliamentContentLoading();
                    break;
                }
                case DOCUMENT_STATUS: {
                    this.startSwedishParliamentDocumentStatusLoading();
                    break;
                }
                case VOTES: {
                    break;
                }
                default: {
                    LOGGER.warn("Missing import for :{}", (Object)riksdagenDataSources);
                    break;
                }
            }
        }
        catch (JMSException jMSException) {
            LOGGER.warn("jms", (Throwable)jMSException);
        }
    }

    private void startBallotLoading() {
        try {
            List list = this.riksdagenApi.getBallotList();
            Map<String, String> map = this.importService.getLoadedBallotIdMap();
            for (BallotDocumentElement ballotDocumentElement : list) {
                if (map.containsKey(ballotDocumentElement.getBallotId())) continue;
                this.sendMessage(this.voteDataWorkdestination, (Serializable)((Object)ballotDocumentElement.getBallotId()));
                LOGGER.info("Load : http://data.riksdagen.se/votering/{}", (Object)ballotDocumentElement.getBallotId());
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Loadin ballots", (Throwable)exception);
        }
    }

    private void startProposalLoading() {
        try {
            List<String> list = this.importService.getAvaibleCommitteeProposal();
            Map<String, String> map = this.importService.getCommitteeProposalComponentDataMap();
            LOGGER.info("getAvaibleCommitteeProposal()={}", (Object)list.size());
            LOGGER.info("getCommitteeProposalComponentDataMap()={}", (Object)map.keySet().size());
            for (String string : list) {
                if (map.containsKey(string)) continue;
                this.sendMessage(this.committeeProposalComponentDataWorkdestination, (Serializable)((Object)string));
                LOGGER.info("load http://data.riksdagen.se/utskottsforslag/{}", (Object)string);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Loading avaibleCommitteeProposal", (Throwable)exception);
        }
    }

    private void startSwedishParliamentContentLoading() {
        try {
            Map<String, String> map = this.importService.getDocumentContentMap();
            List<String> list = this.importService.getAvaibleDocumentContent();
            for (String string : list) {
                if (map.containsKey(string)) continue;
                this.sendMessage(this.documentContentWorkdestination, (Serializable)((Object)string));
            }
        }
        catch (Exception exception) {
            LOGGER.warn("error loading document content", (Throwable)exception);
        }
    }

    private void startSwedishParliamentDocumentElementLoading() {
        try {
            int n = this.importService.getStartYearForDocumentElement();
            DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
            DateTime dateTime = dateTimeFormatter.parseDateTime(n + "-01-01");
            DateTime dateTime2 = dateTimeFormatter.parseDateTime(n + "-01-01");
            DateTime dateTime3 = new DateTime();
            while (dateTime2.isBefore((ReadableInstant)dateTime3)) {
                dateTime2 = dateTime2.plusWeeks(1);
                this.riksdagenApi.processDocumentList(dateTimeFormatter.print((ReadableInstant)dateTime), dateTimeFormatter.print((ReadableInstant)dateTime2), (ProcessDataStrategy)new DocumentElementWorkProducer());
                dateTime = dateTime.plusWeeks(1);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("error loading documents", (Throwable)exception);
        }
    }

    private void startSwedishParliamentDocumentStatusLoading() {
        try {
            Map<String, String> map = this.importService.getDocumentStatusContainerMap();
            ArrayList<DocumentType> arrayList = new ArrayList<DocumentType>();
            arrayList.add(DocumentType.BET);
            arrayList.add(DocumentType.PROP);
            arrayList.add(DocumentType.MOT);
            Map<String, String> map2 = this.importService.getDocumentElementMap(new SimpleDateFormat(RIKSDAGEN_JAVA_SIMPLE_DATE_FORMAT, Locale.ENGLISH).parse("1999-12-30 00:00:00"), arrayList, false);
            Set<String> set = map2.keySet();
            for (String string : set) {
                if (map.containsKey(string)) continue;
                this.sendMessage(this.documentStatusContainerWorkdestination, (Serializable)((Object)string));
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Loading document status ", (Throwable)exception);
        }
    }

    private void startSwedishParliamentPersonLoading() {
        try {
            List list = this.riksdagenApi.getPersonList().getPerson();
            Map<String, String> map = this.importService.getPersonMap();
            for (PersonElement personElement : list) {
                if (map.containsKey(personElement.getId())) continue;
                LOGGER.info("Send Load Order:{}", (Object)personElement.getPersonUrlXml());
                this.sendMessage(this.personElementWorkdestination, (Serializable)personElement);
                map.put(personElement.getId(), personElement.getId());
            }
            for (String string : RiksdagenApiAgentWorkConsumerImpl.readMissingPersonList()) {
                if (map.containsKey(string)) continue;
                LOGGER.info("Send Load Order:{}{}", (Object)"http://data.riksdagen.se/person/", (Object)string);
                this.sendMessage(this.personElementWorkdestination, (Serializable)new PersonElement().withId(string));
            }
        }
        catch (Exception exception) {
            LOGGER.warn("jms", (Throwable)exception);
        }
    }

    private static String[] readMissingPersonList() {
        Scanner scanner = new Scanner(RiksdagenApiAgentWorkConsumerImpl.class.getResourceAsStream("/personlist.txt"));
        ArrayList<String> arrayList = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            arrayList.add(scanner.nextLine());
        }
        scanner.close();
        return arrayList.toArray(new String[0]);
    }

    private class DocumentElementWorkProducer
    implements ProcessDataStrategy<DocumentElement> {
        private final Map<String, String> documentElementMap;

        private DocumentElementWorkProducer() {
            this.documentElementMap = RiksdagenApiAgentWorkConsumerImpl.this.importService.getDocumentElementMap();
        }

        public void process(DocumentElement documentElement) {
            try {
                if (!this.documentElementMap.containsKey(documentElement.getId())) {
                    RiksdagenApiAgentWorkConsumerImpl.this.sendMessage(RiksdagenApiAgentWorkConsumerImpl.this.documentElementWorkdestination, (Serializable)documentElement);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Error proccessing documentElement", (Throwable)exception);
            }
        }
    }
}

