/*
 * Decompiled with CFR 0.152.
 */
package com.hack23.cia.service.component.agent.impl.riksdagen;

import com.hack23.cia.model.external.riksdagen.documentcontent.impl.DocumentContentData;
import com.hack23.cia.model.external.riksdagen.documentcontent.impl.DocumentContentData_;
import com.hack23.cia.model.external.riksdagen.dokumentlista.impl.DocumentElement;
import com.hack23.cia.model.external.riksdagen.dokumentlista.impl.DocumentType;
import com.hack23.cia.model.external.riksdagen.dokumentstatus.impl.DocumentStatusContainer;
import com.hack23.cia.model.external.riksdagen.person.impl.PersonData;
import com.hack23.cia.model.external.riksdagen.utskottsforslag.impl.CommitteeProposalComponentData;
import com.hack23.cia.model.external.riksdagen.utskottsforslag.impl.CommitteeProposalComponentData_;
import com.hack23.cia.model.external.riksdagen.votering.impl.VoteData;
import com.hack23.cia.model.external.riksdagen.votering.impl.VoteDataEmbeddedId;
import com.hack23.cia.service.component.agent.impl.riksdagen.RiksdagenImportService;
import com.hack23.cia.service.data.api.CommitteeProposalComponentDataDAO;
import com.hack23.cia.service.data.api.DocumentContentDataDAO;
import com.hack23.cia.service.data.api.DocumentElementDAO;
import com.hack23.cia.service.data.api.DocumentStatusContainerDAO;
import com.hack23.cia.service.data.api.PersonDataDAO;
import com.hack23.cia.service.data.api.VoteDataDAO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="RiksdagenImportService")
@Transactional(propagation=Propagation.MANDATORY)
public final class RiksdagenImportServiceImpl
implements RiksdagenImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RiksdagenImportServiceImpl.class);
    private static final String RIKSDAGEN_JAVA_SIMPLE_DATE_FORMAT = "yyyy-MM-dd";
    private static final String RIKSDAGEN_JAVA_SIMPLE_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    private CommitteeProposalComponentDataDAO committeeProposalComponentDataDAO;
    @Autowired
    private DocumentContentDataDAO documentContentDataDAO;
    @Autowired
    private DocumentElementDAO documentElementDAO;
    @Autowired
    private DocumentStatusContainerDAO documentStatusContainerDAO;
    @Autowired
    private PersonDataDAO personDataDAO;
    @Autowired
    private VoteDataDAO voteDataDAO;

    private static Map<String, String> createMapFromList(List<String> list) {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        for (String string : list) {
            concurrentHashMap.put(string, string);
        }
        return concurrentHashMap;
    }

    private static Map<String, String> createMapFromListVote(List<VoteDataEmbeddedId> list) {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        for (VoteDataEmbeddedId voteDataEmbeddedId : list) {
            concurrentHashMap.put(voteDataEmbeddedId.getBallotId(), voteDataEmbeddedId.getBallotId());
        }
        return concurrentHashMap;
    }

    @Override
    public List<String> getAvaibleCommitteeProposal() {
        return this.documentStatusContainerDAO.getAvaibleCommitteeProposal();
    }

    @Override
    public List<String> getAvaibleDocumentContent() {
        return this.documentElementDAO.getAvaibleDocumentContent();
    }

    @Override
    public List<String> getAvaibleDocumentStatus() {
        return this.documentElementDAO.getIdList();
    }

    @Override
    public Map<String, String> getCommitteeProposalComponentDataMap() {
        return RiksdagenImportServiceImpl.createMapFromList(this.committeeProposalComponentDataDAO.getIdList());
    }

    @Override
    public Map<String, String> getDocumentContentMap() {
        return RiksdagenImportServiceImpl.createMapFromList(this.documentContentDataDAO.getIdList());
    }

    @Override
    public Map<String, String> getDocumentElementMap() {
        List list = this.documentElementDAO.getIdList();
        return RiksdagenImportServiceImpl.createMapFromList(list);
    }

    @Override
    public Map<String, String> getDocumentElementMap(Date date, List<DocumentType> list, boolean bl) {
        List list2 = this.documentElementDAO.getAll();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DocumentType object : list) {
            arrayList.add(object.value());
        }
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        for (DocumentElement documentElement : list2) {
            try {
                if (!RiksdagenImportServiceImpl.getDate(documentElement.getMadePublicDate()).after(date) || !arrayList.contains(documentElement.getDocumentType())) continue;
                if (bl) {
                    if (documentElement.getDocumentStatusUrlXml() == null) continue;
                    concurrentHashMap.put(documentElement.getId(), documentElement.getDocumentType());
                    continue;
                }
                concurrentHashMap.put(documentElement.getId(), documentElement.getDocumentType());
            }
            catch (ParseException parseException) {
                LOGGER.warn("Add msg", (Throwable)parseException);
            }
        }
        return concurrentHashMap;
    }

    private static Date getDate(String string) throws ParseException {
        if (RIKSDAGEN_JAVA_SIMPLE_DATE_FORMAT.length() > string.length()) {
            return new SimpleDateFormat(RIKSDAGEN_JAVA_SIMPLE_DATE_TIME_FORMAT, Locale.ENGLISH).parse(string);
        }
        return new SimpleDateFormat(RIKSDAGEN_JAVA_SIMPLE_DATE_FORMAT, Locale.ENGLISH).parse(string);
    }

    @Override
    public Map<String, String> getDocumentStatusContainerMap() {
        return RiksdagenImportServiceImpl.createMapFromList(this.documentStatusContainerDAO.getIdList());
    }

    @Override
    public Map<String, String> getLoadedBallotIdMap() {
        return RiksdagenImportServiceImpl.createMapFromListVote(this.voteDataDAO.getBallotIdList());
    }

    @Override
    public Map<String, String> getPersonMap() {
        return RiksdagenImportServiceImpl.createMapFromList(this.personDataDAO.getIdList());
    }

    @Override
    public void update(PersonData personData) {
        if (this.personDataDAO.load((Serializable)((Object)personData.getId())) != null) {
            this.personDataDAO.merge((Serializable)personData);
        } else {
            this.personDataDAO.persist((Serializable)personData);
        }
    }

    @Override
    public void updateCommitteeProposalComponentData(CommitteeProposalComponentData committeeProposalComponentData) {
        if (this.committeeProposalComponentDataDAO.findFirstByProperty(CommitteeProposalComponentData_.document, (Object)committeeProposalComponentData.getDocument()) != null) {
            this.committeeProposalComponentDataDAO.merge((Serializable)committeeProposalComponentData);
        } else {
            this.committeeProposalComponentDataDAO.persist((Serializable)committeeProposalComponentData);
        }
    }

    @Override
    public void updateDocumentContentData(DocumentContentData documentContentData) {
        if (this.documentContentDataDAO.findFirstByProperty(DocumentContentData_.id, (Object)documentContentData.getId()) == null) {
            this.documentContentDataDAO.persist((Serializable)documentContentData);
        }
    }

    @Override
    public void updateDocumentData(DocumentStatusContainer documentStatusContainer) {
        this.documentStatusContainerDAO.persist((Serializable)documentStatusContainer);
    }

    @Override
    public void updateDocumentElement(DocumentElement documentElement) {
        if (this.documentElementDAO.checkDocumentElement(documentElement.getId())) {
            this.documentElementDAO.merge((Serializable)documentElement);
        } else {
            this.documentElementDAO.persist((Serializable)documentElement);
        }
    }

    @Override
    public void updateVoteDataData(List<VoteData> list) {
        this.voteDataDAO.persist(list);
    }

    @Override
    public int getStartYearForDocumentElement() {
        return this.documentElementDAO.getMissingDocumentStartFromYear();
    }
}

