/*
 * Decompiled with CFR 0.152.
 */
package com.hack23.cia.service.component.agent.impl.worldbank;

import com.hack23.cia.model.external.worldbank.countries.impl.CountryElement;
import com.hack23.cia.model.external.worldbank.indicators.impl.IndicatorElement;
import com.hack23.cia.model.internal.application.data.impl.WorldBankDataSources;
import com.hack23.cia.service.component.agent.impl.common.AbstractAgentWorkConsumerImpl;
import com.hack23.cia.service.component.agent.impl.worldbank.WorldbankImportService;
import com.hack23.cia.service.external.worldbank.api.WorldBankApi;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="WorldBankApiAgentWorkConsumer")
public final class WorldBankApiAgentWorkConsumerImpl
extends AbstractAgentWorkConsumerImpl
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorldBankApiAgentWorkConsumerImpl.class);
    @Autowired
    private WorldbankImportService importService;
    @Autowired
    @Qualifier(value="com.hack23.cia.model.external.worldbank.countries.impl.CountryElement")
    private Destination countryElementWorkdestination;
    @Autowired
    @Qualifier(value="com.hack23.cia.model.external.worldbank.data.impl.Data")
    private Destination dataWorkdestination;
    @Autowired
    @Qualifier(value="com.hack23.cia.model.external.worldbank.indicators.impl.IndicatorElement")
    private Destination indicatorElementWorkdestination;
    @Autowired
    private WorldBankApi worldbankApi;

    public void onMessage(Message message) {
        ObjectMessage objectMessage = (ObjectMessage)message;
        try {
            WorldBankDataSources worldBankDataSources = (WorldBankDataSources)objectMessage.getObject();
            LOGGER.info("Consumed message:{}", (Object)worldBankDataSources);
            switch (worldBankDataSources) {
                case COUNTRIES: {
                    this.startWorldbankCountryLoading();
                    break;
                }
                case INDICATORS: {
                    this.startWorldBankIndicatorLoading();
                    break;
                }
                case DATA: {
                    this.startWorldBankDataLoading();
                    break;
                }
            }
        }
        catch (JMSException jMSException) {
            LOGGER.warn("jms", (Throwable)jMSException);
        }
    }

    private void startWorldbankCountryLoading() {
        try {
            List list = this.worldbankApi.getCountries();
            Map<String, String> map = this.importService.getWorldBankCountryMap();
            for (CountryElement countryElement : list) {
                if (map.containsKey(countryElement.getIso2Code())) continue;
                this.sendMessage(this.countryElementWorkdestination, (Serializable)countryElement);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("jms", (Throwable)exception);
        }
    }

    private void startWorldBankDataLoading() {
        try {
            List<IndicatorElement> list = this.importService.getAllIndicators();
            List list2 = this.worldbankApi.getCountries();
            Map<String, String> map = this.importService.getWorldBankDataMap();
            for (IndicatorElement indicatorElement : list) {
                for (CountryElement countryElement : list2) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (countryElement.getIso2Code() == null || countryElement.getIso2Code().length() <= 0) continue;
                    arrayList.add(countryElement.getIso2Code());
                    arrayList.add(indicatorElement.getId());
                    if (map.containsKey(countryElement.getIso2Code() + '.' + indicatorElement.getId())) continue;
                    this.sendMessage(this.dataWorkdestination, arrayList);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("jms", (Throwable)exception);
        }
    }

    private void startWorldBankIndicatorLoading() {
        try {
            List list = this.worldbankApi.getIndicators();
            Map<String, String> map = this.importService.getWorldBankIndicatorElementMap();
            for (IndicatorElement indicatorElement : list) {
                if (map.containsKey(indicatorElement.getId())) continue;
                this.sendMessage(this.indicatorElementWorkdestination, (Serializable)indicatorElement);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("jms", (Throwable)exception);
        }
    }
}

