/*
 * Decompiled with CFR 0.152.
 */
package com.hack23.cia.service.component.agent.impl.worldbank;

import com.hack23.cia.model.external.worldbank.countries.impl.CountryElement;
import com.hack23.cia.model.external.worldbank.data.impl.WorldBankData;
import com.hack23.cia.model.external.worldbank.indicators.impl.IndicatorElement;
import com.hack23.cia.service.component.agent.impl.worldbank.WorldbankImportService;
import com.hack23.cia.service.data.api.CountryElementDAO;
import com.hack23.cia.service.data.api.DataDAO;
import com.hack23.cia.service.data.api.IndicatorElementDAO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="WorldbankImportService")
@Transactional(propagation=Propagation.MANDATORY)
public final class WorldbankImportServiceImpl
implements WorldbankImportService {
    @Autowired
    private CountryElementDAO countryElementDAO;
    @Autowired
    private DataDAO dataDAO;
    @Autowired
    private IndicatorElementDAO indicatorElementDAO;

    private static Map<String, String> createMapFromList(List<String> list) {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        for (String string : list) {
            concurrentHashMap.put(string, string);
        }
        return concurrentHashMap;
    }

    @Override
    public List<IndicatorElement> getAllIndicators() {
        return this.indicatorElementDAO.getAll();
    }

    @Override
    public Map<String, String> getWorldBankCountryMap() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CountryElement countryElement : this.countryElementDAO.getAll()) {
            arrayList.add(countryElement.getIso2Code());
        }
        return WorldbankImportServiceImpl.createMapFromList(arrayList);
    }

    @Override
    public Map<String, String> getWorldBankDataMap() {
        return WorldbankImportServiceImpl.createMapFromList(this.dataDAO.getIdList());
    }

    @Override
    public Map<String, String> getWorldBankIndicatorElementMap() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IndicatorElement indicatorElement : this.indicatorElementDAO.getAll()) {
            arrayList.add(indicatorElement.getId());
        }
        return WorldbankImportServiceImpl.createMapFromList(arrayList);
    }

    @Override
    public void updateCountryElement(CountryElement countryElement) {
        this.countryElementDAO.persist((Serializable)countryElement);
    }

    @Override
    public void updateData(List<WorldBankData> list) {
        this.dataDAO.persist(list);
    }

    @Override
    public void updateIndicatorElement(IndicatorElement indicatorElement) {
        this.indicatorElementDAO.persist((Serializable)indicatorElement);
    }
}

