/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.SupportedCapability;
import com.highmobility.autoapi.value.Webhook;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;

public class Capabilities {
    public static final int IDENTIFIER = 16;
    public static final byte PROPERTY_CAPABILITIES = 1;
    public static final byte PROPERTY_WEBHOOKS = 2;

    public static class State
    extends SetCommand {
        List<Property<SupportedCapability>> capabilities;
        List<Property<Webhook>> webhooks;

        public List<Property<SupportedCapability>> getCapabilities() {
            return this.capabilities;
        }

        public List<Property<Webhook>> getWebhooks() {
            return this.webhooks;
        }

        public boolean getSupported(Integer identifier, byte propertyID) {
            for (Property<SupportedCapability> capability : this.capabilities) {
                if (!identifier.equals(capability.getValue().getCapabilityID())) continue;
                for (Byte supportedPropertyID : capability.getValue().getSupportedPropertyIDs()) {
                    if (supportedPropertyID != propertyID) continue;
                    return true;
                }
            }
            return false;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<SupportedCapability>> capabilitiesBuilder = new ArrayList<Property<SupportedCapability>>();
            ArrayList<Property<Webhook>> webhooksBuilder = new ArrayList<Property<Webhook>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            Property<SupportedCapability> capability = new Property<SupportedCapability>(SupportedCapability.class, p);
                            capabilitiesBuilder.add(capability);
                            return capability;
                        }
                        case 2: {
                            Property<Webhook> webhook = new Property<Webhook>(Webhook.class, p);
                            webhooksBuilder.add(webhook);
                            return webhook;
                        }
                    }
                    return null;
                });
            }
            this.capabilities = capabilitiesBuilder;
            this.webhooks = webhooksBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(16);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setCapabilities(Property<SupportedCapability>[] capabilities) {
                for (int i = 0; i < capabilities.length; ++i) {
                    this.addCapability(capabilities[i]);
                }
                return this;
            }

            public Builder addCapability(Property<SupportedCapability> capability) {
                capability.setIdentifier((byte)1);
                this.addProperty(capability);
                return this;
            }

            public Builder setWebhooks(Property<Webhook>[] webhooks) {
                for (int i = 0; i < webhooks.length; ++i) {
                    this.addWebhook(webhooks[i]);
                }
                return this;
            }

            public Builder addWebhook(Property<Webhook> webhook) {
                webhook.setIdentifier((byte)2);
                this.addProperty(webhook);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetCapabilitiesProperties
    extends GetCommand<State> {
        public GetCapabilitiesProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)16, propertyIdentifiers);
        }

        public GetCapabilitiesProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)16, new Bytes(propertyIdentifiers));
        }

        GetCapabilitiesProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetCapabilities
    extends GetCommand<State> {
        public GetCapabilities() {
            super(State.class, 16);
        }

        public GetCapabilities(Bytes propertyIdentifiers) {
            super(State.class, (Integer)16, propertyIdentifiers);
        }

        public GetCapabilities(byte ... propertyIdentifiers) {
            super(State.class, (Integer)16, new Bytes(propertyIdentifiers));
        }

        GetCapabilities(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }
}

