/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.DrivingMode;
import com.highmobility.autoapi.value.SpringRate;
import com.highmobility.autoapi.value.measurement.Length;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;

public class ChassisSettings {
    public static final int IDENTIFIER = 83;
    public static final byte PROPERTY_DRIVING_MODE = 1;
    public static final byte PROPERTY_SPORT_CHRONO = 2;
    public static final byte PROPERTY_CURRENT_SPRING_RATES = 5;
    public static final byte PROPERTY_MAXIMUM_SPRING_RATES = 6;
    public static final byte PROPERTY_MINIMUM_SPRING_RATES = 7;
    public static final byte PROPERTY_CURRENT_CHASSIS_POSITION = 8;
    public static final byte PROPERTY_MAXIMUM_CHASSIS_POSITION = 9;
    public static final byte PROPERTY_MINIMUM_CHASSIS_POSITION = 10;

    public static enum SportChrono implements ByteEnum
    {
        INACTIVE(0),
        ACTIVE(1),
        RESET(2);

        private final byte value;

        public static SportChrono fromByte(byte byteValue) throws CommandParseException {
            SportChrono[] values = SportChrono.values();
            for (int i = 0; i < values.length; ++i) {
                SportChrono state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(SportChrono.class.getSimpleName(), byteValue));
        }

        private SportChrono(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<DrivingMode> drivingMode = new Property<DrivingMode>(DrivingMode.class, 1);
        Property<SportChrono> sportChrono = new Property<SportChrono>(SportChrono.class, 2);
        List<Property<SpringRate>> currentSpringRates;
        List<Property<SpringRate>> maximumSpringRates;
        List<Property<SpringRate>> minimumSpringRates;
        Property<Length> currentChassisPosition = new Property<Length>(Length.class, 8);
        Property<Length> maximumChassisPosition = new Property<Length>(Length.class, 9);
        Property<Length> minimumChassisPosition = new Property<Length>(Length.class, 10);

        public Property<DrivingMode> getDrivingMode() {
            return this.drivingMode;
        }

        public Property<SportChrono> getSportChrono() {
            return this.sportChrono;
        }

        public List<Property<SpringRate>> getCurrentSpringRates() {
            return this.currentSpringRates;
        }

        public List<Property<SpringRate>> getMaximumSpringRates() {
            return this.maximumSpringRates;
        }

        public List<Property<SpringRate>> getMinimumSpringRates() {
            return this.minimumSpringRates;
        }

        public Property<Length> getCurrentChassisPosition() {
            return this.currentChassisPosition;
        }

        public Property<Length> getMaximumChassisPosition() {
            return this.maximumChassisPosition;
        }

        public Property<Length> getMinimumChassisPosition() {
            return this.minimumChassisPosition;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<SpringRate>> currentSpringRatesBuilder = new ArrayList<Property<SpringRate>>();
            ArrayList<Property<SpringRate>> maximumSpringRatesBuilder = new ArrayList<Property<SpringRate>>();
            ArrayList<Property<SpringRate>> minimumSpringRatesBuilder = new ArrayList<Property<SpringRate>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.drivingMode.update(p);
                        }
                        case 2: {
                            return this.sportChrono.update(p);
                        }
                        case 5: {
                            Property<SpringRate> currentSpringRate = new Property<SpringRate>(SpringRate.class, p);
                            currentSpringRatesBuilder.add(currentSpringRate);
                            return currentSpringRate;
                        }
                        case 6: {
                            Property<SpringRate> maximumSpringRate = new Property<SpringRate>(SpringRate.class, p);
                            maximumSpringRatesBuilder.add(maximumSpringRate);
                            return maximumSpringRate;
                        }
                        case 7: {
                            Property<SpringRate> minimumSpringRate = new Property<SpringRate>(SpringRate.class, p);
                            minimumSpringRatesBuilder.add(minimumSpringRate);
                            return minimumSpringRate;
                        }
                        case 8: {
                            return this.currentChassisPosition.update(p);
                        }
                        case 9: {
                            return this.maximumChassisPosition.update(p);
                        }
                        case 10: {
                            return this.minimumChassisPosition.update(p);
                        }
                    }
                    return null;
                });
            }
            this.currentSpringRates = currentSpringRatesBuilder;
            this.maximumSpringRates = maximumSpringRatesBuilder;
            this.minimumSpringRates = minimumSpringRatesBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(83);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setDrivingMode(Property<DrivingMode> drivingMode) {
                Property<DrivingMode> property = drivingMode.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setSportChrono(Property<SportChrono> sportChrono) {
                Property<SportChrono> property = sportChrono.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setCurrentSpringRates(Property<SpringRate>[] currentSpringRates) {
                for (int i = 0; i < currentSpringRates.length; ++i) {
                    this.addCurrentSpringRate(currentSpringRates[i]);
                }
                return this;
            }

            public Builder addCurrentSpringRate(Property<SpringRate> currentSpringRate) {
                currentSpringRate.setIdentifier((byte)5);
                this.addProperty(currentSpringRate);
                return this;
            }

            public Builder setMaximumSpringRates(Property<SpringRate>[] maximumSpringRates) {
                for (int i = 0; i < maximumSpringRates.length; ++i) {
                    this.addMaximumSpringRate(maximumSpringRates[i]);
                }
                return this;
            }

            public Builder addMaximumSpringRate(Property<SpringRate> maximumSpringRate) {
                maximumSpringRate.setIdentifier((byte)6);
                this.addProperty(maximumSpringRate);
                return this;
            }

            public Builder setMinimumSpringRates(Property<SpringRate>[] minimumSpringRates) {
                for (int i = 0; i < minimumSpringRates.length; ++i) {
                    this.addMinimumSpringRate(minimumSpringRates[i]);
                }
                return this;
            }

            public Builder addMinimumSpringRate(Property<SpringRate> minimumSpringRate) {
                minimumSpringRate.setIdentifier((byte)7);
                this.addProperty(minimumSpringRate);
                return this;
            }

            public Builder setCurrentChassisPosition(Property<Length> currentChassisPosition) {
                Property<Length> property = currentChassisPosition.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setMaximumChassisPosition(Property<Length> maximumChassisPosition) {
                Property<Length> property = maximumChassisPosition.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            public Builder setMinimumChassisPosition(Property<Length> minimumChassisPosition) {
                Property<Length> property = minimumChassisPosition.setIdentifier((byte)10);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class SetChassisPosition
    extends SetCommand {
        Property<Length> currentChassisPosition = new Property<Length>(Length.class, 8);

        public Property<Length> getCurrentChassisPosition() {
            return this.currentChassisPosition;
        }

        public SetChassisPosition(Length currentChassisPosition) {
            super(83);
            this.addProperty(this.currentChassisPosition.update(currentChassisPosition));
            this.createBytes();
        }

        SetChassisPosition(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 8) {
                        return this.currentChassisPosition.update(p);
                    }
                    return null;
                });
            }
            if (this.currentChassisPosition.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class SetSpringRates
    extends SetCommand {
        List<Property<SpringRate>> currentSpringRates;

        public List<Property<SpringRate>> getCurrentSpringRates() {
            return this.currentSpringRates;
        }

        public SetSpringRates(List<SpringRate> currentSpringRates) {
            super(83);
            ArrayList<Property<SpringRate>> currentSpringRatesBuilder = new ArrayList<Property<SpringRate>>();
            if (currentSpringRates != null) {
                for (SpringRate currentSpringRate : currentSpringRates) {
                    Property<SpringRate> prop = new Property<SpringRate>(5, currentSpringRate);
                    currentSpringRatesBuilder.add(prop);
                    this.addProperty(prop);
                }
            }
            this.currentSpringRates = currentSpringRatesBuilder;
            this.createBytes();
        }

        SetSpringRates(byte[] bytes) throws PropertyParseException {
            super(bytes);
            ArrayList<Property<SpringRate>> currentSpringRatesBuilder = new ArrayList<Property<SpringRate>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 5) {
                        Property<SpringRate> currentSpringRate = new Property<SpringRate>(SpringRate.class, p);
                        currentSpringRatesBuilder.add(currentSpringRate);
                        return currentSpringRate;
                    }
                    return null;
                });
            }
            this.currentSpringRates = currentSpringRatesBuilder;
            if (this.currentSpringRates.size() == 0) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class StartStopSportsChrono
    extends SetCommand {
        Property<SportChrono> sportChrono = new Property<SportChrono>(SportChrono.class, 2);

        public Property<SportChrono> getSportChrono() {
            return this.sportChrono;
        }

        public StartStopSportsChrono(SportChrono sportChrono) {
            super(83);
            this.addProperty(this.sportChrono.update(sportChrono));
            this.createBytes();
        }

        StartStopSportsChrono(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 2) {
                        return this.sportChrono.update(p);
                    }
                    return null;
                });
            }
            if (this.sportChrono.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class SetDrivingMode
    extends SetCommand {
        Property<DrivingMode> drivingMode = new Property<DrivingMode>(DrivingMode.class, 1);

        public Property<DrivingMode> getDrivingMode() {
            return this.drivingMode;
        }

        public SetDrivingMode(DrivingMode drivingMode) {
            super(83);
            this.addProperty(this.drivingMode.update(drivingMode));
            this.createBytes();
        }

        SetDrivingMode(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 1) {
                        return this.drivingMode.update(p);
                    }
                    return null;
                });
            }
            if (this.drivingMode.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetChassisSettingsProperties
    extends GetCommand<State> {
        public GetChassisSettingsProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)83, propertyIdentifiers);
        }

        public GetChassisSettingsProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)83, new Bytes(propertyIdentifiers));
        }

        GetChassisSettingsProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetChassisSettings
    extends GetCommand<State> {
        public GetChassisSettings() {
            super(State.class, 83);
        }

        public GetChassisSettings(Bytes propertyIdentifiers) {
            super(State.class, (Integer)83, propertyIdentifiers);
        }

        public GetChassisSettings(byte ... propertyIdentifiers) {
            super(State.class, (Integer)83, new Bytes(propertyIdentifiers));
        }

        GetChassisSettings(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetChassisSettingsAvailability
    extends GetAvailabilityCommand {
        public GetChassisSettingsAvailability() {
            super(83);
        }

        public GetChassisSettingsAvailability(Bytes propertyIdentifiers) {
            super(83, propertyIdentifiers);
        }

        public GetChassisSettingsAvailability(byte ... propertyIdentifiers) {
            super(83, new Bytes(propertyIdentifiers));
        }

        GetChassisSettingsAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

