/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.autoapi.value.WeekdayTime;
import com.highmobility.autoapi.value.measurement.Power;
import com.highmobility.autoapi.value.measurement.Temperature;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Climate {
    public static final int IDENTIFIER = 36;
    public static final byte PROPERTY_INSIDE_TEMPERATURE = 1;
    public static final byte PROPERTY_OUTSIDE_TEMPERATURE = 2;
    public static final byte PROPERTY_DRIVER_TEMPERATURE_SETTING = 3;
    public static final byte PROPERTY_PASSENGER_TEMPERATURE_SETTING = 4;
    public static final byte PROPERTY_HVAC_STATE = 5;
    public static final byte PROPERTY_DEFOGGING_STATE = 6;
    public static final byte PROPERTY_DEFROSTING_STATE = 7;
    public static final byte PROPERTY_IONISING_STATE = 8;
    public static final byte PROPERTY_DEFROSTING_TEMPERATURE_SETTING = 9;
    public static final byte PROPERTY_HVAC_WEEKDAY_STARTING_TIMES = 11;
    public static final byte PROPERTY_REAR_TEMPERATURE_SETTING = 12;
    public static final byte PROPERTY_HUMIDITY = 13;
    public static final byte PROPERTY_AIR_CONDITIONER_COMPRESSOR_POWER = 14;

    public static class State
    extends SetCommand {
        Property<Temperature> insideTemperature = new Property<Temperature>(Temperature.class, 1);
        Property<Temperature> outsideTemperature = new Property<Temperature>(Temperature.class, 2);
        Property<Temperature> driverTemperatureSetting = new Property<Temperature>(Temperature.class, 3);
        Property<Temperature> passengerTemperatureSetting = new Property<Temperature>(Temperature.class, 4);
        Property<ActiveState> hvacState = new Property<ActiveState>(ActiveState.class, 5);
        Property<ActiveState> defoggingState = new Property<ActiveState>(ActiveState.class, 6);
        Property<ActiveState> defrostingState = new Property<ActiveState>(ActiveState.class, 7);
        Property<ActiveState> ionisingState = new Property<ActiveState>(ActiveState.class, 8);
        Property<Temperature> defrostingTemperatureSetting = new Property<Temperature>(Temperature.class, 9);
        List<Property<WeekdayTime>> hvacWeekdayStartingTimes;
        Property<Temperature> rearTemperatureSetting = new Property<Temperature>(Temperature.class, 12);
        Property<Double> humidity = new Property<Double>(Double.class, 13);
        Property<Power> airConditionerCompressorPower = new Property<Power>(Power.class, 14);

        public Property<Temperature> getInsideTemperature() {
            return this.insideTemperature;
        }

        public Property<Temperature> getOutsideTemperature() {
            return this.outsideTemperature;
        }

        public Property<Temperature> getDriverTemperatureSetting() {
            return this.driverTemperatureSetting;
        }

        public Property<Temperature> getPassengerTemperatureSetting() {
            return this.passengerTemperatureSetting;
        }

        public Property<ActiveState> getHvacState() {
            return this.hvacState;
        }

        public Property<ActiveState> getDefoggingState() {
            return this.defoggingState;
        }

        public Property<ActiveState> getDefrostingState() {
            return this.defrostingState;
        }

        public Property<ActiveState> getIonisingState() {
            return this.ionisingState;
        }

        public Property<Temperature> getDefrostingTemperatureSetting() {
            return this.defrostingTemperatureSetting;
        }

        public List<Property<WeekdayTime>> getHvacWeekdayStartingTimes() {
            return this.hvacWeekdayStartingTimes;
        }

        public Property<Temperature> getRearTemperatureSetting() {
            return this.rearTemperatureSetting;
        }

        public Property<Double> getHumidity() {
            return this.humidity;
        }

        public Property<Power> getAirConditionerCompressorPower() {
            return this.airConditionerCompressorPower;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<WeekdayTime>> hvacWeekdayStartingTimesBuilder = new ArrayList<Property<WeekdayTime>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.insideTemperature.update(p);
                        }
                        case 2: {
                            return this.outsideTemperature.update(p);
                        }
                        case 3: {
                            return this.driverTemperatureSetting.update(p);
                        }
                        case 4: {
                            return this.passengerTemperatureSetting.update(p);
                        }
                        case 5: {
                            return this.hvacState.update(p);
                        }
                        case 6: {
                            return this.defoggingState.update(p);
                        }
                        case 7: {
                            return this.defrostingState.update(p);
                        }
                        case 8: {
                            return this.ionisingState.update(p);
                        }
                        case 9: {
                            return this.defrostingTemperatureSetting.update(p);
                        }
                        case 11: {
                            Property<WeekdayTime> hvacWeekdayStartingTime = new Property<WeekdayTime>(WeekdayTime.class, p);
                            hvacWeekdayStartingTimesBuilder.add(hvacWeekdayStartingTime);
                            return hvacWeekdayStartingTime;
                        }
                        case 12: {
                            return this.rearTemperatureSetting.update(p);
                        }
                        case 13: {
                            return this.humidity.update(p);
                        }
                        case 14: {
                            return this.airConditionerCompressorPower.update(p);
                        }
                    }
                    return null;
                });
            }
            this.hvacWeekdayStartingTimes = hvacWeekdayStartingTimesBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(36);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setInsideTemperature(Property<Temperature> insideTemperature) {
                Property<Temperature> property = insideTemperature.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setOutsideTemperature(Property<Temperature> outsideTemperature) {
                Property<Temperature> property = outsideTemperature.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setDriverTemperatureSetting(Property<Temperature> driverTemperatureSetting) {
                Property<Temperature> property = driverTemperatureSetting.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setPassengerTemperatureSetting(Property<Temperature> passengerTemperatureSetting) {
                Property<Temperature> property = passengerTemperatureSetting.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setHvacState(Property<ActiveState> hvacState) {
                Property<ActiveState> property = hvacState.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setDefoggingState(Property<ActiveState> defoggingState) {
                Property<ActiveState> property = defoggingState.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setDefrostingState(Property<ActiveState> defrostingState) {
                Property<ActiveState> property = defrostingState.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setIonisingState(Property<ActiveState> ionisingState) {
                Property<ActiveState> property = ionisingState.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setDefrostingTemperatureSetting(Property<Temperature> defrostingTemperatureSetting) {
                Property<Temperature> property = defrostingTemperatureSetting.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            public Builder setHvacWeekdayStartingTimes(Property<WeekdayTime>[] hvacWeekdayStartingTimes) {
                for (int i = 0; i < hvacWeekdayStartingTimes.length; ++i) {
                    this.addHvacWeekdayStartingTime(hvacWeekdayStartingTimes[i]);
                }
                return this;
            }

            public Builder addHvacWeekdayStartingTime(Property<WeekdayTime> hvacWeekdayStartingTime) {
                hvacWeekdayStartingTime.setIdentifier((byte)11);
                this.addProperty(hvacWeekdayStartingTime);
                return this;
            }

            public Builder setRearTemperatureSetting(Property<Temperature> rearTemperatureSetting) {
                Property<Temperature> property = rearTemperatureSetting.setIdentifier((byte)12);
                this.addProperty(property);
                return this;
            }

            public Builder setHumidity(Property<Double> humidity) {
                Property<Double> property = humidity.setIdentifier((byte)13);
                this.addProperty(property);
                return this;
            }

            public Builder setAirConditionerCompressorPower(Property<Power> airConditionerCompressorPower) {
                Property<Power> property = airConditionerCompressorPower.setIdentifier((byte)14);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class SetTemperatureSettings
    extends SetCommand {
        Property<Temperature> driverTemperatureSetting = new Property<Temperature>(Temperature.class, 3);
        Property<Temperature> passengerTemperatureSetting = new Property<Temperature>(Temperature.class, 4);
        Property<Temperature> rearTemperatureSetting = new Property<Temperature>(Temperature.class, 12);

        public Property<Temperature> getDriverTemperatureSetting() {
            return this.driverTemperatureSetting;
        }

        public Property<Temperature> getPassengerTemperatureSetting() {
            return this.passengerTemperatureSetting;
        }

        public Property<Temperature> getRearTemperatureSetting() {
            return this.rearTemperatureSetting;
        }

        public SetTemperatureSettings(@Nullable Temperature driverTemperatureSetting, @Nullable Temperature passengerTemperatureSetting, @Nullable Temperature rearTemperatureSetting) {
            super(36);
            this.addProperty(this.driverTemperatureSetting.update(driverTemperatureSetting));
            this.addProperty(this.passengerTemperatureSetting.update(passengerTemperatureSetting));
            this.addProperty(this.rearTemperatureSetting.update(rearTemperatureSetting));
            if (this.driverTemperatureSetting.getValue() == null && this.passengerTemperatureSetting.getValue() == null && this.rearTemperatureSetting.getValue() == null) {
                throw new IllegalArgumentException();
            }
            this.createBytes();
        }

        SetTemperatureSettings(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 3: {
                            return this.driverTemperatureSetting.update(p);
                        }
                        case 4: {
                            return this.passengerTemperatureSetting.update(p);
                        }
                        case 12: {
                            return this.rearTemperatureSetting.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.driverTemperatureSetting.getValue() == null && this.passengerTemperatureSetting.getValue() == null && this.rearTemperatureSetting.getValue() == null) {
                throw new PropertyParseException(this.optionalPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class StartStopIonising
    extends SetCommand {
        Property<ActiveState> ionisingState = new Property<ActiveState>(ActiveState.class, 8);

        public Property<ActiveState> getIonisingState() {
            return this.ionisingState;
        }

        public StartStopIonising(ActiveState ionisingState) {
            super(36);
            this.addProperty(this.ionisingState.update(ionisingState));
            this.createBytes();
        }

        StartStopIonising(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 8) {
                        return this.ionisingState.update(p);
                    }
                    return null;
                });
            }
            if (this.ionisingState.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class StartStopDefrosting
    extends SetCommand {
        Property<ActiveState> defrostingState = new Property<ActiveState>(ActiveState.class, 7);

        public Property<ActiveState> getDefrostingState() {
            return this.defrostingState;
        }

        public StartStopDefrosting(ActiveState defrostingState) {
            super(36);
            this.addProperty(this.defrostingState.update(defrostingState));
            this.createBytes();
        }

        StartStopDefrosting(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 7) {
                        return this.defrostingState.update(p);
                    }
                    return null;
                });
            }
            if (this.defrostingState.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class StartStopDefogging
    extends SetCommand {
        Property<ActiveState> defoggingState = new Property<ActiveState>(ActiveState.class, 6);

        public Property<ActiveState> getDefoggingState() {
            return this.defoggingState;
        }

        public StartStopDefogging(ActiveState defoggingState) {
            super(36);
            this.addProperty(this.defoggingState.update(defoggingState));
            this.createBytes();
        }

        StartStopDefogging(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 6) {
                        return this.defoggingState.update(p);
                    }
                    return null;
                });
            }
            if (this.defoggingState.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class StartStopHvac
    extends SetCommand {
        Property<ActiveState> hvacState = new Property<ActiveState>(ActiveState.class, 5);

        public Property<ActiveState> getHvacState() {
            return this.hvacState;
        }

        public StartStopHvac(ActiveState hvacState) {
            super(36);
            this.addProperty(this.hvacState.update(hvacState));
            this.createBytes();
        }

        StartStopHvac(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 5) {
                        return this.hvacState.update(p);
                    }
                    return null;
                });
            }
            if (this.hvacState.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class ChangeStartingTimes
    extends SetCommand {
        List<Property<WeekdayTime>> hvacWeekdayStartingTimes;

        public List<Property<WeekdayTime>> getHvacWeekdayStartingTimes() {
            return this.hvacWeekdayStartingTimes;
        }

        public ChangeStartingTimes(List<WeekdayTime> hvacWeekdayStartingTimes) {
            super(36);
            ArrayList<Property<WeekdayTime>> hvacWeekdayStartingTimesBuilder = new ArrayList<Property<WeekdayTime>>();
            if (hvacWeekdayStartingTimes != null) {
                for (WeekdayTime hvacWeekdayStartingTime : hvacWeekdayStartingTimes) {
                    Property<WeekdayTime> prop = new Property<WeekdayTime>(11, hvacWeekdayStartingTime);
                    hvacWeekdayStartingTimesBuilder.add(prop);
                    this.addProperty(prop);
                }
            }
            this.hvacWeekdayStartingTimes = hvacWeekdayStartingTimesBuilder;
            this.createBytes();
        }

        ChangeStartingTimes(byte[] bytes) throws PropertyParseException {
            super(bytes);
            ArrayList<Property<WeekdayTime>> hvacWeekdayStartingTimesBuilder = new ArrayList<Property<WeekdayTime>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 11) {
                        Property<WeekdayTime> hvacWeekdayStartingTime = new Property<WeekdayTime>(WeekdayTime.class, p);
                        hvacWeekdayStartingTimesBuilder.add(hvacWeekdayStartingTime);
                        return hvacWeekdayStartingTime;
                    }
                    return null;
                });
            }
            this.hvacWeekdayStartingTimes = hvacWeekdayStartingTimesBuilder;
            if (this.hvacWeekdayStartingTimes.size() == 0) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)36, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)36, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 36);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)36, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)36, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(36);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(36, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(36, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

