/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.AutoApiLogger;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.Identifier;
import com.highmobility.autoapi.PropertyEnumeration;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.Type;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.Brand;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class Command
extends Bytes {
    private static final String INVALID_VERSION_EXCEPTION = "Invalid AutoAPI version. This package supports level %d.";
    public static final byte NONCE_IDENTIFIER = -96;
    public static final byte SIGNATURE_IDENTIFIER = -95;
    public static final byte TIMESTAMP_IDENTIFIER = -94;
    public static final byte VIN_IDENTIFIER = -93;
    public static final byte BRAND_IDENTIFIER = -92;
    public static final List<Byte> universalPropertyIds = Arrays.asList((byte)-96, (byte)-95, (byte)-94, (byte)-93, (byte)-92);
    static final byte AUTO_API_VERSION = 13;
    static final int HEADER_LENGTH = 1;
    static final int COMMAND_TYPE_POSITION = 3;
    int type;
    int identifier;
    int autoApiVersion;
    Property[] properties;
    Bytes nonce;
    Bytes signature;
    Calendar timestamp;
    String vin;
    Brand brand;
    protected PropertyIterator propertyIterator;

    public int getAutoApiVersion() {
        return this.autoApiVersion;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public int getCommandType() {
        return this.type;
    }

    @Nullable
    public Bytes getNonce() {
        return this.nonce;
    }

    @Nullable
    public Bytes getSignature() {
        return this.signature;
    }

    @Nullable
    public Calendar getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String getVin() {
        return this.vin;
    }

    @Nullable
    public Brand getBrand() {
        return this.brand;
    }

    public Bytes getSignedBytes() {
        return new Bytes(Arrays.copyOfRange(this.bytes, 0, this.bytes.length - 64 - 3 - 3));
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public Property getProperty(byte identifier) {
        for (int i = 0; i < this.properties.length; ++i) {
            Property prop = this.properties[i];
            if (prop.getPropertyIdentifier() != identifier) continue;
            return prop;
        }
        return null;
    }

    protected Command() {
        this.autoApiVersion = 13;
    }

    Command(byte[] bytes) {
        super(bytes);
        if (bytes[0] != 13) {
            AutoApiLogger.getLogger().error(String.format(INVALID_VERSION_EXCEPTION, 13));
        }
        this.setTypeAndBytes(bytes);
        ArrayList builder = new ArrayList();
        PropertyEnumeration enumeration = new PropertyEnumeration(this.bytes);
        while (enumeration.hasMoreElements()) {
            PropertyEnumeration.EnumeratedProperty propertyEnumeration = enumeration.nextElement();
            if (!propertyEnumeration.isValid(bytes.length)) continue;
            Property property = new Property(Arrays.copyOfRange(bytes, propertyEnumeration.valueStart - 3, propertyEnumeration.valueStart + propertyEnumeration.size));
            builder.add(property);
        }
        this.findUniversalProperties(this.identifier, this.type, builder.toArray(new Property[0]));
    }

    Command(Integer identifier, Integer type, Property[] properties) {
        this.autoApiVersion = 13;
        this.type = type;
        this.identifier = identifier;
        this.findUniversalProperties(identifier, type, properties, true);
    }

    Command(Integer identifier, int type, int sizeAfterType) {
        this.autoApiVersion = 13;
        this.type = type;
        this.identifier = identifier;
        this.createBytes(sizeAfterType);
    }

    private void setTypeAndBytes(byte[] bytes) {
        int versionByte = 0;
        byte firstByte = 0;
        byte secondByte = 0;
        byte thirdByte = 0;
        if (bytes != null) {
            if (bytes.length > 0) {
                versionByte = bytes[0];
            }
            if (bytes.length > 1) {
                firstByte = bytes[1];
            }
            if (bytes.length > 2) {
                secondByte = bytes[2];
            }
            if (bytes.length > 3) {
                thirdByte = bytes[3];
            }
        }
        this.identifier = Identifier.fromBytes(firstByte, secondByte);
        this.type = Type.fromByte(thirdByte);
        this.autoApiVersion = versionByte;
    }

    protected void findUniversalProperties(Integer identifier, Integer type, Property[] properties) {
        this.findUniversalProperties(identifier, type, properties, false);
    }

    protected void findUniversalProperties(Integer identifier, Integer type, Property[] properties, boolean createBytes) {
        this.properties = properties;
        int propertyPosition = 4;
        if (createBytes) {
            this.createBytes(this.getPropertiesSize(properties));
        }
        for (int i = 0; i < properties.length; ++i) {
            try {
                Property property = properties[i];
                if (createBytes) {
                    this.set(propertyPosition, property);
                    propertyPosition += property.size();
                }
                switch (property.getPropertyIdentifier()) {
                    case -96: {
                        if (property.getValueComponent().getValueBytes().getLength() != 9) break;
                        this.nonce = property.getValueComponent().getValueBytes();
                        break;
                    }
                    case -95: {
                        if (property.getValueComponent().getValueBytes().getLength() != 64) break;
                        this.signature = property.getValueComponent().getValueBytes();
                        break;
                    }
                    case -94: {
                        this.timestamp = Property.getCalendar(property.getValueComponent().getValueBytes());
                        break;
                    }
                    case -93: {
                        this.vin = Property.getString(property.getValueComponent().getValueBytes());
                        break;
                    }
                    case -92: {
                        this.brand = Brand.Companion.fromInt(property.getValueComponent().getValueByte());
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.propertyIterator = new PropertyIterator();
    }

    private void createBytes(int sizeAfterType) {
        this.bytes = new byte[4 + sizeAfterType];
        this.set(0, (byte)13);
        this.set(1, Identifier.toBytes(this.identifier));
        this.set(3, Type.toByte(this.type));
    }

    private int getPropertiesSize(Property[] properties) {
        int size = 0;
        for (int i = 0; i < properties.length; ++i) {
            size += properties[i].size();
        }
        return size;
    }

    protected class PropertyIterator
    implements Iterator<Property> {
        private final int currentSize;
        private int propertiesReplaced = 0;
        private int currentIndex = 0;

        PropertyIterator() {
            this.currentSize = Command.this.properties.length;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.currentSize && Command.this.properties[this.currentIndex] != null;
        }

        @Override
        public Property next() {
            return Command.this.properties[this.currentIndex++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void parseNext(PropertyIteration next, HandleNotParsedProperty nullProperty) throws PropertyParseException {
            Property nextProperty = this.next();
            while (nextProperty.isUniversalProperty()) {
                if (this.hasNext()) {
                    nextProperty = this.next();
                    continue;
                }
                return;
            }
            try {
                Property parsedProperty = next.iterate(nextProperty);
                if (parsedProperty != null) {
                    Command.this.properties[this.currentIndex - 1] = parsedProperty;
                    ++this.propertiesReplaced;
                } else {
                    nullProperty.handle(nextProperty);
                }
            }
            catch (PropertyParseException propertyParseException) {
                if (propertyParseException.getCode() == PropertyParseException.ErrorCode.SETTER_SUPERFLUOUS_PROPERTY) {
                    throw propertyParseException;
                }
                nextProperty.printFailedToParse(propertyParseException, null);
            }
            catch (Exception e) {
                nextProperty.printFailedToParse(e, null);
            }
        }

        public void parseNextState(PropertyIteration next) {
            try {
                this.parseNext(next, notHandledProperty -> notHandledProperty.printFailedToParse(new PropertyParseException("Invalid property"), null));
            }
            catch (PropertyParseException propertyParseException) {
                // empty catch block
            }
        }

        public void parseNextSetter(PropertyIteration next) throws PropertyParseException {
            this.parseNext(next, notHandledProperty -> {
                if (CommandResolver._environment == CommandResolver.Environment.VEHICLE) {
                    throw new PropertyParseException(PropertyParseException.ErrorCode.SETTER_SUPERFLUOUS_PROPERTY, this.getClass(), notHandledProperty.getPropertyIdentifier());
                }
            });
        }
    }

    public static interface PropertyIteration {
        @Nullable
        public Property iterate(Property var1) throws Exception;
    }

    @FunctionalInterface
    public static interface HandleNotParsedProperty {
        public void handle(Property var1) throws PropertyParseException;
    }
}

