/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.autoapi.value.CheckControlMessage;
import com.highmobility.autoapi.value.ConfirmedTroubleCode;
import com.highmobility.autoapi.value.DieselExhaustFilterStatus;
import com.highmobility.autoapi.value.FluidLevel;
import com.highmobility.autoapi.value.OemTroubleCodeValue;
import com.highmobility.autoapi.value.ServiceStatus;
import com.highmobility.autoapi.value.TirePressure;
import com.highmobility.autoapi.value.TirePressureStatus;
import com.highmobility.autoapi.value.TireTemperature;
import com.highmobility.autoapi.value.TroubleCode;
import com.highmobility.autoapi.value.WheelRpm;
import com.highmobility.autoapi.value.measurement.AngularVelocity;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.autoapi.value.measurement.ElectricPotentialDifference;
import com.highmobility.autoapi.value.measurement.Length;
import com.highmobility.autoapi.value.measurement.Speed;
import com.highmobility.autoapi.value.measurement.Temperature;
import com.highmobility.autoapi.value.measurement.Volume;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;

public class Diagnostics {
    public static final int IDENTIFIER = 51;
    public static final byte PROPERTY_MILEAGE = 1;
    public static final byte PROPERTY_ENGINE_OIL_TEMPERATURE = 2;
    public static final byte PROPERTY_SPEED = 3;
    public static final byte PROPERTY_ENGINE_RPM = 4;
    public static final byte PROPERTY_FUEL_LEVEL = 5;
    public static final byte PROPERTY_ESTIMATED_RANGE = 6;
    public static final byte PROPERTY_WASHER_FLUID_LEVEL = 9;
    public static final byte PROPERTY_BATTERY_VOLTAGE = 11;
    public static final byte PROPERTY_ADBLUE_LEVEL = 12;
    public static final byte PROPERTY_DISTANCE_SINCE_RESET = 13;
    public static final byte PROPERTY_DISTANCE_SINCE_START = 14;
    public static final byte PROPERTY_FUEL_VOLUME = 15;
    public static final byte PROPERTY_ANTI_LOCK_BRAKING = 16;
    public static final byte PROPERTY_ENGINE_COOLANT_TEMPERATURE = 17;
    public static final byte PROPERTY_ENGINE_TOTAL_OPERATING_HOURS = 18;
    public static final byte PROPERTY_ENGINE_TOTAL_FUEL_CONSUMPTION = 19;
    public static final byte PROPERTY_BRAKE_FLUID_LEVEL = 20;
    public static final byte PROPERTY_ENGINE_TORQUE = 21;
    public static final byte PROPERTY_ENGINE_LOAD = 22;
    public static final byte PROPERTY_WHEEL_BASED_SPEED = 23;
    public static final byte PROPERTY_BATTERY_LEVEL = 24;
    public static final byte PROPERTY_CHECK_CONTROL_MESSAGES = 25;
    public static final byte PROPERTY_TIRE_PRESSURES = 26;
    public static final byte PROPERTY_TIRE_TEMPERATURES = 27;
    public static final byte PROPERTY_WHEEL_RPMS = 28;
    public static final byte PROPERTY_TROUBLE_CODES = 29;
    public static final byte PROPERTY_MILEAGE_METERS = 30;
    public static final byte PROPERTY_ODOMETER = 31;
    public static final byte PROPERTY_ENGINE_TOTAL_OPERATING_TIME = 32;
    public static final byte PROPERTY_TIRE_PRESSURE_STATUSES = 33;
    public static final byte PROPERTY_BRAKE_LINING_WEAR_PRE_WARNING = 34;
    public static final byte PROPERTY_ENGINE_OIL_LIFE_REMAINING = 35;
    public static final byte PROPERTY_OEM_TROUBLE_CODE_VALUES = 36;
    public static final byte PROPERTY_DIESEL_EXHAUST_FLUID_RANGE = 37;
    public static final byte PROPERTY_DIESEL_PARTICULATE_FILTER_SOOT_LEVEL = 38;
    public static final byte PROPERTY_CONFIRMED_TROUBLE_CODES = 39;
    public static final byte PROPERTY_DIESEL_EXHAUST_FILTER_STATUS = 40;
    public static final byte PROPERTY_ENGINE_TOTAL_IDLE_OPERATING_TIME = 42;
    public static final byte PROPERTY_ENGINE_OIL_AMOUNT = 43;
    public static final byte PROPERTY_ENGINE_OIL_LEVEL = 44;
    public static final byte PROPERTY_ESTIMATED_SECONDARY_POWERTRAIN_RANGE = 45;
    public static final byte PROPERTY_FUEL_LEVEL_ACCURACY = 46;
    public static final byte PROPERTY_TIRE_PRESSURES_TARGETS = 47;
    public static final byte PROPERTY_TIRE_PRESSURES_DIFFERENCES = 48;
    public static final byte PROPERTY_BACKUP_BATTERY_REMAINING_TIME = 49;
    public static final byte PROPERTY_ENGINE_COOLANT_FLUID_LEVEL = 50;
    public static final byte PROPERTY_ENGINE_OIL_FLUID_LEVEL = 51;
    public static final byte PROPERTY_ENGINE_OIL_PRESSURE_LEVEL = 52;
    public static final byte PROPERTY_ENGINE_TIME_TO_NEXT_SERVICE = 53;
    public static final byte PROPERTY_LOW_VOLTAGE_BATTERY_CHARGE_LEVEL = 54;
    public static final byte PROPERTY_ENGINE_OIL_SERVICE_STATUS = 55;
    public static final byte PROPERTY_PASSENGER_AIRBAG_STATUS = 56;

    public static enum LowVoltageBatteryChargeLevel implements ByteEnum
    {
        OK(0),
        DEACTIVATION_LEVEL_1(1),
        DEACTIVATION_LEVEL_2(2),
        DEACTIVATION_LEVEL_3(3);

        private final byte value;

        public static LowVoltageBatteryChargeLevel fromByte(byte byteValue) throws CommandParseException {
            LowVoltageBatteryChargeLevel[] values = LowVoltageBatteryChargeLevel.values();
            for (int i = 0; i < values.length; ++i) {
                LowVoltageBatteryChargeLevel state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(LowVoltageBatteryChargeLevel.class.getSimpleName(), byteValue));
        }

        private LowVoltageBatteryChargeLevel(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum EngineOilPressureLevel implements ByteEnum
    {
        LOW(0),
        NORMAL(1),
        HIGH(2),
        LOW_SOFT(3),
        LOW_HARD(4),
        NO_SENSOR(5),
        SYSTEM_FAULT(6);

        private final byte value;

        public static EngineOilPressureLevel fromByte(byte byteValue) throws CommandParseException {
            EngineOilPressureLevel[] values = EngineOilPressureLevel.values();
            for (int i = 0; i < values.length; ++i) {
                EngineOilPressureLevel state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(EngineOilPressureLevel.class.getSimpleName(), byteValue));
        }

        private EngineOilPressureLevel(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum FuelLevelAccuracy implements ByteEnum
    {
        MEASURED(0),
        CALCULATED(1);

        private final byte value;

        public static FuelLevelAccuracy fromByte(byte byteValue) throws CommandParseException {
            FuelLevelAccuracy[] values = FuelLevelAccuracy.values();
            for (int i = 0; i < values.length; ++i) {
                FuelLevelAccuracy state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(FuelLevelAccuracy.class.getSimpleName(), byteValue));
        }

        private FuelLevelAccuracy(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<Length> mileage = new Property<Length>(Length.class, 1);
        Property<Temperature> engineOilTemperature = new Property<Temperature>(Temperature.class, 2);
        Property<Speed> speed = new Property<Speed>(Speed.class, 3);
        Property<AngularVelocity> engineRPM = new Property<AngularVelocity>(AngularVelocity.class, 4);
        Property<Double> fuelLevel = new Property<Double>(Double.class, 5);
        Property<Length> estimatedRange = new Property<Length>(Length.class, 6);
        Property<FluidLevel> washerFluidLevel = new Property<FluidLevel>(FluidLevel.class, 9);
        Property<ElectricPotentialDifference> batteryVoltage = new Property<ElectricPotentialDifference>(ElectricPotentialDifference.class, 11);
        Property<Double> adBlueLevel = new Property<Double>(Double.class, 12);
        Property<Length> distanceSinceReset = new Property<Length>(Length.class, 13);
        Property<Length> distanceSinceStart = new Property<Length>(Length.class, 14);
        Property<Volume> fuelVolume = new Property<Volume>(Volume.class, 15);
        Property<ActiveState> antiLockBraking = new Property<ActiveState>(ActiveState.class, 16);
        Property<Temperature> engineCoolantTemperature = new Property<Temperature>(Temperature.class, 17);
        Property<Duration> engineTotalOperatingHours = new Property<Duration>(Duration.class, 18);
        Property<Volume> engineTotalFuelConsumption = new Property<Volume>(Volume.class, 19);
        Property<FluidLevel> brakeFluidLevel = new Property<FluidLevel>(FluidLevel.class, 20);
        Property<Double> engineTorque = new Property<Double>(Double.class, 21);
        Property<Double> engineLoad = new Property<Double>(Double.class, 22);
        Property<Speed> wheelBasedSpeed = new Property<Speed>(Speed.class, 23);
        Property<Double> batteryLevel = new Property<Double>(Double.class, 24);
        List<Property<CheckControlMessage>> checkControlMessages;
        List<Property<TirePressure>> tirePressures;
        List<Property<TireTemperature>> tireTemperatures;
        List<Property<WheelRpm>> wheelRPMs;
        List<Property<TroubleCode>> troubleCodes;
        Property<Length> mileageMeters = new Property<Length>(Length.class, 30);
        Property<Length> odometer = new Property<Length>(Length.class, 31);
        Property<Duration> engineTotalOperatingTime = new Property<Duration>(Duration.class, 32);
        List<Property<TirePressureStatus>> tirePressureStatuses;
        Property<ActiveState> brakeLiningWearPreWarning = new Property<ActiveState>(ActiveState.class, 34);
        Property<Double> engineOilLifeRemaining = new Property<Double>(Double.class, 35);
        List<Property<OemTroubleCodeValue>> oemTroubleCodeValues;
        Property<Length> dieselExhaustFluidRange = new Property<Length>(Length.class, 37);
        Property<Double> dieselParticulateFilterSootLevel = new Property<Double>(Double.class, 38);
        List<Property<ConfirmedTroubleCode>> confirmedTroubleCodes;
        List<Property<DieselExhaustFilterStatus>> dieselExhaustFilterStatus;
        Property<Duration> engineTotalIdleOperatingTime = new Property<Duration>(Duration.class, 42);
        Property<Volume> engineOilAmount = new Property<Volume>(Volume.class, 43);
        Property<Double> engineOilLevel = new Property<Double>(Double.class, 44);
        Property<Length> estimatedSecondaryPowertrainRange = new Property<Length>(Length.class, 45);
        Property<FuelLevelAccuracy> fuelLevelAccuracy = new Property<FuelLevelAccuracy>(FuelLevelAccuracy.class, 46);
        List<Property<TirePressure>> tirePressuresTargets;
        List<Property<TirePressure>> tirePressuresDifferences;
        Property<Duration> backupBatteryRemainingTime = new Property<Duration>(Duration.class, 49);
        Property<FluidLevel> engineCoolantFluidLevel = new Property<FluidLevel>(FluidLevel.class, 50);
        Property<FluidLevel> engineOilFluidLevel = new Property<FluidLevel>(FluidLevel.class, 51);
        Property<EngineOilPressureLevel> engineOilPressureLevel = new Property<EngineOilPressureLevel>(EngineOilPressureLevel.class, 52);
        Property<Duration> engineTimeToNextService = new Property<Duration>(Duration.class, 53);
        Property<LowVoltageBatteryChargeLevel> lowVoltageBatteryChargeLevel = new Property<LowVoltageBatteryChargeLevel>(LowVoltageBatteryChargeLevel.class, 54);
        Property<ServiceStatus> engineOilServiceStatus = new Property<ServiceStatus>(ServiceStatus.class, 55);
        Property<ActiveState> passengerAirbagStatus = new Property<ActiveState>(ActiveState.class, 56);

        @Deprecated
        public Property<Length> getMileage() {
            return this.mileage;
        }

        public Property<Temperature> getEngineOilTemperature() {
            return this.engineOilTemperature;
        }

        public Property<Speed> getSpeed() {
            return this.speed;
        }

        public Property<AngularVelocity> getEngineRPM() {
            return this.engineRPM;
        }

        public Property<Double> getFuelLevel() {
            return this.fuelLevel;
        }

        public Property<Length> getEstimatedRange() {
            return this.estimatedRange;
        }

        public Property<FluidLevel> getWasherFluidLevel() {
            return this.washerFluidLevel;
        }

        public Property<ElectricPotentialDifference> getBatteryVoltage() {
            return this.batteryVoltage;
        }

        public Property<Double> getAdBlueLevel() {
            return this.adBlueLevel;
        }

        public Property<Length> getDistanceSinceReset() {
            return this.distanceSinceReset;
        }

        public Property<Length> getDistanceSinceStart() {
            return this.distanceSinceStart;
        }

        public Property<Volume> getFuelVolume() {
            return this.fuelVolume;
        }

        public Property<ActiveState> getAntiLockBraking() {
            return this.antiLockBraking;
        }

        public Property<Temperature> getEngineCoolantTemperature() {
            return this.engineCoolantTemperature;
        }

        @Deprecated
        public Property<Duration> getEngineTotalOperatingHours() {
            return this.engineTotalOperatingHours;
        }

        public Property<Volume> getEngineTotalFuelConsumption() {
            return this.engineTotalFuelConsumption;
        }

        public Property<FluidLevel> getBrakeFluidLevel() {
            return this.brakeFluidLevel;
        }

        public Property<Double> getEngineTorque() {
            return this.engineTorque;
        }

        public Property<Double> getEngineLoad() {
            return this.engineLoad;
        }

        public Property<Speed> getWheelBasedSpeed() {
            return this.wheelBasedSpeed;
        }

        public Property<Double> getBatteryLevel() {
            return this.batteryLevel;
        }

        public List<Property<CheckControlMessage>> getCheckControlMessages() {
            return this.checkControlMessages;
        }

        public List<Property<TirePressure>> getTirePressures() {
            return this.tirePressures;
        }

        public List<Property<TireTemperature>> getTireTemperatures() {
            return this.tireTemperatures;
        }

        public List<Property<WheelRpm>> getWheelRPMs() {
            return this.wheelRPMs;
        }

        public List<Property<TroubleCode>> getTroubleCodes() {
            return this.troubleCodes;
        }

        @Deprecated
        public Property<Length> getMileageMeters() {
            return this.mileageMeters;
        }

        public Property<Length> getOdometer() {
            return this.odometer;
        }

        public Property<Duration> getEngineTotalOperatingTime() {
            return this.engineTotalOperatingTime;
        }

        public List<Property<TirePressureStatus>> getTirePressureStatuses() {
            return this.tirePressureStatuses;
        }

        public Property<ActiveState> getBrakeLiningWearPreWarning() {
            return this.brakeLiningWearPreWarning;
        }

        public Property<Double> getEngineOilLifeRemaining() {
            return this.engineOilLifeRemaining;
        }

        public List<Property<OemTroubleCodeValue>> getOemTroubleCodeValues() {
            return this.oemTroubleCodeValues;
        }

        public Property<Length> getDieselExhaustFluidRange() {
            return this.dieselExhaustFluidRange;
        }

        public Property<Double> getDieselParticulateFilterSootLevel() {
            return this.dieselParticulateFilterSootLevel;
        }

        public List<Property<ConfirmedTroubleCode>> getConfirmedTroubleCodes() {
            return this.confirmedTroubleCodes;
        }

        public List<Property<DieselExhaustFilterStatus>> getDieselExhaustFilterStatus() {
            return this.dieselExhaustFilterStatus;
        }

        public Property<Duration> getEngineTotalIdleOperatingTime() {
            return this.engineTotalIdleOperatingTime;
        }

        public Property<Volume> getEngineOilAmount() {
            return this.engineOilAmount;
        }

        public Property<Double> getEngineOilLevel() {
            return this.engineOilLevel;
        }

        public Property<Length> getEstimatedSecondaryPowertrainRange() {
            return this.estimatedSecondaryPowertrainRange;
        }

        public Property<FuelLevelAccuracy> getFuelLevelAccuracy() {
            return this.fuelLevelAccuracy;
        }

        public List<Property<TirePressure>> getTirePressuresTargets() {
            return this.tirePressuresTargets;
        }

        public List<Property<TirePressure>> getTirePressuresDifferences() {
            return this.tirePressuresDifferences;
        }

        public Property<Duration> getBackupBatteryRemainingTime() {
            return this.backupBatteryRemainingTime;
        }

        public Property<FluidLevel> getEngineCoolantFluidLevel() {
            return this.engineCoolantFluidLevel;
        }

        public Property<FluidLevel> getEngineOilFluidLevel() {
            return this.engineOilFluidLevel;
        }

        public Property<EngineOilPressureLevel> getEngineOilPressureLevel() {
            return this.engineOilPressureLevel;
        }

        public Property<Duration> getEngineTimeToNextService() {
            return this.engineTimeToNextService;
        }

        public Property<LowVoltageBatteryChargeLevel> getLowVoltageBatteryChargeLevel() {
            return this.lowVoltageBatteryChargeLevel;
        }

        public Property<ServiceStatus> getEngineOilServiceStatus() {
            return this.engineOilServiceStatus;
        }

        public Property<ActiveState> getPassengerAirbagStatus() {
            return this.passengerAirbagStatus;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<CheckControlMessage>> checkControlMessagesBuilder = new ArrayList<Property<CheckControlMessage>>();
            ArrayList<Property<TirePressure>> tirePressuresBuilder = new ArrayList<Property<TirePressure>>();
            ArrayList<Property<TireTemperature>> tireTemperaturesBuilder = new ArrayList<Property<TireTemperature>>();
            ArrayList<Property<WheelRpm>> wheelRPMsBuilder = new ArrayList<Property<WheelRpm>>();
            ArrayList<Property<TroubleCode>> troubleCodesBuilder = new ArrayList<Property<TroubleCode>>();
            ArrayList<Property<TirePressureStatus>> tirePressureStatusesBuilder = new ArrayList<Property<TirePressureStatus>>();
            ArrayList<Property<OemTroubleCodeValue>> oemTroubleCodeValuesBuilder = new ArrayList<Property<OemTroubleCodeValue>>();
            ArrayList<Property<ConfirmedTroubleCode>> confirmedTroubleCodesBuilder = new ArrayList<Property<ConfirmedTroubleCode>>();
            ArrayList<Property<DieselExhaustFilterStatus>> dieselExhaustFilterStatusBuilder = new ArrayList<Property<DieselExhaustFilterStatus>>();
            ArrayList<Property<TirePressure>> tirePressuresTargetsBuilder = new ArrayList<Property<TirePressure>>();
            ArrayList<Property<TirePressure>> tirePressuresDifferencesBuilder = new ArrayList<Property<TirePressure>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.mileage.update(p);
                        }
                        case 2: {
                            return this.engineOilTemperature.update(p);
                        }
                        case 3: {
                            return this.speed.update(p);
                        }
                        case 4: {
                            return this.engineRPM.update(p);
                        }
                        case 5: {
                            return this.fuelLevel.update(p);
                        }
                        case 6: {
                            return this.estimatedRange.update(p);
                        }
                        case 9: {
                            return this.washerFluidLevel.update(p);
                        }
                        case 11: {
                            return this.batteryVoltage.update(p);
                        }
                        case 12: {
                            return this.adBlueLevel.update(p);
                        }
                        case 13: {
                            return this.distanceSinceReset.update(p);
                        }
                        case 14: {
                            return this.distanceSinceStart.update(p);
                        }
                        case 15: {
                            return this.fuelVolume.update(p);
                        }
                        case 16: {
                            return this.antiLockBraking.update(p);
                        }
                        case 17: {
                            return this.engineCoolantTemperature.update(p);
                        }
                        case 18: {
                            return this.engineTotalOperatingHours.update(p);
                        }
                        case 19: {
                            return this.engineTotalFuelConsumption.update(p);
                        }
                        case 20: {
                            return this.brakeFluidLevel.update(p);
                        }
                        case 21: {
                            return this.engineTorque.update(p);
                        }
                        case 22: {
                            return this.engineLoad.update(p);
                        }
                        case 23: {
                            return this.wheelBasedSpeed.update(p);
                        }
                        case 24: {
                            return this.batteryLevel.update(p);
                        }
                        case 25: {
                            Property<CheckControlMessage> checkControlMessage = new Property<CheckControlMessage>(CheckControlMessage.class, p);
                            checkControlMessagesBuilder.add(checkControlMessage);
                            return checkControlMessage;
                        }
                        case 26: {
                            Property<TirePressure> tirePressure = new Property<TirePressure>(TirePressure.class, p);
                            tirePressuresBuilder.add(tirePressure);
                            return tirePressure;
                        }
                        case 27: {
                            Property<TireTemperature> tireTemperature = new Property<TireTemperature>(TireTemperature.class, p);
                            tireTemperaturesBuilder.add(tireTemperature);
                            return tireTemperature;
                        }
                        case 28: {
                            Property<WheelRpm> wheelRpm = new Property<WheelRpm>(WheelRpm.class, p);
                            wheelRPMsBuilder.add(wheelRpm);
                            return wheelRpm;
                        }
                        case 29: {
                            Property<TroubleCode> troubleCode = new Property<TroubleCode>(TroubleCode.class, p);
                            troubleCodesBuilder.add(troubleCode);
                            return troubleCode;
                        }
                        case 30: {
                            return this.mileageMeters.update(p);
                        }
                        case 31: {
                            return this.odometer.update(p);
                        }
                        case 32: {
                            return this.engineTotalOperatingTime.update(p);
                        }
                        case 33: {
                            Property<TirePressureStatus> tirePressureStatus = new Property<TirePressureStatus>(TirePressureStatus.class, p);
                            tirePressureStatusesBuilder.add(tirePressureStatus);
                            return tirePressureStatus;
                        }
                        case 34: {
                            return this.brakeLiningWearPreWarning.update(p);
                        }
                        case 35: {
                            return this.engineOilLifeRemaining.update(p);
                        }
                        case 36: {
                            Property<OemTroubleCodeValue> engineTroubleCodeValue = new Property<OemTroubleCodeValue>(OemTroubleCodeValue.class, p);
                            oemTroubleCodeValuesBuilder.add(engineTroubleCodeValue);
                            return engineTroubleCodeValue;
                        }
                        case 37: {
                            return this.dieselExhaustFluidRange.update(p);
                        }
                        case 38: {
                            return this.dieselParticulateFilterSootLevel.update(p);
                        }
                        case 39: {
                            Property<ConfirmedTroubleCode> confirmedTroubleCode = new Property<ConfirmedTroubleCode>(ConfirmedTroubleCode.class, p);
                            confirmedTroubleCodesBuilder.add(confirmedTroubleCode);
                            return confirmedTroubleCode;
                        }
                        case 40: {
                            Property<DieselExhaustFilterStatus> dieselExhaustFilterStatu = new Property<DieselExhaustFilterStatus>(DieselExhaustFilterStatus.class, p);
                            dieselExhaustFilterStatusBuilder.add(dieselExhaustFilterStatu);
                            return dieselExhaustFilterStatu;
                        }
                        case 42: {
                            return this.engineTotalIdleOperatingTime.update(p);
                        }
                        case 43: {
                            return this.engineOilAmount.update(p);
                        }
                        case 44: {
                            return this.engineOilLevel.update(p);
                        }
                        case 45: {
                            return this.estimatedSecondaryPowertrainRange.update(p);
                        }
                        case 46: {
                            return this.fuelLevelAccuracy.update(p);
                        }
                        case 47: {
                            Property<TirePressure> tirePressureTarget = new Property<TirePressure>(TirePressure.class, p);
                            tirePressuresTargetsBuilder.add(tirePressureTarget);
                            return tirePressureTarget;
                        }
                        case 48: {
                            Property<TirePressure> tirePressureDifference = new Property<TirePressure>(TirePressure.class, p);
                            tirePressuresDifferencesBuilder.add(tirePressureDifference);
                            return tirePressureDifference;
                        }
                        case 49: {
                            return this.backupBatteryRemainingTime.update(p);
                        }
                        case 50: {
                            return this.engineCoolantFluidLevel.update(p);
                        }
                        case 51: {
                            return this.engineOilFluidLevel.update(p);
                        }
                        case 52: {
                            return this.engineOilPressureLevel.update(p);
                        }
                        case 53: {
                            return this.engineTimeToNextService.update(p);
                        }
                        case 54: {
                            return this.lowVoltageBatteryChargeLevel.update(p);
                        }
                        case 55: {
                            return this.engineOilServiceStatus.update(p);
                        }
                        case 56: {
                            return this.passengerAirbagStatus.update(p);
                        }
                    }
                    return null;
                });
            }
            this.checkControlMessages = checkControlMessagesBuilder;
            this.tirePressures = tirePressuresBuilder;
            this.tireTemperatures = tireTemperaturesBuilder;
            this.wheelRPMs = wheelRPMsBuilder;
            this.troubleCodes = troubleCodesBuilder;
            this.tirePressureStatuses = tirePressureStatusesBuilder;
            this.oemTroubleCodeValues = oemTroubleCodeValuesBuilder;
            this.confirmedTroubleCodes = confirmedTroubleCodesBuilder;
            this.dieselExhaustFilterStatus = dieselExhaustFilterStatusBuilder;
            this.tirePressuresTargets = tirePressuresTargetsBuilder;
            this.tirePressuresDifferences = tirePressuresDifferencesBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(51);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            @Deprecated
            public Builder setMileage(Property<Length> mileage) {
                Property<Length> property = mileage.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineOilTemperature(Property<Temperature> engineOilTemperature) {
                Property<Temperature> property = engineOilTemperature.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setSpeed(Property<Speed> speed) {
                Property<Speed> property = speed.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineRPM(Property<AngularVelocity> engineRPM) {
                Property<AngularVelocity> property = engineRPM.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setFuelLevel(Property<Double> fuelLevel) {
                Property<Double> property = fuelLevel.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setEstimatedRange(Property<Length> estimatedRange) {
                Property<Length> property = estimatedRange.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setWasherFluidLevel(Property<FluidLevel> washerFluidLevel) {
                Property<FluidLevel> property = washerFluidLevel.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryVoltage(Property<ElectricPotentialDifference> batteryVoltage) {
                Property<ElectricPotentialDifference> property = batteryVoltage.setIdentifier((byte)11);
                this.addProperty(property);
                return this;
            }

            public Builder setAdBlueLevel(Property<Double> adBlueLevel) {
                Property<Double> property = adBlueLevel.setIdentifier((byte)12);
                this.addProperty(property);
                return this;
            }

            public Builder setDistanceSinceReset(Property<Length> distanceSinceReset) {
                Property<Length> property = distanceSinceReset.setIdentifier((byte)13);
                this.addProperty(property);
                return this;
            }

            public Builder setDistanceSinceStart(Property<Length> distanceSinceStart) {
                Property<Length> property = distanceSinceStart.setIdentifier((byte)14);
                this.addProperty(property);
                return this;
            }

            public Builder setFuelVolume(Property<Volume> fuelVolume) {
                Property<Volume> property = fuelVolume.setIdentifier((byte)15);
                this.addProperty(property);
                return this;
            }

            public Builder setAntiLockBraking(Property<ActiveState> antiLockBraking) {
                Property<ActiveState> property = antiLockBraking.setIdentifier((byte)16);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineCoolantTemperature(Property<Temperature> engineCoolantTemperature) {
                Property<Temperature> property = engineCoolantTemperature.setIdentifier((byte)17);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setEngineTotalOperatingHours(Property<Duration> engineTotalOperatingHours) {
                Property<Duration> property = engineTotalOperatingHours.setIdentifier((byte)18);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineTotalFuelConsumption(Property<Volume> engineTotalFuelConsumption) {
                Property<Volume> property = engineTotalFuelConsumption.setIdentifier((byte)19);
                this.addProperty(property);
                return this;
            }

            public Builder setBrakeFluidLevel(Property<FluidLevel> brakeFluidLevel) {
                Property<FluidLevel> property = brakeFluidLevel.setIdentifier((byte)20);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineTorque(Property<Double> engineTorque) {
                Property<Double> property = engineTorque.setIdentifier((byte)21);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineLoad(Property<Double> engineLoad) {
                Property<Double> property = engineLoad.setIdentifier((byte)22);
                this.addProperty(property);
                return this;
            }

            public Builder setWheelBasedSpeed(Property<Speed> wheelBasedSpeed) {
                Property<Speed> property = wheelBasedSpeed.setIdentifier((byte)23);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryLevel(Property<Double> batteryLevel) {
                Property<Double> property = batteryLevel.setIdentifier((byte)24);
                this.addProperty(property);
                return this;
            }

            public Builder setCheckControlMessages(Property<CheckControlMessage>[] checkControlMessages) {
                for (int i = 0; i < checkControlMessages.length; ++i) {
                    this.addCheckControlMessage(checkControlMessages[i]);
                }
                return this;
            }

            public Builder addCheckControlMessage(Property<CheckControlMessage> checkControlMessage) {
                checkControlMessage.setIdentifier((byte)25);
                this.addProperty(checkControlMessage);
                return this;
            }

            public Builder setTirePressures(Property<TirePressure>[] tirePressures) {
                for (int i = 0; i < tirePressures.length; ++i) {
                    this.addTirePressure(tirePressures[i]);
                }
                return this;
            }

            public Builder addTirePressure(Property<TirePressure> tirePressure) {
                tirePressure.setIdentifier((byte)26);
                this.addProperty(tirePressure);
                return this;
            }

            public Builder setTireTemperatures(Property<TireTemperature>[] tireTemperatures) {
                for (int i = 0; i < tireTemperatures.length; ++i) {
                    this.addTireTemperature(tireTemperatures[i]);
                }
                return this;
            }

            public Builder addTireTemperature(Property<TireTemperature> tireTemperature) {
                tireTemperature.setIdentifier((byte)27);
                this.addProperty(tireTemperature);
                return this;
            }

            public Builder setWheelRPMs(Property<WheelRpm>[] wheelRPMs) {
                for (int i = 0; i < wheelRPMs.length; ++i) {
                    this.addWheelRpm(wheelRPMs[i]);
                }
                return this;
            }

            public Builder addWheelRpm(Property<WheelRpm> wheelRpm) {
                wheelRpm.setIdentifier((byte)28);
                this.addProperty(wheelRpm);
                return this;
            }

            public Builder setTroubleCodes(Property<TroubleCode>[] troubleCodes) {
                for (int i = 0; i < troubleCodes.length; ++i) {
                    this.addTroubleCode(troubleCodes[i]);
                }
                return this;
            }

            public Builder addTroubleCode(Property<TroubleCode> troubleCode) {
                troubleCode.setIdentifier((byte)29);
                this.addProperty(troubleCode);
                return this;
            }

            @Deprecated
            public Builder setMileageMeters(Property<Length> mileageMeters) {
                Property<Length> property = mileageMeters.setIdentifier((byte)30);
                this.addProperty(property);
                return this;
            }

            public Builder setOdometer(Property<Length> odometer) {
                Property<Length> property = odometer.setIdentifier((byte)31);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineTotalOperatingTime(Property<Duration> engineTotalOperatingTime) {
                Property<Duration> property = engineTotalOperatingTime.setIdentifier((byte)32);
                this.addProperty(property);
                return this;
            }

            public Builder setTirePressureStatuses(Property<TirePressureStatus>[] tirePressureStatuses) {
                for (int i = 0; i < tirePressureStatuses.length; ++i) {
                    this.addTirePressureStatus(tirePressureStatuses[i]);
                }
                return this;
            }

            public Builder addTirePressureStatus(Property<TirePressureStatus> tirePressureStatus) {
                tirePressureStatus.setIdentifier((byte)33);
                this.addProperty(tirePressureStatus);
                return this;
            }

            public Builder setBrakeLiningWearPreWarning(Property<ActiveState> brakeLiningWearPreWarning) {
                Property<ActiveState> property = brakeLiningWearPreWarning.setIdentifier((byte)34);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineOilLifeRemaining(Property<Double> engineOilLifeRemaining) {
                Property<Double> property = engineOilLifeRemaining.setIdentifier((byte)35);
                this.addProperty(property);
                return this;
            }

            public Builder setOemTroubleCodeValues(Property<OemTroubleCodeValue>[] oemTroubleCodeValues) {
                for (int i = 0; i < oemTroubleCodeValues.length; ++i) {
                    this.addEngineTroubleCodeValue(oemTroubleCodeValues[i]);
                }
                return this;
            }

            public Builder addEngineTroubleCodeValue(Property<OemTroubleCodeValue> engineTroubleCodeValue) {
                engineTroubleCodeValue.setIdentifier((byte)36);
                this.addProperty(engineTroubleCodeValue);
                return this;
            }

            public Builder setDieselExhaustFluidRange(Property<Length> dieselExhaustFluidRange) {
                Property<Length> property = dieselExhaustFluidRange.setIdentifier((byte)37);
                this.addProperty(property);
                return this;
            }

            public Builder setDieselParticulateFilterSootLevel(Property<Double> dieselParticulateFilterSootLevel) {
                Property<Double> property = dieselParticulateFilterSootLevel.setIdentifier((byte)38);
                this.addProperty(property);
                return this;
            }

            public Builder setConfirmedTroubleCodes(Property<ConfirmedTroubleCode>[] confirmedTroubleCodes) {
                for (int i = 0; i < confirmedTroubleCodes.length; ++i) {
                    this.addConfirmedTroubleCode(confirmedTroubleCodes[i]);
                }
                return this;
            }

            public Builder addConfirmedTroubleCode(Property<ConfirmedTroubleCode> confirmedTroubleCode) {
                confirmedTroubleCode.setIdentifier((byte)39);
                this.addProperty(confirmedTroubleCode);
                return this;
            }

            public Builder setDieselExhaustFilterStatus(Property<DieselExhaustFilterStatus>[] dieselExhaustFilterStatus) {
                for (int i = 0; i < dieselExhaustFilterStatus.length; ++i) {
                    this.addDieselExhaustFilterStatu(dieselExhaustFilterStatus[i]);
                }
                return this;
            }

            public Builder addDieselExhaustFilterStatu(Property<DieselExhaustFilterStatus> dieselExhaustFilterStatu) {
                dieselExhaustFilterStatu.setIdentifier((byte)40);
                this.addProperty(dieselExhaustFilterStatu);
                return this;
            }

            public Builder setEngineTotalIdleOperatingTime(Property<Duration> engineTotalIdleOperatingTime) {
                Property<Duration> property = engineTotalIdleOperatingTime.setIdentifier((byte)42);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineOilAmount(Property<Volume> engineOilAmount) {
                Property<Volume> property = engineOilAmount.setIdentifier((byte)43);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineOilLevel(Property<Double> engineOilLevel) {
                Property<Double> property = engineOilLevel.setIdentifier((byte)44);
                this.addProperty(property);
                return this;
            }

            public Builder setEstimatedSecondaryPowertrainRange(Property<Length> estimatedSecondaryPowertrainRange) {
                Property<Length> property = estimatedSecondaryPowertrainRange.setIdentifier((byte)45);
                this.addProperty(property);
                return this;
            }

            public Builder setFuelLevelAccuracy(Property<FuelLevelAccuracy> fuelLevelAccuracy) {
                Property<FuelLevelAccuracy> property = fuelLevelAccuracy.setIdentifier((byte)46);
                this.addProperty(property);
                return this;
            }

            public Builder setTirePressuresTargets(Property<TirePressure>[] tirePressuresTargets) {
                for (int i = 0; i < tirePressuresTargets.length; ++i) {
                    this.addTirePressureTarget(tirePressuresTargets[i]);
                }
                return this;
            }

            public Builder addTirePressureTarget(Property<TirePressure> tirePressureTarget) {
                tirePressureTarget.setIdentifier((byte)47);
                this.addProperty(tirePressureTarget);
                return this;
            }

            public Builder setTirePressuresDifferences(Property<TirePressure>[] tirePressuresDifferences) {
                for (int i = 0; i < tirePressuresDifferences.length; ++i) {
                    this.addTirePressureDifference(tirePressuresDifferences[i]);
                }
                return this;
            }

            public Builder addTirePressureDifference(Property<TirePressure> tirePressureDifference) {
                tirePressureDifference.setIdentifier((byte)48);
                this.addProperty(tirePressureDifference);
                return this;
            }

            public Builder setBackupBatteryRemainingTime(Property<Duration> backupBatteryRemainingTime) {
                Property<Duration> property = backupBatteryRemainingTime.setIdentifier((byte)49);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineCoolantFluidLevel(Property<FluidLevel> engineCoolantFluidLevel) {
                Property<FluidLevel> property = engineCoolantFluidLevel.setIdentifier((byte)50);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineOilFluidLevel(Property<FluidLevel> engineOilFluidLevel) {
                Property<FluidLevel> property = engineOilFluidLevel.setIdentifier((byte)51);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineOilPressureLevel(Property<EngineOilPressureLevel> engineOilPressureLevel) {
                Property<EngineOilPressureLevel> property = engineOilPressureLevel.setIdentifier((byte)52);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineTimeToNextService(Property<Duration> engineTimeToNextService) {
                Property<Duration> property = engineTimeToNextService.setIdentifier((byte)53);
                this.addProperty(property);
                return this;
            }

            public Builder setLowVoltageBatteryChargeLevel(Property<LowVoltageBatteryChargeLevel> lowVoltageBatteryChargeLevel) {
                Property<LowVoltageBatteryChargeLevel> property = lowVoltageBatteryChargeLevel.setIdentifier((byte)54);
                this.addProperty(property);
                return this;
            }

            public Builder setEngineOilServiceStatus(Property<ServiceStatus> engineOilServiceStatus) {
                Property<ServiceStatus> property = engineOilServiceStatus.setIdentifier((byte)55);
                this.addProperty(property);
                return this;
            }

            public Builder setPassengerAirbagStatus(Property<ActiveState> passengerAirbagStatus) {
                Property<ActiveState> property = passengerAirbagStatus.setIdentifier((byte)56);
                this.addProperty(property);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)51, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)51, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 51);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)51, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)51, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(51);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(51, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(51, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

