/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.DoorPosition;
import com.highmobility.autoapi.value.Location;
import com.highmobility.autoapi.value.Lock;
import com.highmobility.autoapi.value.LockState;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Doors {
    public static final int IDENTIFIER = 32;
    public static final byte PROPERTY_INSIDE_LOCKS = 2;
    public static final byte PROPERTY_LOCKS = 3;
    public static final byte PROPERTY_POSITIONS = 4;
    public static final byte PROPERTY_INSIDE_LOCKS_STATE = 5;
    public static final byte PROPERTY_LOCKS_STATE = 6;

    public static class State
    extends SetCommand {
        List<Property<Lock>> insideLocks;
        List<Property<Lock>> locks;
        List<Property<DoorPosition>> positions;
        Property<LockState> insideLocksState = new Property<LockState>(LockState.class, 5);
        Property<LockState> locksState = new Property<LockState>(LockState.class, 6);

        public List<Property<Lock>> getInsideLocks() {
            return this.insideLocks;
        }

        public List<Property<Lock>> getLocks() {
            return this.locks;
        }

        public List<Property<DoorPosition>> getPositions() {
            return this.positions;
        }

        public Property<LockState> getInsideLocksState() {
            return this.insideLocksState;
        }

        public Property<LockState> getLocksState() {
            return this.locksState;
        }

        @Nullable
        public Property<Lock> getLock(Location doorLocation) {
            for (Property<Lock> outsideLockState : this.locks) {
                if (outsideLockState.getValue() == null || outsideLockState.getValue().getLocation() != doorLocation) continue;
                return outsideLockState;
            }
            return null;
        }

        @Nullable
        public Property<Lock> getInsideLock(Location doorLocation) {
            for (Property<Lock> insideLockState : this.insideLocks) {
                if (insideLockState.getValue() == null || insideLockState.getValue().getLocation() != doorLocation) continue;
                return insideLockState;
            }
            return null;
        }

        @Nullable
        public Property<DoorPosition> getPosition(DoorPosition.Location doorLocation) {
            for (Property<DoorPosition> position : this.positions) {
                if (position.getValue() == null || position.getValue().getLocation() != doorLocation) continue;
                return position;
            }
            return null;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<Lock>> insideLocksBuilder = new ArrayList<Property<Lock>>();
            ArrayList<Property<Lock>> locksBuilder = new ArrayList<Property<Lock>>();
            ArrayList<Property<DoorPosition>> positionsBuilder = new ArrayList<Property<DoorPosition>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            Property<Lock> insideLock = new Property<Lock>(Lock.class, p);
                            insideLocksBuilder.add(insideLock);
                            return insideLock;
                        }
                        case 3: {
                            Property<Lock> lock = new Property<Lock>(Lock.class, p);
                            locksBuilder.add(lock);
                            return lock;
                        }
                        case 4: {
                            Property<DoorPosition> position = new Property<DoorPosition>(DoorPosition.class, p);
                            positionsBuilder.add(position);
                            return position;
                        }
                        case 5: {
                            return this.insideLocksState.update(p);
                        }
                        case 6: {
                            return this.locksState.update(p);
                        }
                    }
                    return null;
                });
            }
            this.insideLocks = insideLocksBuilder;
            this.locks = locksBuilder;
            this.positions = positionsBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(32);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setInsideLocks(Property<Lock>[] insideLocks) {
                for (int i = 0; i < insideLocks.length; ++i) {
                    this.addInsideLock(insideLocks[i]);
                }
                return this;
            }

            public Builder addInsideLock(Property<Lock> insideLock) {
                insideLock.setIdentifier((byte)2);
                this.addProperty(insideLock);
                return this;
            }

            public Builder setLocks(Property<Lock>[] locks) {
                for (int i = 0; i < locks.length; ++i) {
                    this.addLock(locks[i]);
                }
                return this;
            }

            public Builder addLock(Property<Lock> lock) {
                lock.setIdentifier((byte)3);
                this.addProperty(lock);
                return this;
            }

            public Builder setPositions(Property<DoorPosition>[] positions) {
                for (int i = 0; i < positions.length; ++i) {
                    this.addPosition(positions[i]);
                }
                return this;
            }

            public Builder addPosition(Property<DoorPosition> position) {
                position.setIdentifier((byte)4);
                this.addProperty(position);
                return this;
            }

            public Builder setInsideLocksState(Property<LockState> insideLocksState) {
                Property<LockState> property = insideLocksState.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setLocksState(Property<LockState> locksState) {
                Property<LockState> property = locksState.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class LockUnlockDoors
    extends SetCommand {
        Property<LockState> locksState = new Property<LockState>(LockState.class, 6);

        public Property<LockState> getLocksState() {
            return this.locksState;
        }

        public LockUnlockDoors(LockState locksState) {
            super(32);
            this.addProperty(this.locksState.update(locksState));
            this.createBytes();
        }

        LockUnlockDoors(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 6) {
                        return this.locksState.update(p);
                    }
                    return null;
                });
            }
            if (this.locksState.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)32, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)32, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 32);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)32, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)32, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(32);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(32, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(32, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

