/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.HmkitVersion;
import com.highmobility.value.Bytes;

public class FirmwareVersion {
    public static final int IDENTIFIER = 3;
    public static final byte PROPERTY_HMKIT_VERSION = 1;
    public static final byte PROPERTY_HMKIT_BUILD_NAME = 2;
    public static final byte PROPERTY_APPLICATION_VERSION = 3;

    public static class State
    extends SetCommand {
        Property<HmkitVersion> hmKitVersion = new Property<HmkitVersion>(HmkitVersion.class, 1);
        Property<String> hmKitBuildName = new Property<String>(String.class, 2);
        Property<String> applicationVersion = new Property<String>(String.class, 3);

        public Property<HmkitVersion> getHmKitVersion() {
            return this.hmKitVersion;
        }

        public Property<String> getHmKitBuildName() {
            return this.hmKitBuildName;
        }

        public Property<String> getApplicationVersion() {
            return this.applicationVersion;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.hmKitVersion.update(p);
                        }
                        case 2: {
                            return this.hmKitBuildName.update(p);
                        }
                        case 3: {
                            return this.applicationVersion.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(3);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setHmKitVersion(Property<HmkitVersion> hmKitVersion) {
                Property<HmkitVersion> property = hmKitVersion.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setHmKitBuildName(Property<String> hmKitBuildName) {
                Property<String> property = hmKitBuildName.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setApplicationVersion(Property<String> applicationVersion) {
                Property<String> property = applicationVersion.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetFirmwareVersionProperties
    extends GetCommand<State> {
        public GetFirmwareVersionProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)3, propertyIdentifiers);
        }

        public GetFirmwareVersionProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)3, new Bytes(propertyIdentifiers));
        }

        GetFirmwareVersionProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetFirmwareVersion
    extends GetCommand<State> {
        public GetFirmwareVersion() {
            super(State.class, 3);
        }

        public GetFirmwareVersion(Bytes propertyIdentifiers) {
            super(State.class, (Integer)3, propertyIdentifiers);
        }

        public GetFirmwareVersion(byte ... propertyIdentifiers) {
            super(State.class, (Integer)3, new Bytes(propertyIdentifiers));
        }

        GetFirmwareVersion(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }
}

