/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.LockState;
import com.highmobility.autoapi.value.Position;
import com.highmobility.value.Bytes;
import javax.annotation.Nullable;

public class Fueling {
    public static final int IDENTIFIER = 64;
    public static final byte PROPERTY_GAS_FLAP_LOCK = 2;
    public static final byte PROPERTY_GAS_FLAP_POSITION = 3;

    public static class State
    extends SetCommand {
        Property<LockState> gasFlapLock = new Property<LockState>(LockState.class, 2);
        Property<Position> gasFlapPosition = new Property<Position>(Position.class, 3);

        public Property<LockState> getGasFlapLock() {
            return this.gasFlapLock;
        }

        public Property<Position> getGasFlapPosition() {
            return this.gasFlapPosition;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            return this.gasFlapLock.update(p);
                        }
                        case 3: {
                            return this.gasFlapPosition.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(64);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setGasFlapLock(Property<LockState> gasFlapLock) {
                Property<LockState> property = gasFlapLock.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setGasFlapPosition(Property<Position> gasFlapPosition) {
                Property<Position> property = gasFlapPosition.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class ControlGasFlap
    extends SetCommand {
        Property<LockState> gasFlapLock = new Property<LockState>(LockState.class, 2);
        Property<Position> gasFlapPosition = new Property<Position>(Position.class, 3);

        public Property<LockState> getGasFlapLock() {
            return this.gasFlapLock;
        }

        public Property<Position> getGasFlapPosition() {
            return this.gasFlapPosition;
        }

        public ControlGasFlap(@Nullable LockState gasFlapLock, @Nullable Position gasFlapPosition) {
            super(64);
            this.addProperty(this.gasFlapLock.update(gasFlapLock));
            this.addProperty(this.gasFlapPosition.update(gasFlapPosition));
            if (this.gasFlapLock.getValue() == null && this.gasFlapPosition.getValue() == null) {
                throw new IllegalArgumentException();
            }
            this.createBytes();
        }

        ControlGasFlap(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            return this.gasFlapLock.update(p);
                        }
                        case 3: {
                            return this.gasFlapPosition.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.gasFlapLock.getValue() == null && this.gasFlapPosition.getValue() == null) {
                throw new PropertyParseException(this.optionalPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetGasFlapProperties
    extends GetCommand<State> {
        public GetGasFlapProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)64, propertyIdentifiers);
        }

        public GetGasFlapProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)64, new Bytes(propertyIdentifiers));
        }

        GetGasFlapProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetGasFlapState
    extends GetCommand<State> {
        public GetGasFlapState() {
            super(State.class, 64);
        }

        public GetGasFlapState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)64, propertyIdentifiers);
        }

        public GetGasFlapState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)64, new Bytes(propertyIdentifiers));
        }

        GetGasFlapState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetGasFlapStateAvailability
    extends GetAvailabilityCommand {
        public GetGasFlapStateAvailability() {
            super(64);
        }

        public GetGasFlapStateAvailability(Bytes propertyIdentifiers) {
            super(64, propertyIdentifiers);
        }

        public GetGasFlapStateAvailability(byte ... propertyIdentifiers) {
            super(64, new Bytes(propertyIdentifiers));
        }

        GetGasFlapStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

