/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.autoapi.value.Coordinates;
import com.highmobility.autoapi.value.EnabledState;
import com.highmobility.autoapi.value.NetworkSecurity;
import com.highmobility.autoapi.value.PriceTariff;
import com.highmobility.autoapi.value.measurement.ElectricCurrent;
import com.highmobility.autoapi.value.measurement.Power;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class HomeCharger {
    public static final int IDENTIFIER = 96;
    public static final byte PROPERTY_CHARGING_STATUS = 1;
    public static final byte PROPERTY_AUTHENTICATION_MECHANISM = 2;
    public static final byte PROPERTY_PLUG_TYPE = 3;
    public static final byte PROPERTY_CHARGING_POWER_KW = 4;
    public static final byte PROPERTY_SOLAR_CHARGING = 5;
    public static final byte PROPERTY_WI_FI_HOTSPOT_ENABLED = 8;
    public static final byte PROPERTY_WI_FI_HOTSPOT_SSID = 9;
    public static final byte PROPERTY_WI_FI_HOTSPOT_SECURITY = 10;
    public static final byte PROPERTY_WI_FI_HOTSPOT_PASSWORD = 11;
    public static final byte PROPERTY_AUTHENTICATION_STATE = 13;
    public static final byte PROPERTY_CHARGE_CURRENT = 14;
    public static final byte PROPERTY_MAXIMUM_CHARGE_CURRENT = 15;
    public static final byte PROPERTY_MINIMUM_CHARGE_CURRENT = 16;
    public static final byte PROPERTY_COORDINATES = 17;
    public static final byte PROPERTY_PRICE_TARIFFS = 18;
    public static final byte PROPERTY_CHARGING_POWER = 19;

    public static enum AuthenticationState implements ByteEnum
    {
        UNAUTHENTICATED(0),
        AUTHENTICATED(1);

        private final byte value;

        public static AuthenticationState fromByte(byte byteValue) throws CommandParseException {
            AuthenticationState[] values = AuthenticationState.values();
            for (int i = 0; i < values.length; ++i) {
                AuthenticationState state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(AuthenticationState.class.getSimpleName(), byteValue));
        }

        private AuthenticationState(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum PlugType implements ByteEnum
    {
        TYPE_1(0),
        TYPE_2(1),
        CCS(2),
        CHADEMO(3);

        private final byte value;

        public static PlugType fromByte(byte byteValue) throws CommandParseException {
            PlugType[] values = PlugType.values();
            for (int i = 0; i < values.length; ++i) {
                PlugType state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(PlugType.class.getSimpleName(), byteValue));
        }

        private PlugType(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum AuthenticationMechanism implements ByteEnum
    {
        PIN(0),
        APP(1);

        private final byte value;

        public static AuthenticationMechanism fromByte(byte byteValue) throws CommandParseException {
            AuthenticationMechanism[] values = AuthenticationMechanism.values();
            for (int i = 0; i < values.length; ++i) {
                AuthenticationMechanism state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(AuthenticationMechanism.class.getSimpleName(), byteValue));
        }

        private AuthenticationMechanism(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum ChargingStatus implements ByteEnum
    {
        DISCONNECTED(0),
        PLUGGED_IN(1),
        CHARGING(2);

        private final byte value;

        public static ChargingStatus fromByte(byte byteValue) throws CommandParseException {
            ChargingStatus[] values = ChargingStatus.values();
            for (int i = 0; i < values.length; ++i) {
                ChargingStatus state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(ChargingStatus.class.getSimpleName(), byteValue));
        }

        private ChargingStatus(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<ChargingStatus> chargingStatus = new Property<ChargingStatus>(ChargingStatus.class, 1);
        Property<AuthenticationMechanism> authenticationMechanism = new Property<AuthenticationMechanism>(AuthenticationMechanism.class, 2);
        Property<PlugType> plugType = new Property<PlugType>(PlugType.class, 3);
        Property<Power> chargingPowerKW = new Property<Power>(Power.class, 4);
        Property<ActiveState> solarCharging = new Property<ActiveState>(ActiveState.class, 5);
        Property<EnabledState> wifiHotspotEnabled = new Property<EnabledState>(EnabledState.class, 8);
        Property<String> wifiHotspotSSID = new Property<String>(String.class, 9);
        Property<NetworkSecurity> wiFiHotspotSecurity = new Property<NetworkSecurity>(NetworkSecurity.class, 10);
        Property<String> wiFiHotspotPassword = new Property<String>(String.class, 11);
        Property<AuthenticationState> authenticationState = new Property<AuthenticationState>(AuthenticationState.class, 13);
        Property<ElectricCurrent> chargeCurrent = new Property<ElectricCurrent>(ElectricCurrent.class, 14);
        Property<ElectricCurrent> maximumChargeCurrent = new Property<ElectricCurrent>(ElectricCurrent.class, 15);
        Property<ElectricCurrent> minimumChargeCurrent = new Property<ElectricCurrent>(ElectricCurrent.class, 16);
        Property<Coordinates> coordinates = new Property<Coordinates>(Coordinates.class, 17);
        List<Property<PriceTariff>> priceTariffs;
        Property<Power> chargingPower = new Property<Power>(Power.class, 19);

        public Property<ChargingStatus> getChargingStatus() {
            return this.chargingStatus;
        }

        public Property<AuthenticationMechanism> getAuthenticationMechanism() {
            return this.authenticationMechanism;
        }

        public Property<PlugType> getPlugType() {
            return this.plugType;
        }

        @Deprecated
        public Property<Power> getChargingPowerKW() {
            return this.chargingPowerKW;
        }

        public Property<ActiveState> getSolarCharging() {
            return this.solarCharging;
        }

        public Property<EnabledState> getWifiHotspotEnabled() {
            return this.wifiHotspotEnabled;
        }

        public Property<String> getWifiHotspotSSID() {
            return this.wifiHotspotSSID;
        }

        public Property<NetworkSecurity> getWiFiHotspotSecurity() {
            return this.wiFiHotspotSecurity;
        }

        public Property<String> getWiFiHotspotPassword() {
            return this.wiFiHotspotPassword;
        }

        public Property<AuthenticationState> getAuthenticationState() {
            return this.authenticationState;
        }

        public Property<ElectricCurrent> getChargeCurrent() {
            return this.chargeCurrent;
        }

        public Property<ElectricCurrent> getMaximumChargeCurrent() {
            return this.maximumChargeCurrent;
        }

        public Property<ElectricCurrent> getMinimumChargeCurrent() {
            return this.minimumChargeCurrent;
        }

        public Property<Coordinates> getCoordinates() {
            return this.coordinates;
        }

        public List<Property<PriceTariff>> getPriceTariffs() {
            return this.priceTariffs;
        }

        public Property<Power> getChargingPower() {
            return this.chargingPower;
        }

        @Nullable
        public Property<PriceTariff> getPriceTariff(PriceTariff.PricingType pricingType) {
            if (this.priceTariffs != null) {
                for (Property<PriceTariff> tariff : this.priceTariffs) {
                    if (tariff.getValue() == null || tariff.getValue().getPricingType() != pricingType) continue;
                    return tariff;
                }
            }
            return null;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<PriceTariff>> priceTariffsBuilder = new ArrayList<Property<PriceTariff>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.chargingStatus.update(p);
                        }
                        case 2: {
                            return this.authenticationMechanism.update(p);
                        }
                        case 3: {
                            return this.plugType.update(p);
                        }
                        case 4: {
                            return this.chargingPowerKW.update(p);
                        }
                        case 5: {
                            return this.solarCharging.update(p);
                        }
                        case 8: {
                            return this.wifiHotspotEnabled.update(p);
                        }
                        case 9: {
                            return this.wifiHotspotSSID.update(p);
                        }
                        case 10: {
                            return this.wiFiHotspotSecurity.update(p);
                        }
                        case 11: {
                            return this.wiFiHotspotPassword.update(p);
                        }
                        case 13: {
                            return this.authenticationState.update(p);
                        }
                        case 14: {
                            return this.chargeCurrent.update(p);
                        }
                        case 15: {
                            return this.maximumChargeCurrent.update(p);
                        }
                        case 16: {
                            return this.minimumChargeCurrent.update(p);
                        }
                        case 17: {
                            return this.coordinates.update(p);
                        }
                        case 18: {
                            Property<PriceTariff> priceTariff = new Property<PriceTariff>(PriceTariff.class, p);
                            priceTariffsBuilder.add(priceTariff);
                            return priceTariff;
                        }
                        case 19: {
                            return this.chargingPower.update(p);
                        }
                    }
                    return null;
                });
            }
            this.priceTariffs = priceTariffsBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(96);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setChargingStatus(Property<ChargingStatus> chargingStatus) {
                Property<ChargingStatus> property = chargingStatus.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setAuthenticationMechanism(Property<AuthenticationMechanism> authenticationMechanism) {
                Property<AuthenticationMechanism> property = authenticationMechanism.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setPlugType(Property<PlugType> plugType) {
                Property<PlugType> property = plugType.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setChargingPowerKW(Property<Power> chargingPowerKW) {
                Property<Power> property = chargingPowerKW.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setSolarCharging(Property<ActiveState> solarCharging) {
                Property<ActiveState> property = solarCharging.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setWifiHotspotEnabled(Property<EnabledState> wifiHotspotEnabled) {
                Property<EnabledState> property = wifiHotspotEnabled.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setWifiHotspotSSID(Property<String> wifiHotspotSSID) {
                Property<String> property = wifiHotspotSSID.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            public Builder setWiFiHotspotSecurity(Property<NetworkSecurity> wiFiHotspotSecurity) {
                Property<NetworkSecurity> property = wiFiHotspotSecurity.setIdentifier((byte)10);
                this.addProperty(property);
                return this;
            }

            public Builder setWiFiHotspotPassword(Property<String> wiFiHotspotPassword) {
                Property<String> property = wiFiHotspotPassword.setIdentifier((byte)11);
                this.addProperty(property);
                return this;
            }

            public Builder setAuthenticationState(Property<AuthenticationState> authenticationState) {
                Property<AuthenticationState> property = authenticationState.setIdentifier((byte)13);
                this.addProperty(property);
                return this;
            }

            public Builder setChargeCurrent(Property<ElectricCurrent> chargeCurrent) {
                Property<ElectricCurrent> property = chargeCurrent.setIdentifier((byte)14);
                this.addProperty(property);
                return this;
            }

            public Builder setMaximumChargeCurrent(Property<ElectricCurrent> maximumChargeCurrent) {
                Property<ElectricCurrent> property = maximumChargeCurrent.setIdentifier((byte)15);
                this.addProperty(property);
                return this;
            }

            public Builder setMinimumChargeCurrent(Property<ElectricCurrent> minimumChargeCurrent) {
                Property<ElectricCurrent> property = minimumChargeCurrent.setIdentifier((byte)16);
                this.addProperty(property);
                return this;
            }

            public Builder setCoordinates(Property<Coordinates> coordinates) {
                Property<Coordinates> property = coordinates.setIdentifier((byte)17);
                this.addProperty(property);
                return this;
            }

            public Builder setPriceTariffs(Property<PriceTariff>[] priceTariffs) {
                for (int i = 0; i < priceTariffs.length; ++i) {
                    this.addPriceTariff(priceTariffs[i]);
                }
                return this;
            }

            public Builder addPriceTariff(Property<PriceTariff> priceTariff) {
                priceTariff.setIdentifier((byte)18);
                this.addProperty(priceTariff);
                return this;
            }

            public Builder setChargingPower(Property<Power> chargingPower) {
                Property<Power> property = chargingPower.setIdentifier((byte)19);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class AuthenticateExpire
    extends SetCommand {
        Property<AuthenticationState> authenticationState = new Property<AuthenticationState>(AuthenticationState.class, 13);

        public Property<AuthenticationState> getAuthenticationState() {
            return this.authenticationState;
        }

        public AuthenticateExpire(AuthenticationState authenticationState) {
            super(96);
            this.addProperty(this.authenticationState.update(authenticationState));
            this.createBytes();
        }

        AuthenticateExpire(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 13) {
                        return this.authenticationState.update(p);
                    }
                    return null;
                });
            }
            if (this.authenticationState.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class EnableDisableWiFiHotspot
    extends SetCommand {
        Property<EnabledState> wifiHotspotEnabled = new Property<EnabledState>(EnabledState.class, 8);

        public Property<EnabledState> getWifiHotspotEnabled() {
            return this.wifiHotspotEnabled;
        }

        public EnableDisableWiFiHotspot(EnabledState wifiHotspotEnabled) {
            super(96);
            this.addProperty(this.wifiHotspotEnabled.update(wifiHotspotEnabled));
            this.createBytes();
        }

        EnableDisableWiFiHotspot(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 8) {
                        return this.wifiHotspotEnabled.update(p);
                    }
                    return null;
                });
            }
            if (this.wifiHotspotEnabled.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class ActivateDeactivateSolarCharging
    extends SetCommand {
        Property<ActiveState> solarCharging = new Property<ActiveState>(ActiveState.class, 5);

        public Property<ActiveState> getSolarCharging() {
            return this.solarCharging;
        }

        public ActivateDeactivateSolarCharging(ActiveState solarCharging) {
            super(96);
            this.addProperty(this.solarCharging.update(solarCharging));
            this.createBytes();
        }

        ActivateDeactivateSolarCharging(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 5) {
                        return this.solarCharging.update(p);
                    }
                    return null;
                });
            }
            if (this.solarCharging.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class SetPriceTariffs
    extends SetCommand {
        List<Property<PriceTariff>> priceTariffs;

        public List<Property<PriceTariff>> getPriceTariffs() {
            return this.priceTariffs;
        }

        public SetPriceTariffs(List<PriceTariff> priceTariffs) {
            super(96);
            ArrayList<Property<PriceTariff>> priceTariffsBuilder = new ArrayList<Property<PriceTariff>>();
            if (priceTariffs != null) {
                for (PriceTariff priceTariff : priceTariffs) {
                    Property<PriceTariff> prop = new Property<PriceTariff>(18, priceTariff);
                    priceTariffsBuilder.add(prop);
                    this.addProperty(prop);
                }
            }
            this.priceTariffs = priceTariffsBuilder;
            this.createBytes();
        }

        SetPriceTariffs(byte[] bytes) throws PropertyParseException {
            super(bytes);
            ArrayList<Property<PriceTariff>> priceTariffsBuilder = new ArrayList<Property<PriceTariff>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 18) {
                        Property<PriceTariff> priceTariff = new Property<PriceTariff>(PriceTariff.class, p);
                        priceTariffsBuilder.add(priceTariff);
                        return priceTariff;
                    }
                    return null;
                });
            }
            this.priceTariffs = priceTariffsBuilder;
            if (this.priceTariffs.size() == 0) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class SetChargeCurrent
    extends SetCommand {
        Property<ElectricCurrent> chargeCurrent = new Property<ElectricCurrent>(ElectricCurrent.class, 14);

        public Property<ElectricCurrent> getChargeCurrent() {
            return this.chargeCurrent;
        }

        public SetChargeCurrent(ElectricCurrent chargeCurrent) {
            super(96);
            this.addProperty(this.chargeCurrent.update(chargeCurrent));
            this.createBytes();
        }

        SetChargeCurrent(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 14) {
                        return this.chargeCurrent.update(p);
                    }
                    return null;
                });
            }
            if (this.chargeCurrent.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)96, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)96, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 96);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)96, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)96, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(96);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(96, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(96, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

