/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyInteger;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.value.Bytes;
import javax.annotation.Nullable;

public class HonkHornFlashLights {
    public static final int IDENTIFIER = 38;
    public static final byte PROPERTY_FLASHERS = 1;
    public static final byte PROPERTY_HONK_SECONDS = 2;
    public static final byte PROPERTY_FLASH_TIMES = 3;
    public static final byte PROPERTY_EMERGENCY_FLASHERS_STATE = 4;
    public static final byte PROPERTY_HONK_TIME = 5;

    public static enum Flashers implements ByteEnum
    {
        INACTIVE(0),
        EMERGENCY_FLASHER_ACTIVE(1),
        LEFT_FLASHER_ACTIVE(2),
        RIGHT_FLASHER_ACTIVE(3);

        private final byte value;

        public static Flashers fromByte(byte byteValue) throws CommandParseException {
            Flashers[] values = Flashers.values();
            for (int i = 0; i < values.length; ++i) {
                Flashers state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Flashers.class.getSimpleName(), byteValue));
        }

        private Flashers(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<Flashers> flashers = new Property<Flashers>(Flashers.class, 1);

        public Property<Flashers> getFlashers() {
            return this.flashers;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.flashers.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(38);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setFlashers(Property<Flashers> flashers) {
                Property<Flashers> property = flashers.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class ActivateDeactivateEmergencyFlasher
    extends SetCommand {
        Property<ActiveState> emergencyFlashersState = new Property<ActiveState>(ActiveState.class, 4);

        public Property<ActiveState> getEmergencyFlashersState() {
            return this.emergencyFlashersState;
        }

        public ActivateDeactivateEmergencyFlasher(ActiveState emergencyFlashersState) {
            super(38);
            this.addProperty(this.emergencyFlashersState.update(emergencyFlashersState));
            this.createBytes();
        }

        ActivateDeactivateEmergencyFlasher(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 4) {
                        return this.emergencyFlashersState.update(p);
                    }
                    return null;
                });
            }
            if (this.emergencyFlashersState.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class HonkFlash
    extends SetCommand {
        PropertyInteger flashTimes = new PropertyInteger(3, false);
        Property<Duration> honkTime = new Property<Duration>(Duration.class, 5);

        public PropertyInteger getFlashTimes() {
            return this.flashTimes;
        }

        public Property<Duration> getHonkTime() {
            return this.honkTime;
        }

        public HonkFlash(@Nullable Integer flashTimes, @Nullable Duration honkTime) {
            super(38);
            this.addProperty(this.flashTimes.update(false, 1, flashTimes));
            this.addProperty(this.honkTime.update(honkTime));
            if (this.flashTimes.getValue() == null && this.honkTime.getValue() == null) {
                throw new IllegalArgumentException();
            }
            this.createBytes();
        }

        HonkFlash(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 3: {
                            return this.flashTimes.update(p);
                        }
                        case 5: {
                            return this.honkTime.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.flashTimes.getValue() == null && this.honkTime.getValue() == null) {
                throw new PropertyParseException(this.optionalPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetFlashersProperties
    extends GetCommand<State> {
        public GetFlashersProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)38, propertyIdentifiers);
        }

        public GetFlashersProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)38, new Bytes(propertyIdentifiers));
        }

        GetFlashersProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetFlashersState
    extends GetCommand<State> {
        public GetFlashersState() {
            super(State.class, 38);
        }

        public GetFlashersState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)38, propertyIdentifiers);
        }

        public GetFlashersState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)38, new Bytes(propertyIdentifiers));
        }

        GetFlashersState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetFlashersStateAvailability
    extends GetAvailabilityCommand {
        public GetFlashersStateAvailability() {
            super(38);
        }

        public GetFlashersStateAvailability(Bytes propertyIdentifiers) {
            super(38, propertyIdentifiers);
        }

        public GetFlashersStateAvailability(byte ... propertyIdentifiers) {
            super(38, new Bytes(propertyIdentifiers));
        }

        GetFlashersStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

