/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.LockSafety;
import com.highmobility.autoapi.value.LockState;
import com.highmobility.value.Bytes;

public class Hood {
    public static final int IDENTIFIER = 103;
    public static final byte PROPERTY_POSITION = 1;
    public static final byte PROPERTY_LOCK = 2;
    public static final byte PROPERTY_LOCK_SAFETY = 3;

    public static enum Position implements ByteEnum
    {
        CLOSED(0),
        OPEN(1),
        INTERMEDIATE(2);

        private final byte value;

        public static Position fromByte(byte byteValue) throws CommandParseException {
            Position[] values = Position.values();
            for (int i = 0; i < values.length; ++i) {
                Position state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Position.class.getSimpleName(), byteValue));
        }

        private Position(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<Position> position = new Property<Position>(Position.class, 1);
        Property<LockState> lock = new Property<LockState>(LockState.class, 2);
        Property<LockSafety> lockSafety = new Property<LockSafety>(LockSafety.class, 3);

        public Property<Position> getPosition() {
            return this.position;
        }

        public Property<LockState> getLock() {
            return this.lock;
        }

        public Property<LockSafety> getLockSafety() {
            return this.lockSafety;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.position.update(p);
                        }
                        case 2: {
                            return this.lock.update(p);
                        }
                        case 3: {
                            return this.lockSafety.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(103);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setPosition(Property<Position> position) {
                Property<Position> property = position.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setLock(Property<LockState> lock) {
                Property<LockState> property = lock.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setLockSafety(Property<LockSafety> lockSafety) {
                Property<LockSafety> property = lockSafety.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)103, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)103, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 103);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)103, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)103, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(103);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(103, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(103, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

