/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.measurement.Illuminance;
import com.highmobility.value.Bytes;

public class LightConditions {
    public static final int IDENTIFIER = 84;
    public static final byte PROPERTY_OUTSIDE_LIGHT = 1;
    public static final byte PROPERTY_INSIDE_LIGHT = 2;

    public static class State
    extends SetCommand {
        Property<Illuminance> outsideLight = new Property<Illuminance>(Illuminance.class, 1);
        Property<Illuminance> insideLight = new Property<Illuminance>(Illuminance.class, 2);

        public Property<Illuminance> getOutsideLight() {
            return this.outsideLight;
        }

        public Property<Illuminance> getInsideLight() {
            return this.insideLight;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.outsideLight.update(p);
                        }
                        case 2: {
                            return this.insideLight.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(84);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setOutsideLight(Property<Illuminance> outsideLight) {
                Property<Illuminance> property = outsideLight.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setInsideLight(Property<Illuminance> insideLight) {
                Property<Illuminance> property = insideLight.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetLightConditionsProperties
    extends GetCommand<State> {
        public GetLightConditionsProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)84, propertyIdentifiers);
        }

        public GetLightConditionsProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)84, new Bytes(propertyIdentifiers));
        }

        GetLightConditionsProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetLightConditions
    extends GetCommand<State> {
        public GetLightConditions() {
            super(State.class, 84);
        }

        public GetLightConditions(Bytes propertyIdentifiers) {
            super(State.class, (Integer)84, propertyIdentifiers);
        }

        public GetLightConditions(byte ... propertyIdentifiers) {
            super(State.class, (Integer)84, new Bytes(propertyIdentifiers));
        }

        GetLightConditions(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetLightConditionsAvailability
    extends GetAvailabilityCommand {
        public GetLightConditionsAvailability() {
            super(84);
        }

        public GetLightConditionsAvailability(Bytes propertyIdentifiers) {
            super(84, propertyIdentifiers);
        }

        public GetLightConditionsAvailability(byte ... propertyIdentifiers) {
            super(84, new Bytes(propertyIdentifiers));
        }

        GetLightConditionsAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

