/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyInteger;
import com.highmobility.autoapi.value.BrakeServiceDueDate;
import com.highmobility.autoapi.value.BrakeServiceRemainingDistance;
import com.highmobility.autoapi.value.BrakeServiceStatus;
import com.highmobility.autoapi.value.ConditionBasedService;
import com.highmobility.autoapi.value.ServiceStatus;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.autoapi.value.measurement.Length;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Maintenance {
    public static final int IDENTIFIER = 52;
    public static final byte PROPERTY_DAYS_TO_NEXT_SERVICE = 1;
    public static final byte PROPERTY_KILOMETERS_TO_NEXT_SERVICE = 2;
    public static final byte PROPERTY_CBS_REPORTS_COUNT = 3;
    public static final byte PROPERTY_MONTHS_TO_EXHAUST_INSPECTION = 4;
    public static final byte PROPERTY_TELESERVICE_AVAILABILITY = 5;
    public static final byte PROPERTY_SERVICE_DISTANCE_THRESHOLD = 6;
    public static final byte PROPERTY_SERVICE_TIME_THRESHOLD = 7;
    public static final byte PROPERTY_AUTOMATIC_TELESERVICE_CALL_DATE = 8;
    public static final byte PROPERTY_TELESERVICE_BATTERY_CALL_DATE = 9;
    public static final byte PROPERTY_NEXT_INSPECTION_DATE = 10;
    public static final byte PROPERTY_CONDITION_BASED_SERVICES = 11;
    public static final byte PROPERTY_BRAKE_FLUID_CHANGE_DATE = 12;
    public static final byte PROPERTY_TIME_TO_NEXT_SERVICE = 13;
    public static final byte PROPERTY_DISTANCE_TO_NEXT_SERVICE = 14;
    public static final byte PROPERTY_TIME_TO_EXHAUST_INSPECTION = 15;
    public static final byte PROPERTY_LAST_ECALL = 16;
    public static final byte PROPERTY_DISTANCE_TO_NEXT_OIL_SERVICE = 17;
    public static final byte PROPERTY_TIME_TO_NEXT_OIL_SERVICE = 18;
    public static final byte PROPERTY_BRAKE_FLUID_REMAINING_DISTANCE = 19;
    public static final byte PROPERTY_BRAKE_FLUID_STATUS = 20;
    public static final byte PROPERTY_BRAKES_SERVICE_DUE_DATES = 22;
    public static final byte PROPERTY_BRAKES_SERVICE_REMAINING_DISTANCES = 23;
    public static final byte PROPERTY_BRAKES_SERVICE_STATUSES = 24;
    public static final byte PROPERTY_DRIVE_IN_INSPECTION_DATE = 25;
    public static final byte PROPERTY_DRIVE_IN_INSPECTION_STATUS = 26;
    public static final byte PROPERTY_NEXT_OIL_SERVICE_DATE = 27;
    public static final byte PROPERTY_NEXT_INSPECTION_DISTANCE_TO = 28;
    public static final byte PROPERTY_LEGAL_INSPECTION_DATE = 29;
    public static final byte PROPERTY_SERVICE_STATUS = 30;
    public static final byte PROPERTY_SERVICE_DATE = 31;
    public static final byte PROPERTY_INSPECTION_STATUS = 32;
    public static final byte PROPERTY_DRIVE_IN_INSPECTION_DISTANCE_TO = 33;
    public static final byte PROPERTY_VEHICLE_CHECK_DATE = 34;
    public static final byte PROPERTY_VEHICLE_CHECK_STATUS = 35;
    public static final byte PROPERTY_VEHICLE_CHECK_DISTANCE_TO = 36;

    public static enum TeleserviceAvailability implements ByteEnum
    {
        PENDING(0),
        IDLE(1),
        SUCCESSFUL(2),
        ERROR(3);

        private final byte value;

        public static TeleserviceAvailability fromByte(byte byteValue) throws CommandParseException {
            TeleserviceAvailability[] values = TeleserviceAvailability.values();
            for (int i = 0; i < values.length; ++i) {
                TeleserviceAvailability state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(TeleserviceAvailability.class.getSimpleName(), byteValue));
        }

        private TeleserviceAvailability(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<Duration> daysToNextService = new Property<Duration>(Duration.class, 1);
        Property<Length> kilometersToNextService = new Property<Length>(Length.class, 2);
        PropertyInteger cbsReportsCount = new PropertyInteger(3, false);
        Property<Duration> monthsToExhaustInspection = new Property<Duration>(Duration.class, 4);
        Property<TeleserviceAvailability> teleserviceAvailability = new Property<TeleserviceAvailability>(TeleserviceAvailability.class, 5);
        Property<Length> serviceDistanceThreshold = new Property<Length>(Length.class, 6);
        Property<Duration> serviceTimeThreshold = new Property<Duration>(Duration.class, 7);
        Property<Calendar> automaticTeleserviceCallDate = new Property<Calendar>(Calendar.class, 8);
        Property<Calendar> teleserviceBatteryCallDate = new Property<Calendar>(Calendar.class, 9);
        Property<Calendar> nextInspectionDate = new Property<Calendar>(Calendar.class, 10);
        List<Property<ConditionBasedService>> conditionBasedServices;
        Property<Calendar> brakeFluidChangeDate = new Property<Calendar>(Calendar.class, 12);
        Property<Duration> timeToNextService = new Property<Duration>(Duration.class, 13);
        Property<Length> distanceToNextService = new Property<Length>(Length.class, 14);
        Property<Duration> timeToExhaustInspection = new Property<Duration>(Duration.class, 15);
        Property<Calendar> lastECall = new Property<Calendar>(Calendar.class, 16);
        Property<Length> distanceToNextOilService = new Property<Length>(Length.class, 17);
        Property<Duration> timeToNextOilService = new Property<Duration>(Duration.class, 18);
        Property<Length> brakeFluidRemainingDistance = new Property<Length>(Length.class, 19);
        Property<ServiceStatus> brakeFluidStatus = new Property<ServiceStatus>(ServiceStatus.class, 20);
        List<Property<BrakeServiceDueDate>> brakesServiceDueDates;
        List<Property<BrakeServiceRemainingDistance>> brakesServiceRemainingDistances;
        List<Property<BrakeServiceStatus>> brakesServiceStatuses;
        Property<Calendar> driveInInspectionDate = new Property<Calendar>(Calendar.class, 25);
        Property<ServiceStatus> driveInInspectionStatus = new Property<ServiceStatus>(ServiceStatus.class, 26);
        Property<Calendar> nextOilServiceDate = new Property<Calendar>(Calendar.class, 27);
        Property<Length> nextInspectionDistanceTo = new Property<Length>(Length.class, 28);
        Property<Calendar> legalInspectionDate = new Property<Calendar>(Calendar.class, 29);
        Property<ServiceStatus> serviceStatus = new Property<ServiceStatus>(ServiceStatus.class, 30);
        Property<Calendar> serviceDate = new Property<Calendar>(Calendar.class, 31);
        Property<ServiceStatus> inspectionStatus = new Property<ServiceStatus>(ServiceStatus.class, 32);
        Property<Length> driveInInspectionDistanceTo = new Property<Length>(Length.class, 33);
        Property<Calendar> vehicleCheckDate = new Property<Calendar>(Calendar.class, 34);
        Property<ServiceStatus> vehicleCheckStatus = new Property<ServiceStatus>(ServiceStatus.class, 35);
        Property<Length> vehicleCheckDistanceTo = new Property<Length>(Length.class, 36);

        @Deprecated
        public Property<Duration> getDaysToNextService() {
            return this.daysToNextService;
        }

        @Deprecated
        public Property<Length> getKilometersToNextService() {
            return this.kilometersToNextService;
        }

        public PropertyInteger getCbsReportsCount() {
            return this.cbsReportsCount;
        }

        @Deprecated
        public Property<Duration> getMonthsToExhaustInspection() {
            return this.monthsToExhaustInspection;
        }

        public Property<TeleserviceAvailability> getTeleserviceAvailability() {
            return this.teleserviceAvailability;
        }

        public Property<Length> getServiceDistanceThreshold() {
            return this.serviceDistanceThreshold;
        }

        public Property<Duration> getServiceTimeThreshold() {
            return this.serviceTimeThreshold;
        }

        public Property<Calendar> getAutomaticTeleserviceCallDate() {
            return this.automaticTeleserviceCallDate;
        }

        public Property<Calendar> getTeleserviceBatteryCallDate() {
            return this.teleserviceBatteryCallDate;
        }

        public Property<Calendar> getNextInspectionDate() {
            return this.nextInspectionDate;
        }

        public List<Property<ConditionBasedService>> getConditionBasedServices() {
            return this.conditionBasedServices;
        }

        public Property<Calendar> getBrakeFluidChangeDate() {
            return this.brakeFluidChangeDate;
        }

        public Property<Duration> getTimeToNextService() {
            return this.timeToNextService;
        }

        public Property<Length> getDistanceToNextService() {
            return this.distanceToNextService;
        }

        public Property<Duration> getTimeToExhaustInspection() {
            return this.timeToExhaustInspection;
        }

        public Property<Calendar> getLastECall() {
            return this.lastECall;
        }

        public Property<Length> getDistanceToNextOilService() {
            return this.distanceToNextOilService;
        }

        public Property<Duration> getTimeToNextOilService() {
            return this.timeToNextOilService;
        }

        public Property<Length> getBrakeFluidRemainingDistance() {
            return this.brakeFluidRemainingDistance;
        }

        public Property<ServiceStatus> getBrakeFluidStatus() {
            return this.brakeFluidStatus;
        }

        public List<Property<BrakeServiceDueDate>> getBrakesServiceDueDates() {
            return this.brakesServiceDueDates;
        }

        public List<Property<BrakeServiceRemainingDistance>> getBrakesServiceRemainingDistances() {
            return this.brakesServiceRemainingDistances;
        }

        public List<Property<BrakeServiceStatus>> getBrakesServiceStatuses() {
            return this.brakesServiceStatuses;
        }

        public Property<Calendar> getDriveInInspectionDate() {
            return this.driveInInspectionDate;
        }

        public Property<ServiceStatus> getDriveInInspectionStatus() {
            return this.driveInInspectionStatus;
        }

        public Property<Calendar> getNextOilServiceDate() {
            return this.nextOilServiceDate;
        }

        public Property<Length> getNextInspectionDistanceTo() {
            return this.nextInspectionDistanceTo;
        }

        public Property<Calendar> getLegalInspectionDate() {
            return this.legalInspectionDate;
        }

        public Property<ServiceStatus> getServiceStatus() {
            return this.serviceStatus;
        }

        public Property<Calendar> getServiceDate() {
            return this.serviceDate;
        }

        public Property<ServiceStatus> getInspectionStatus() {
            return this.inspectionStatus;
        }

        public Property<Length> getDriveInInspectionDistanceTo() {
            return this.driveInInspectionDistanceTo;
        }

        public Property<Calendar> getVehicleCheckDate() {
            return this.vehicleCheckDate;
        }

        public Property<ServiceStatus> getVehicleCheckStatus() {
            return this.vehicleCheckStatus;
        }

        public Property<Length> getVehicleCheckDistanceTo() {
            return this.vehicleCheckDistanceTo;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<ConditionBasedService>> conditionBasedServicesBuilder = new ArrayList<Property<ConditionBasedService>>();
            ArrayList<Property<BrakeServiceDueDate>> brakesServiceDueDatesBuilder = new ArrayList<Property<BrakeServiceDueDate>>();
            ArrayList<Property<BrakeServiceRemainingDistance>> brakesServiceRemainingDistancesBuilder = new ArrayList<Property<BrakeServiceRemainingDistance>>();
            ArrayList<Property<BrakeServiceStatus>> brakesServiceStatusesBuilder = new ArrayList<Property<BrakeServiceStatus>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.daysToNextService.update(p);
                        }
                        case 2: {
                            return this.kilometersToNextService.update(p);
                        }
                        case 3: {
                            return this.cbsReportsCount.update(p);
                        }
                        case 4: {
                            return this.monthsToExhaustInspection.update(p);
                        }
                        case 5: {
                            return this.teleserviceAvailability.update(p);
                        }
                        case 6: {
                            return this.serviceDistanceThreshold.update(p);
                        }
                        case 7: {
                            return this.serviceTimeThreshold.update(p);
                        }
                        case 8: {
                            return this.automaticTeleserviceCallDate.update(p);
                        }
                        case 9: {
                            return this.teleserviceBatteryCallDate.update(p);
                        }
                        case 10: {
                            return this.nextInspectionDate.update(p);
                        }
                        case 11: {
                            Property<ConditionBasedService> conditionBasedService = new Property<ConditionBasedService>(ConditionBasedService.class, p);
                            conditionBasedServicesBuilder.add(conditionBasedService);
                            return conditionBasedService;
                        }
                        case 12: {
                            return this.brakeFluidChangeDate.update(p);
                        }
                        case 13: {
                            return this.timeToNextService.update(p);
                        }
                        case 14: {
                            return this.distanceToNextService.update(p);
                        }
                        case 15: {
                            return this.timeToExhaustInspection.update(p);
                        }
                        case 16: {
                            return this.lastECall.update(p);
                        }
                        case 17: {
                            return this.distanceToNextOilService.update(p);
                        }
                        case 18: {
                            return this.timeToNextOilService.update(p);
                        }
                        case 19: {
                            return this.brakeFluidRemainingDistance.update(p);
                        }
                        case 20: {
                            return this.brakeFluidStatus.update(p);
                        }
                        case 22: {
                            Property<BrakeServiceDueDate> brakeServiceDueDate = new Property<BrakeServiceDueDate>(BrakeServiceDueDate.class, p);
                            brakesServiceDueDatesBuilder.add(brakeServiceDueDate);
                            return brakeServiceDueDate;
                        }
                        case 23: {
                            Property<BrakeServiceRemainingDistance> brakeServiceRemainingDistance = new Property<BrakeServiceRemainingDistance>(BrakeServiceRemainingDistance.class, p);
                            brakesServiceRemainingDistancesBuilder.add(brakeServiceRemainingDistance);
                            return brakeServiceRemainingDistance;
                        }
                        case 24: {
                            Property<BrakeServiceStatus> brakeServiceStatus = new Property<BrakeServiceStatus>(BrakeServiceStatus.class, p);
                            brakesServiceStatusesBuilder.add(brakeServiceStatus);
                            return brakeServiceStatus;
                        }
                        case 25: {
                            return this.driveInInspectionDate.update(p);
                        }
                        case 26: {
                            return this.driveInInspectionStatus.update(p);
                        }
                        case 27: {
                            return this.nextOilServiceDate.update(p);
                        }
                        case 28: {
                            return this.nextInspectionDistanceTo.update(p);
                        }
                        case 29: {
                            return this.legalInspectionDate.update(p);
                        }
                        case 30: {
                            return this.serviceStatus.update(p);
                        }
                        case 31: {
                            return this.serviceDate.update(p);
                        }
                        case 32: {
                            return this.inspectionStatus.update(p);
                        }
                        case 33: {
                            return this.driveInInspectionDistanceTo.update(p);
                        }
                        case 34: {
                            return this.vehicleCheckDate.update(p);
                        }
                        case 35: {
                            return this.vehicleCheckStatus.update(p);
                        }
                        case 36: {
                            return this.vehicleCheckDistanceTo.update(p);
                        }
                    }
                    return null;
                });
            }
            this.conditionBasedServices = conditionBasedServicesBuilder;
            this.brakesServiceDueDates = brakesServiceDueDatesBuilder;
            this.brakesServiceRemainingDistances = brakesServiceRemainingDistancesBuilder;
            this.brakesServiceStatuses = brakesServiceStatusesBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(52);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            @Deprecated
            public Builder setDaysToNextService(Property<Duration> daysToNextService) {
                Property<Duration> property = daysToNextService.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setKilometersToNextService(Property<Length> kilometersToNextService) {
                Property<Length> property = kilometersToNextService.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setCbsReportsCount(Property<Integer> cbsReportsCount) {
                PropertyInteger property = new PropertyInteger(3, false, 1, cbsReportsCount);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setMonthsToExhaustInspection(Property<Duration> monthsToExhaustInspection) {
                Property<Duration> property = monthsToExhaustInspection.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setTeleserviceAvailability(Property<TeleserviceAvailability> teleserviceAvailability) {
                Property<TeleserviceAvailability> property = teleserviceAvailability.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setServiceDistanceThreshold(Property<Length> serviceDistanceThreshold) {
                Property<Length> property = serviceDistanceThreshold.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setServiceTimeThreshold(Property<Duration> serviceTimeThreshold) {
                Property<Duration> property = serviceTimeThreshold.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setAutomaticTeleserviceCallDate(Property<Calendar> automaticTeleserviceCallDate) {
                Property<Calendar> property = automaticTeleserviceCallDate.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setTeleserviceBatteryCallDate(Property<Calendar> teleserviceBatteryCallDate) {
                Property<Calendar> property = teleserviceBatteryCallDate.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            public Builder setNextInspectionDate(Property<Calendar> nextInspectionDate) {
                Property<Calendar> property = nextInspectionDate.setIdentifier((byte)10);
                this.addProperty(property);
                return this;
            }

            public Builder setConditionBasedServices(Property<ConditionBasedService>[] conditionBasedServices) {
                for (int i = 0; i < conditionBasedServices.length; ++i) {
                    this.addConditionBasedService(conditionBasedServices[i]);
                }
                return this;
            }

            public Builder addConditionBasedService(Property<ConditionBasedService> conditionBasedService) {
                conditionBasedService.setIdentifier((byte)11);
                this.addProperty(conditionBasedService);
                return this;
            }

            public Builder setBrakeFluidChangeDate(Property<Calendar> brakeFluidChangeDate) {
                Property<Calendar> property = brakeFluidChangeDate.setIdentifier((byte)12);
                this.addProperty(property);
                return this;
            }

            public Builder setTimeToNextService(Property<Duration> timeToNextService) {
                Property<Duration> property = timeToNextService.setIdentifier((byte)13);
                this.addProperty(property);
                return this;
            }

            public Builder setDistanceToNextService(Property<Length> distanceToNextService) {
                Property<Length> property = distanceToNextService.setIdentifier((byte)14);
                this.addProperty(property);
                return this;
            }

            public Builder setTimeToExhaustInspection(Property<Duration> timeToExhaustInspection) {
                Property<Duration> property = timeToExhaustInspection.setIdentifier((byte)15);
                this.addProperty(property);
                return this;
            }

            public Builder setLastECall(Property<Calendar> lastECall) {
                Property<Calendar> property = lastECall.setIdentifier((byte)16);
                this.addProperty(property);
                return this;
            }

            public Builder setDistanceToNextOilService(Property<Length> distanceToNextOilService) {
                Property<Length> property = distanceToNextOilService.setIdentifier((byte)17);
                this.addProperty(property);
                return this;
            }

            public Builder setTimeToNextOilService(Property<Duration> timeToNextOilService) {
                Property<Duration> property = timeToNextOilService.setIdentifier((byte)18);
                this.addProperty(property);
                return this;
            }

            public Builder setBrakeFluidRemainingDistance(Property<Length> brakeFluidRemainingDistance) {
                Property<Length> property = brakeFluidRemainingDistance.setIdentifier((byte)19);
                this.addProperty(property);
                return this;
            }

            public Builder setBrakeFluidStatus(Property<ServiceStatus> brakeFluidStatus) {
                Property<ServiceStatus> property = brakeFluidStatus.setIdentifier((byte)20);
                this.addProperty(property);
                return this;
            }

            public Builder setBrakesServiceDueDates(Property<BrakeServiceDueDate>[] brakesServiceDueDates) {
                for (int i = 0; i < brakesServiceDueDates.length; ++i) {
                    this.addBrakeServiceDueDate(brakesServiceDueDates[i]);
                }
                return this;
            }

            public Builder addBrakeServiceDueDate(Property<BrakeServiceDueDate> brakeServiceDueDate) {
                brakeServiceDueDate.setIdentifier((byte)22);
                this.addProperty(brakeServiceDueDate);
                return this;
            }

            public Builder setBrakesServiceRemainingDistances(Property<BrakeServiceRemainingDistance>[] brakesServiceRemainingDistances) {
                for (int i = 0; i < brakesServiceRemainingDistances.length; ++i) {
                    this.addBrakeServiceRemainingDistance(brakesServiceRemainingDistances[i]);
                }
                return this;
            }

            public Builder addBrakeServiceRemainingDistance(Property<BrakeServiceRemainingDistance> brakeServiceRemainingDistance) {
                brakeServiceRemainingDistance.setIdentifier((byte)23);
                this.addProperty(brakeServiceRemainingDistance);
                return this;
            }

            public Builder setBrakesServiceStatuses(Property<BrakeServiceStatus>[] brakesServiceStatuses) {
                for (int i = 0; i < brakesServiceStatuses.length; ++i) {
                    this.addBrakeServiceStatus(brakesServiceStatuses[i]);
                }
                return this;
            }

            public Builder addBrakeServiceStatus(Property<BrakeServiceStatus> brakeServiceStatus) {
                brakeServiceStatus.setIdentifier((byte)24);
                this.addProperty(brakeServiceStatus);
                return this;
            }

            public Builder setDriveInInspectionDate(Property<Calendar> driveInInspectionDate) {
                Property<Calendar> property = driveInInspectionDate.setIdentifier((byte)25);
                this.addProperty(property);
                return this;
            }

            public Builder setDriveInInspectionStatus(Property<ServiceStatus> driveInInspectionStatus) {
                Property<ServiceStatus> property = driveInInspectionStatus.setIdentifier((byte)26);
                this.addProperty(property);
                return this;
            }

            public Builder setNextOilServiceDate(Property<Calendar> nextOilServiceDate) {
                Property<Calendar> property = nextOilServiceDate.setIdentifier((byte)27);
                this.addProperty(property);
                return this;
            }

            public Builder setNextInspectionDistanceTo(Property<Length> nextInspectionDistanceTo) {
                Property<Length> property = nextInspectionDistanceTo.setIdentifier((byte)28);
                this.addProperty(property);
                return this;
            }

            public Builder setLegalInspectionDate(Property<Calendar> legalInspectionDate) {
                Property<Calendar> property = legalInspectionDate.setIdentifier((byte)29);
                this.addProperty(property);
                return this;
            }

            public Builder setServiceStatus(Property<ServiceStatus> serviceStatus) {
                Property<ServiceStatus> property = serviceStatus.setIdentifier((byte)30);
                this.addProperty(property);
                return this;
            }

            public Builder setServiceDate(Property<Calendar> serviceDate) {
                Property<Calendar> property = serviceDate.setIdentifier((byte)31);
                this.addProperty(property);
                return this;
            }

            public Builder setInspectionStatus(Property<ServiceStatus> inspectionStatus) {
                Property<ServiceStatus> property = inspectionStatus.setIdentifier((byte)32);
                this.addProperty(property);
                return this;
            }

            public Builder setDriveInInspectionDistanceTo(Property<Length> driveInInspectionDistanceTo) {
                Property<Length> property = driveInInspectionDistanceTo.setIdentifier((byte)33);
                this.addProperty(property);
                return this;
            }

            public Builder setVehicleCheckDate(Property<Calendar> vehicleCheckDate) {
                Property<Calendar> property = vehicleCheckDate.setIdentifier((byte)34);
                this.addProperty(property);
                return this;
            }

            public Builder setVehicleCheckStatus(Property<ServiceStatus> vehicleCheckStatus) {
                Property<ServiceStatus> property = vehicleCheckStatus.setIdentifier((byte)35);
                this.addProperty(property);
                return this;
            }

            public Builder setVehicleCheckDistanceTo(Property<Length> vehicleCheckDistanceTo) {
                Property<Length> property = vehicleCheckDistanceTo.setIdentifier((byte)36);
                this.addProperty(property);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)52, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)52, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 52);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)52, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)52, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(52);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(52, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(52, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

