/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import java.util.ArrayList;
import java.util.List;

public class MultiCommand {
    public static final int IDENTIFIER = 19;
    public static final byte PROPERTY_MULTI_STATES = 1;
    public static final byte PROPERTY_MULTI_COMMANDS = 2;

    public static class State
    extends SetCommand {
        List<Property<Command>> multiStates;

        public List<Property<Command>> getMultiStates() {
            return this.multiStates;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<Command>> multiStatesBuilder = new ArrayList<Property<Command>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            Property<Command> multiState = new Property<Command>(Command.class, p);
                            multiStatesBuilder.add(multiState);
                            return multiState;
                        }
                    }
                    return null;
                });
            }
            this.multiStates = multiStatesBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(19);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setMultiStates(Property<Command>[] multiStates) {
                for (int i = 0; i < multiStates.length; ++i) {
                    this.addMultiState(multiStates[i]);
                }
                return this;
            }

            public Builder addMultiState(Property<Command> multiState) {
                multiState.setIdentifier((byte)1);
                this.addProperty(multiState);
                return this;
            }
        }
    }

    public static class MultiCommandCommand
    extends SetCommand {
        List<Property<Command>> multiCommands;

        public List<Property<Command>> getMultiCommands() {
            return this.multiCommands;
        }

        public MultiCommandCommand(List<Command> multiCommands) {
            super(19);
            ArrayList<Property<Command>> multiCommandsBuilder = new ArrayList<Property<Command>>();
            if (multiCommands != null) {
                for (Command multiCommand : multiCommands) {
                    Property<Command> prop = new Property<Command>(2, multiCommand);
                    multiCommandsBuilder.add(prop);
                    this.addProperty(prop);
                }
            }
            this.multiCommands = multiCommandsBuilder;
            this.createBytes();
        }

        MultiCommandCommand(byte[] bytes) throws PropertyParseException {
            super(bytes);
            ArrayList<Property<Command>> multiCommandsBuilder = new ArrayList<Property<Command>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 2) {
                        Property<Command> multiCommand = new Property<Command>(Command.class, p);
                        multiCommandsBuilder.add(multiCommand);
                        return multiCommand;
                    }
                    return null;
                });
            }
            this.multiCommands = multiCommandsBuilder;
            if (this.multiCommands.size() == 0) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }
}

